/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnav.dao;

import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icslite.business.docnav.dao.IcsDocnavPathDaoHandler;
import com.huawei.support.icslite.business.docnav.dao.IcsDocnavTreeDaoHandler;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavPathDto;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.parse.SaxIcsDocnavTree;
import com.huawei.support.icslite.business.docnav.service.IcsDocnavBusinessService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsDocnavPidDaoHandler
extends BasePool<Map<String, List<IcsDocnavTreeDto>>> {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsDocnavPidDaoHandler.class);

    private IcsDocnavPidDaoHandler() {
    }

    public static IcsDocnavPidDaoHandler getInstance() {
        return IcsDocnavPidDaoHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    public void addPool(String docId, String docnavId, List<IcsDocnavTreeDto> navPidList) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "addPool");
        LinkedHashMap<String, List<IcsDocnavTreeDto>> naviTreePoolMap = (LinkedHashMap<String, List<IcsDocnavTreeDto>>)super.getPool(docId);
        if (naviTreePoolMap == null) {
            naviTreePoolMap = new LinkedHashMap<String, List<IcsDocnavTreeDto>>();
            super.addPool(docId, naviTreePoolMap);
            super.checkPool(5);
        }
        naviTreePoolMap.put(docnavId, navPidList);
    }

    public Map<String, List<IcsDocnavTreeDto>> delPool(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delPool");
        return (Map)super.delPool(docId);
    }

    public void getPool(String docId, String docnavId, String navitemPath, List<IcsDocnavTreeDto> docnavPidList) {
        Map navPidPoolMap = (Map)super.getPool(docId);
        if (navPidPoolMap == null) {
            return;
        }
        List naviTreePidPool = (List)navPidPoolMap.get(docnavId);
        if (naviTreePidPool == null) {
            return;
        }
        for (IcsDocnavTreeDto icsDocnavTreeDto : naviTreePidPool) {
            if (!icsDocnavTreeDto.getNavItemPath().startsWith(navitemPath)) continue;
            docnavPidList.add(icsDocnavTreeDto);
        }
    }

    public List<IcsDocnavTreeDto> getNaviPid(InputStream is, IcsDocnavDo icsDocnavDo, String navitemPath) {
        ArrayList<IcsDocnavTreeDto> docnavPidList = new ArrayList<IcsDocnavTreeDto>();
        ArrayList<IcsDocnavTreeDto> resultdocnavPidList = new ArrayList<IcsDocnavTreeDto>();
        ArrayList<IcsDocnavPathDto> naviPathList = new ArrayList<IcsDocnavPathDto>();
        try {
            SaxIcsDocnavTree saxParser = new SaxIcsDocnavTree(icsDocnavDo, (IcsDocnavBusinessService)SpringContextUtil.getBean((String)"icsDocnavBusinessService"));
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
            String naviTree = saxParser.getNaviTree();
            saxParser.getNavPidList(docnavPidList);
            saxParser.getNaviPathList(naviPathList);
            for (IcsDocnavTreeDto icsDocnavTreeDto : docnavPidList) {
                if (!icsDocnavTreeDto.getNavItemPath().startsWith(navitemPath)) continue;
                resultdocnavPidList.add(icsDocnavTreeDto);
            }
            IcsDocnavTreeDaoHandler.getInstance().addPool(icsDocnavDo.getDocId(), icsDocnavDo.getDocnavId(), naviTree);
            IcsDocnavPathDaoHandler.getInstance().addPool(icsDocnavDo.getDocId(), icsDocnavDo.getDocnavId(), naviPathList);
            this.addPool(icsDocnavDo.getDocId(), icsDocnavDo.getDocnavId(), docnavPidList);
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return resultdocnavPidList;
    }

    private static class IcsDocnavPidDaoHandlerHolder {
        private static final IcsDocnavPidDaoHandler INSTANCE = new IcsDocnavPidDaoHandler();

        private IcsDocnavPidDaoHandlerHolder() {
        }
    }
}

