/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnav.dao;

import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.navi.util.SpringContextUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.BasePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icslite.business.docnav.dao.IcsDocnavPathDaoHandler;
import com.huawei.support.icslite.business.docnav.dao.IcsDocnavPidDaoHandler;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavPathDto;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.parse.SaxIcsDocnavTree;
import com.huawei.support.icslite.business.docnav.service.IcsDocnavBusinessService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsDocnavTreeDaoHandler
extends BasePool<Map<String, String>> {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsDocnavTreeDaoHandler.class);

    private IcsDocnavTreeDaoHandler() {
    }

    public static IcsDocnavTreeDaoHandler getInstance() {
        return IcsDocnavTreeDaoHandlerHolder.INSTANCE;
    }

    protected void createPool(String key) {
    }

    public void addPool(String docId, String docnavId, String naviTree) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "addPool");
        LinkedHashMap<String, String> naviTreePoolMap = (LinkedHashMap<String, String>)super.getPool(docId);
        if (naviTreePoolMap == null) {
            naviTreePoolMap = new LinkedHashMap<String, String>();
            super.addPool(docId, naviTreePoolMap);
            super.checkPool(5);
        }
        naviTreePoolMap.put(docnavId, naviTree);
    }

    public Map<String, String> delPool(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delPool");
        return (Map)super.delPool(docId);
    }

    public String getPool(String docId, String docnavId) {
        Map naviTreePoolMap = (Map)super.getPool(docId);
        String result = null;
        if (naviTreePoolMap != null) {
            result = (String)naviTreePoolMap.get(docnavId);
        }
        return result;
    }

    public String getNaviTree(InputStream is, IcsDocnavDo icsDocnavDo) {
        String naviTree = "";
        ArrayList<IcsDocnavTreeDto> navPidList = new ArrayList<IcsDocnavTreeDto>();
        ArrayList<IcsDocnavPathDto> naviPathList = new ArrayList<IcsDocnavPathDto>();
        try {
            SaxIcsDocnavTree saxParser = new SaxIcsDocnavTree(icsDocnavDo, (IcsDocnavBusinessService)SpringContextUtil.getBean((String)"icsDocnavBusinessService"));
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
            naviTree = saxParser.getNaviTree();
            saxParser.getNavPidList(navPidList);
            saxParser.getNaviPathList(naviPathList);
            this.addPool(icsDocnavDo.getDocId(), icsDocnavDo.getDocnavId(), naviTree);
            IcsDocnavPidDaoHandler.getInstance().addPool(icsDocnavDo.getDocId(), icsDocnavDo.getDocnavId(), navPidList);
            IcsDocnavPathDaoHandler.getInstance().addPool(icsDocnavDo.getDocId(), icsDocnavDo.getDocnavId(), naviPathList);
        }
        catch (SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "create  SAXException", (Throwable)e);
        }
        return naviTree;
    }

    private static class IcsDocnavTreeDaoHandlerHolder {
        private static final IcsDocnavTreeDaoHandler INSTANCE = new IcsDocnavTreeDaoHandler();

        private IcsDocnavTreeDaoHandlerHolder() {
        }
    }
}

