/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnav.parse;

import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavPathDto;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.service.IcsDocnavBusinessService;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxIcsDocnavTree
extends DefaultHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SaxIcsDocnavTree.class);
    private final Set<IcsDocnavTreeDto> icsDocnavPidSet = new LinkedHashSet<IcsDocnavTreeDto>();
    private final List<IcsDocnavPathDto> icsNaviPathList = new LinkedList<IcsDocnavPathDto>();
    private final IcsDocnavBusinessService icsDocnavBusinessService;
    private final IcsDocnavDo icsDocnavDo;
    private final Stack<Integer> qNameStack = new Stack();
    private IcsDocnavTreeDto nowDocCategory = null;
    private IcsDocnavTreeDto lastDocCategory = null;
    private boolean isUlStart = false;
    private boolean isUlEnd = false;
    private int nowIndex = 1;
    private String resultStr = "";

    public SaxIcsDocnavTree(IcsDocnavDo icsDocnavDo, IcsDocnavBusinessService icsIcsDocnavBusinessService) {
        this.icsDocnavDo = icsDocnavDo;
        this.icsDocnavBusinessService = icsIcsDocnavBusinessService;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        switch (qName) {
            case "navItem": {
                this.setNavItem(atts);
                break;
            }
            case "docCategory": {
                this.setDocCategory(atts);
                break;
            }
            case "doc": {
                this.setDoc(atts);
                break;
            }
        }
    }

    private void setNavItem(Attributes atts) {
        this.qNameStack.add(this.nowIndex);
        String name = atts.getValue("value");
        String itemPath = this.replaceChar(Arrays.toString((Object[])this.qNameStack.toArray(new Integer[0])));
        this.createNavItem(name, itemPath);
        this.createDocCategory(name, itemPath);
        this.nowDocCategory = null;
    }

    private void setDocCategory(Attributes atts) {
        this.qNameStack.add(this.nowIndex);
        String name = atts.getValue("name");
        String itemPath = this.replaceChar(Arrays.toString((Object[])this.qNameStack.toArray(new Integer[0])));
        this.createNavItem(name, itemPath);
        this.createDocCategory(name, itemPath);
        this.nowDocCategory = this.lastDocCategory;
        this.icsDocnavPidSet.add(this.nowDocCategory);
    }

    private String replaceChar(String itemPath) {
        return itemPath.replace("[", "").replace("]", "").replace(", ", ".") + ".";
    }

    private void createNavItem(String name, String itemPath) {
        this.resultStr = this.resultStr + (this.isUlStart ? "<ul>" : "");
        this.resultStr = this.resultStr + "<li navItempath='" + itemPath + "' >";
        String newNavItemName = name.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace(" ", "&nbsp;");
        this.resultStr = this.resultStr + "<a title='" + name + "'>" + newNavItemName + "</a>";
        IcsDocnavPathDto icsDocnavPathDto = new IcsDocnavPathDto();
        icsDocnavPathDto.setNavItemName(name);
        icsDocnavPathDto.setNavItemPath(itemPath);
        this.icsNaviPathList.add(icsDocnavPathDto);
        this.isUlStart = true;
        this.isUlEnd = false;
        this.nowIndex = 1;
    }

    private void createDocCategory(String name, String itemPath) {
        IcsDocnavTreeDto icsDocnavTreeDto = new IcsDocnavTreeDto();
        icsDocnavTreeDto.setType("docCategory");
        icsDocnavTreeDto.setName(name);
        icsDocnavTreeDto.setNavItemPath(itemPath);
        this.lastDocCategory = icsDocnavTreeDto;
    }

    private void setDoc(Attributes atts) {
        String type;
        if (this.nowDocCategory == null) {
            if (this.lastDocCategory == null) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "SaxIcsDocnavTree error XML for nowIcsDocnavTreeDTO is null.");
                return;
            }
            this.nowDocCategory = this.lastDocCategory;
            this.icsDocnavPidSet.add(this.nowDocCategory);
        }
        if ("static".equals(type = atts.getValue("type"))) {
            this.setStaticDoc(atts);
        } else if ("dynamic".equals(type)) {
            this.setDynamicDoc(atts);
        } else {
            this.setStaticDoc(atts);
        }
    }

    private void setStaticDoc(Attributes atts) {
        atts.getValue("name");
        String pidId = atts.getValue("id");
        IcsPidDo icsPidDto = this.icsDocnavBusinessService.getPidOne(this.icsDocnavDo.getDocId(), pidId);
        if (icsPidDto != null) {
            IcsDocnavTreeDto icsDocnavTreeDto = new IcsDocnavTreeDto();
            icsDocnavTreeDto.setType("doc");
            icsDocnavTreeDto.setName(icsPidDto.getPidName());
            icsDocnavTreeDto.setIcsPidDo(icsPidDto);
            this.nowDocCategory.addIcsPid(icsDocnavTreeDto);
        } else {
            icsPidDto = this.icsDocnavBusinessService.getPidWithVersionrelation(this.icsDocnavDo.getDocId(), pidId);
            if (icsPidDto != null) {
                IcsDocnavTreeDto icsDocnavTreeDto = new IcsDocnavTreeDto();
                icsDocnavTreeDto.setType("doc");
                icsDocnavTreeDto.setName(icsPidDto.getPidName());
                icsDocnavTreeDto.setIcsPidDo(icsPidDto);
                this.nowDocCategory.addIcsPid(icsDocnavTreeDto);
            }
        }
    }

    private void setDynamicDoc(Attributes atts) {
        String includeMetaValueId = atts.getValue("includemetavalueid");
        if (StringUtils.isBlank((CharSequence)includeMetaValueId)) {
            CodeCCUtils.INSTANCE.debugLog(LOG, "setDynamicDoc error, includemetavalueid is null");
            return;
        }
        Set<IcsPidDo> icsPidSet = this.getDynamicDocPid(includeMetaValueId);
        LinkedHashSet<String> icsPididSet = new LinkedHashSet<String>();
        String name = atts.getValue("name");
        for (IcsPidDo icsPidDto : icsPidSet) {
            if (!icsPididSet.add(icsPidDto.getDocId() + "," + icsPidDto.getPidId())) continue;
            IcsDocnavTreeDto icsDocnavTreeDto = new IcsDocnavTreeDto();
            icsDocnavTreeDto.setType("doc");
            icsDocnavTreeDto.setName(name);
            icsDocnavTreeDto.setIcsPidDo(icsPidDto);
            this.nowDocCategory.addIcsPid(icsDocnavTreeDto);
        }
    }

    private Set<IcsPidDo> getDynamicDocPid(String includeMetaValueId) {
        String[] includeMetaValueIds;
        TreeSet<IcsPidDo> icsPidSet = new TreeSet<IcsPidDo>((o1, o2) -> {
            if (StringUtils.equals((CharSequence)o1.getPidName(), (CharSequence)o2.getPidName())) {
                return 1;
            }
            return Collator.getInstance(Locale.ENGLISH).compare(o1.getPidName(), o2.getPidName());
        });
        for (String metaValueId : includeMetaValueIds = includeMetaValueId.trim().split(";")) {
            String[] metaValueIds = metaValueId.trim().split(",");
            Set<IcsPidDo> icsPidDos = this.getPidByMetaValueId(metaValueIds);
            if (CollectionUtils.isEmpty(icsPidSet)) {
                icsPidSet.addAll(icsPidDos);
                continue;
            }
            this.retainAll(icsPidSet, icsPidDos);
            if (!CollectionUtils.isEmpty(icsPidSet)) continue;
            return Collections.emptySet();
        }
        return icsPidSet;
    }

    private boolean retainAll(Set<IcsPidDo> icsPidOldSet, Set<IcsPidDo> icsPidDoList) {
        icsPidOldSet.removeIf(icsPidDo -> icsPidDoList.stream().noneMatch(pidDo -> StringUtils.equals((CharSequence)icsPidDo.getPidId(), (CharSequence)pidDo.getPidId())));
        return CollectionUtils.isEmpty(icsPidOldSet);
    }

    private Set<IcsPidDo> getPidByMetaValueId(String[] metaValueIds) {
        LinkedHashSet<IcsPidDo> icsPidOldSet = new LinkedHashSet<IcsPidDo>();
        String docId = this.icsDocnavDo.getDocId();
        for (String metaValueId : metaValueIds) {
            List<IcsPidDo> icsPidDoList = this.icsDocnavBusinessService.getPidByMetaValue(docId, metaValueId);
            icsPidDoList.addAll(this.icsDocnavBusinessService.getPidByMetaValueWithVersionrelation(docId, metaValueId));
            icsPidOldSet.addAll(icsPidDoList);
        }
        return icsPidOldSet;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        switch (qName) {
            case "navItem": {
                this.nowIndex = this.qNameStack.pop();
                ++this.nowIndex;
                this.resultStr = this.resultStr + (this.isUlEnd ? "</ul></li>" : "</li>");
                this.isUlStart = false;
                this.isUlEnd = true;
                this.lastDocCategory = null;
                this.nowDocCategory = null;
                break;
            }
            case "docCategory": {
                this.nowIndex = this.qNameStack.pop();
                ++this.nowIndex;
                this.resultStr = this.resultStr + (this.isUlEnd ? "</ul></li>" : "</li>");
                this.isUlStart = false;
                this.isUlEnd = true;
                this.nowDocCategory = null;
                break;
            }
        }
    }

    public String getNaviTree() {
        return this.resultStr;
    }

    public void getNavPidList(List<IcsDocnavTreeDto> naviTreePid) {
        naviTreePid.addAll(this.icsDocnavPidSet);
    }

    public void getNaviPathList(List<IcsDocnavPathDto> naviPathList) {
        naviPathList.addAll(this.icsNaviPathList);
    }
}

