/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnav.serviceimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.hwics.common.docnav.dto.IcsDocnavDo;
import com.huawei.support.icscbb.hwics.common.docnav.service.impl.IcsDocnavPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.service.impl.IcsPidPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl.IcsVersionRelationPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.meta.dto.IcsMetaValueDo;
import com.huawei.support.icscbb.hwics.common.meta.service.impl.IcsMetaValuePoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icslite.business.docnav.dao.IcsDocnavPathDaoHandler;
import com.huawei.support.icslite.business.docnav.dao.IcsDocnavPidDaoHandler;
import com.huawei.support.icslite.business.docnav.dao.IcsDocnavTreeDaoHandler;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavDto;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavPathDto;
import com.huawei.support.icslite.business.docnav.dto.IcsDocnavTreeDto;
import com.huawei.support.icslite.business.docnav.dto.mapper.IcsDocnavConverter;
import com.huawei.support.icslite.business.docnav.service.IcsDocnavBusinessService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsDocnavBusinessServiceHandler
implements IcsDocnavBusinessService {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsDocnavBusinessServiceHandler.class);
    private static final TypeReference<LinkedHashMap<String, String>> LINKED_HASHMAP_REFERENCE = new TypeReference<LinkedHashMap<String, String>>(){};

    private IcsDocnavBusinessServiceHandler() {
    }

    public static IcsDocnavBusinessServiceHandler getInstance() {
        return IcsDocnavBusinessServiceHandlerHolder.INSTANCE;
    }

    @Override
    public IcsPidDo getPidOne(String docId, String pidId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getPidOne, docId: " + docId + ",pidId:" + pidId);
        if (docId == null || pidId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or pidId is null.");
            return null;
        }
        return IcsPidPoolServiceHandler.getInstance().getOne(docId, pidId);
    }

    @Override
    public IcsPidDo getPidWithVersionrelation(String docId, String pidId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getPidWithVersionrelation, docId: " + docId + ",pidId:" + pidId);
        if (docId == null || pidId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or pidId is null.");
            return null;
        }
        IcsPidDo result = null;
        List docIdList = IcsVersionRelationPoolServiceHandler.getInstance().getRelationDocIcList(docId);
        for (String childDocId : docIdList) {
            IcsPidDo icsPidDto = IcsPidPoolServiceHandler.getInstance().getOne(childDocId, pidId);
            if (icsPidDto == null) continue;
            result = icsPidDto;
            break;
        }
        return result;
    }

    @Override
    public List<IcsPidDo> getPidByMetaName(String docId, String metaName) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getPidByMetaName, docId: " + docId + ",metaName:" + metaName);
        ArrayList<IcsPidDo> icsPidList = new ArrayList<IcsPidDo>();
        if (docId == null || metaName == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaName is null.");
            return icsPidList;
        }
        icsPidList.addAll(IcsPidPoolServiceHandler.getInstance().getbyMetaName(docId, metaName));
        return icsPidList;
    }

    @Override
    public List<IcsPidDo> getPidByMetaValue(String docId, String metaValue) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getPidByMetaValue, docId: " + docId + ",metaValue:" + metaValue);
        ArrayList<IcsPidDo> icsPidList = new ArrayList<IcsPidDo>();
        if (docId == null || metaValue == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaValue is null.");
            return icsPidList;
        }
        icsPidList.addAll(IcsPidPoolServiceHandler.getInstance().getbyMetaValue(docId, metaValue));
        return icsPidList;
    }

    @Override
    public List<IcsPidDo> getPidByMetaValueWithVersionrelation(String docId, String metaValue) {
        ArrayList<IcsPidDo> icsPidList = new ArrayList<IcsPidDo>();
        CodeCCUtils.INSTANCE.debugLog(LOG, "getPidByMetaValueWithVersionrelation, docId: " + docId + ",metaValue:" + metaValue);
        if (docId == null || metaValue == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or metaValue is null.");
            return icsPidList;
        }
        List docIdList = IcsVersionRelationPoolServiceHandler.getInstance().getRelationDocIcList(docId);
        for (String childDocId : docIdList) {
            icsPidList.addAll(IcsPidPoolServiceHandler.getInstance().getbyMetaValue(childDocId, metaValue));
        }
        return icsPidList;
    }

    @Override
    public void delTreeAndPidPool(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "delTreeAndPidPool, docId: " + docId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return;
        }
        IcsDocnavPathDaoHandler.getInstance().delPool(docId);
        IcsDocnavPidDaoHandler.getInstance().delPool(docId);
        IcsDocnavTreeDaoHandler.getInstance().delPool(docId);
    }

    @Override
    public Map<String, String> getTreeAndPid(String docId, String docnavId) {
        LinkedHashMap<String, String> naviTreeMap = new LinkedHashMap<String, String>();
        CodeCCUtils.INSTANCE.debugLog(LOG, String.format(Locale.ENGLISH, "getTreeAndPid, docId:%s, docnavId:%s", docId, docnavId));
        if (docId == null || docnavId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return naviTreeMap;
        }
        naviTreeMap.put("treeResult", this.getNaviTree(docId, docnavId));
        naviTreeMap.put("pidSet", JSON.toJSONString(this.getNaviPid(docId, docnavId, null)));
        return naviTreeMap;
    }

    @Override
    public String getNaviTree(String docId, String docnavId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, String.format(Locale.ENGLISH, "getNaviTree, docId:%s, docnavId:%s", docId, docnavId));
        if (docId == null || docnavId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId or docnavId is null.");
            return null;
        }
        String naviTree = null;
        String naviTreePool = IcsDocnavTreeDaoHandler.getInstance().getPool(docId, docnavId);
        if (naviTreePool != null) {
            naviTree = naviTreePool;
        } else {
            IcsDocnavDo icsDocnavDo = this.getbyDocNavId(docId, docnavId);
            if (icsDocnavDo == null) {
                return "";
            }
            try (InputStream is = ZipFilePool.getInputStream((String)icsDocnavDo.getPath(), (String)icsDocnavDo.getDocnavPath());){
                if (is != null) {
                    naviTree = IcsDocnavTreeDaoHandler.getInstance().getNaviTree(is, icsDocnavDo);
                }
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error", (Throwable)e);
            }
        }
        return naviTree;
    }

    @Override
    public List<IcsDocnavTreeDto> getNaviPid(String docId, String docnavId, String navitemPath) {
        String naviTreePool;
        CodeCCUtils.INSTANCE.debugLog(LOG, "GetNaviPid. docId:{0}, docnavId:{1}, navitemPath:{2}", new Object[]{docId, docnavId, navitemPath});
        ArrayList<IcsDocnavTreeDto> naviTreePid = new ArrayList<IcsDocnavTreeDto>();
        if (docId == null || docnavId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "DocId or docnavId is null.");
            return naviTreePid;
        }
        String newNavitemPath = navitemPath;
        if (newNavitemPath == null) {
            newNavitemPath = "";
        }
        if ((naviTreePool = IcsDocnavTreeDaoHandler.getInstance().getPool(docId, docnavId)) != null) {
            IcsDocnavPidDaoHandler.getInstance().getPool(docId, docnavId, newNavitemPath, naviTreePid);
        } else {
            IcsDocnavDo icsDocnavDo = this.getbyDocNavId(docId, docnavId);
            if (icsDocnavDo == null) {
                return naviTreePid;
            }
            try (InputStream is = ZipFilePool.getInputStream((String)icsDocnavDo.getPath(), (String)icsDocnavDo.getDocnavPath());){
                if (is != null) {
                    naviTreePid.addAll(IcsDocnavPidDaoHandler.getInstance().getNaviPid(is, icsDocnavDo, newNavitemPath));
                }
            }
            catch (IOException e) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "zipFile getInputStream error", (Throwable)e);
            }
        }
        return naviTreePid;
    }

    @Override
    public IcsDocnavDo getbyDocNavId(String docId, String docnavId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getbyDocNavId, docId: " + docId + " , docnavId:" + docnavId);
        if (docId == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return null;
        }
        return IcsDocnavPoolServiceHandler.getInstance().getByDocNavId(docId, docnavId);
    }

    @Override
    public List<IcsDocnavTreeDto> getPid(String docId, String docnavId, String navitemPath) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "GetPid. docId:{0}, docnavId:{1}, navitemPath:{2}", new Object[]{docId, docnavId, navitemPath});
        return this.getNaviPid(docId, docnavId, navitemPath);
    }

    @Override
    public List<IcsDocnavPathDto> getParentsNavi(String docId, String docnavId, String navitemPath) {
        ArrayList<IcsDocnavPathDto> naviItemParentsList = new ArrayList<IcsDocnavPathDto>();
        CodeCCUtils.INSTANCE.debugLog(LOG, "GetParentsNavi. docId:{0}, docnavId:{1}, navitemPath:{2}", new Object[]{docId, docnavId, navitemPath});
        if (docId == null || docnavId == null || navitemPath == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Either docId, docnavId, or navitemPath is empty.");
            return naviItemParentsList;
        }
        String naviTreePool = this.getNaviTree(docId, docnavId);
        if (naviTreePool != null) {
            naviItemParentsList.addAll(IcsDocnavPathDaoHandler.getInstance().getParentsNavi(docId, docnavId, navitemPath));
        }
        return naviItemParentsList;
    }

    @Override
    public List<IcsDocnavPathDto> getBrotherNavi(String docId, String docnavId, String navitemPath) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "GetParentsNavi. docId:{0}, docnavId:{1}, navitemPath:{2}", new Object[]{docId, docnavId, navitemPath});
        ArrayList<IcsDocnavPathDto> naviItemParentsList = new ArrayList<IcsDocnavPathDto>();
        if (docId == null || docnavId == null || navitemPath == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Either docId, docnavId, or navitemPath is empty.");
            return naviItemParentsList;
        }
        String naviTreePool = this.getNaviTree(docId, docnavId);
        if (naviTreePool != null) {
            naviItemParentsList.addAll(IcsDocnavPathDaoHandler.getInstance().getBrotherNavi(docId, docnavId, navitemPath));
        }
        return naviItemParentsList;
    }

    @Override
    public List<IcsMetaValueDo> getMetaValueIdList(String docId, String docnavId, String metaNameId) {
        ArrayList<IcsMetaValueDo> icsMetaValueDtoList = new ArrayList<IcsMetaValueDo>();
        String metavalueidlist = "";
        String filterJson = IcsDocnavPoolServiceHandler.getInstance().getFilterByDocNaviId(docId, docnavId);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            return icsMetaValueDtoList;
        }
        JSONArray jsonArray = JSON.parseArray((String)filterJson);
        if (jsonArray == null) {
            return icsMetaValueDtoList;
        }
        int size = jsonArray.size();
        for (int num = 0; num < size; ++num) {
            JSONObject jsonObject = jsonArray.getJSONObject(num);
            String id = jsonObject.getString("metanameid");
            if (!StringUtils.equals((CharSequence)metaNameId, (CharSequence)id)) continue;
            metavalueidlist = jsonObject.getString("metavalueidlist");
        }
        LinkedHashMap jsonMap = Optional.ofNullable(JSON.parseObject((String)metavalueidlist, LINKED_HASHMAP_REFERENCE, (Feature[])new Feature[0])).orElse(new LinkedHashMap());
        if (MapUtils.isEmpty(jsonMap) && StringUtils.isNotBlank((CharSequence)metaNameId)) {
            return IcsMetaValuePoolServiceHandler.getInstance().getByMetaNameId(docId, metaNameId);
        }
        for (Map.Entry entry : jsonMap.entrySet()) {
            IcsMetaValueDo icsMetaValueDto = new IcsMetaValueDo();
            icsMetaValueDto.setMetaNameId(metaNameId);
            icsMetaValueDto.setMetaValueId((String)entry.getKey());
            icsMetaValueDto.setMetaValue((String)entry.getValue());
            icsMetaValueDtoList.add(icsMetaValueDto);
        }
        return icsMetaValueDtoList;
    }

    @Override
    public List<IcsDocnavDto> getDocnavDoList(String docId) {
        CodeCCUtils.INSTANCE.debugLog(LOG, "getDocnavDoList, docId: " + docId);
        ArrayList<IcsDocnavDto> icsDocnavDos = new ArrayList<IcsDocnavDto>();
        if (StringUtils.isEmpty((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "docId is null.");
            return icsDocnavDos;
        }
        return IcsDocnavConverter.INSTANCE.domainDtos(IcsDocnavPoolServiceHandler.getInstance().get(docId));
    }

    private static class IcsDocnavBusinessServiceHandlerHolder {
        private static final IcsDocnavBusinessServiceHandler INSTANCE = new IcsDocnavBusinessServiceHandler();

        private IcsDocnavBusinessServiceHandlerHolder() {
        }
    }
}

