/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnote.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.docnote.dto.DocNoteExcelDto;
import com.huawei.support.icslite.business.libmanage.serviceimpl.HdxManageServiceHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class DocNoteExcelDtoListener<T extends DocNoteExcelDto>
implements ReadListener<T> {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DocNoteExcelDtoListener.class);
    protected static final int BATCH_COUNT = 50;
    private static final Pattern TITLE_PATTERN = Pattern.compile("^[^|`<>\\\\\"']+$");
    protected List<T> cachedDataList = new ArrayList<T>();
    protected int importSize = 0;

    public void invoke(T data, AnalysisContext context) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{((DocNoteExcelDto)data).getProductName(), ((DocNoteExcelDto)data).getProductV()}) || this.isInvalidTitle(((DocNoteExcelDto)data).getTitle())) {
            return;
        }
        this.cachedDataList.add(data);
        ++this.importSize;
        if (this.cachedDataList.size() >= 50) {
            this.saveData();
            this.cachedDataList.clear();
        }
    }

    protected boolean isInvalidTitle(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            return true;
        }
        return !TITLE_PATTERN.matcher(title).matches();
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        CodeCCUtils.INSTANCE.infoLog(log, "Import DocNote has done,import size is {0}", new Object[]{this.importSize});
    }

    protected abstract void saveData();

    protected boolean existHdxDoc(String libId, String libV, String lang) {
        HdxContentDo hdxContentDo = new HdxContentDo();
        hdxContentDo.setLibId(libId);
        hdxContentDo.setLibV(libV);
        hdxContentDo.setLang(lang);
        return HdxManageServiceHandler.getInstance().findHdx(hdxContentDo);
    }
}

