/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnote.excel;

import com.huawei.support.icslite.business.docnote.dto.DocNoteExcelDto;
import com.huawei.support.icslite.business.docnote.excel.DocNoteExcelDtoListener;
import com.huawei.support.icslite.business.docnote.mapper.DocNoteConverter;
import com.huawei.support.icslite.business.docnote.util.DocNoteUtils;
import com.huawei.support.icslite.docnote.dto.DocNoteDo;
import com.huawei.support.icslite.docnote.service.impl.DocNoteServiceHandler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HedexDocNoteListener
extends DocNoteExcelDtoListener<DocNoteExcelDto> {
    private static final Pattern PATTERN = Pattern.compile("\\(([^)]*)\\)");

    @Override
    protected void saveData() {
        this.cachedDataList.forEach(docNoteExcelDto -> {
            docNoteExcelDto.setRemarkId(DocNoteUtils.createRemarkId());
            this.subStringLongerValue((DocNoteExcelDto)docNoteExcelDto);
        });
        List<DocNoteDo> docNoteDos = DocNoteConverter.INSTANCE.excelDtoToDomainList(this.cachedDataList);
        this.handlerParameter(docNoteDos);
        DocNoteServiceHandler.getInstance().insertOrUpdateDocNotes(docNoteDos);
    }

    private void subStringLongerValue(DocNoteExcelDto docNoteExcelDto) {
        String content;
        String title = docNoteExcelDto.getTitle();
        if (StringUtils.isNotBlank((CharSequence)title) && title.length() > 100) {
            docNoteExcelDto.setTitle(title.substring(0, 100));
        }
        if (StringUtils.isNotBlank((CharSequence)(content = docNoteExcelDto.getContent())) && content.length() > 1000) {
            docNoteExcelDto.setContent(content.substring(0, 1000));
        }
    }

    private void handlerParameter(List<DocNoteDo> list) {
        list.forEach(docNoteDo -> {
            docNoteDo.setLibType("HDX");
            this.setLibVAndIssueDate((DocNoteDo)docNoteDo);
            this.setDeleteFlag((DocNoteDo)docNoteDo);
        });
    }

    private void setLibVAndIssueDate(DocNoteDo docNoteDo) {
        String libVStr = docNoteDo.getLibV();
        Matcher matcher = PATTERN.matcher(libVStr);
        if (matcher.find()) {
            docNoteDo.setLibV(libVStr.substring(0, libVStr.lastIndexOf("(")));
            docNoteDo.setIssueDate(matcher.group(1));
        }
    }

    private void setDeleteFlag(DocNoteDo docNoteDo) {
        docNoteDo.setDeleteFlag("1");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docNoteDo.getLibId(), docNoteDo.getLibV()})) {
            return;
        }
        if (this.existHdxDoc(docNoteDo.getLibId(), docNoteDo.getLibV(), "zh")) {
            docNoteDo.setLang("zh");
            docNoteDo.setDeleteFlag("0");
            return;
        }
        if (this.existHdxDoc(docNoteDo.getLibId(), docNoteDo.getLibV(), "en")) {
            docNoteDo.setLang("en");
            docNoteDo.setDeleteFlag("0");
        }
    }
}

