/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnote.excel;

import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icslite.business.docnote.dto.LiteDocNoteExcelDto;
import com.huawei.support.icslite.business.docnote.excel.DocNoteExcelDtoListener;
import com.huawei.support.icslite.business.docnote.mapper.DocNoteConverter;
import com.huawei.support.icslite.business.docnote.util.DocNoteUtils;
import com.huawei.support.icslite.business.libmanage.serviceimpl.IcsManageServiceHandler;
import com.huawei.support.icslite.docnote.dto.DocNoteDo;
import com.huawei.support.icslite.docnote.service.impl.DocNoteServiceHandler;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LiteDocNoteListener
extends DocNoteExcelDtoListener<LiteDocNoteExcelDto> {
    @Override
    protected void saveData() {
        this.cachedDataList.removeIf(data -> StringUtils.equalsIgnoreCase((CharSequence)data.getLibType(), (CharSequence)"ICS") && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{data.getMainPidId(), data.getPidId()}));
        this.cachedDataList.forEach(liteDocNoteExcelDto -> {
            String remarkId = liteDocNoteExcelDto.getRemarkId();
            if (StringUtils.isBlank((CharSequence)remarkId) || StringUtils.length((CharSequence)remarkId) != 36) {
                liteDocNoteExcelDto.setRemarkId(DocNoteUtils.createRemarkId());
            }
        });
        List<DocNoteDo> docNoteDos = DocNoteConverter.INSTANCE.liteExcelDtoToDomainList(this.cachedDataList);
        docNoteDos.forEach(this::setDeleteFlag);
        DocNoteServiceHandler.getInstance().insertOrUpdateDocNotes(docNoteDos);
    }

    private void setDeleteFlag(DocNoteDo docNoteDo) {
        docNoteDo.setDeleteFlag("1");
        if (StringUtils.isBlank((CharSequence)docNoteDo.getLibType())) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)docNoteDo.getLibType(), (CharSequence)"HDX")) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docNoteDo.getLibId(), docNoteDo.getLibV(), docNoteDo.getLang()})) {
                return;
            }
            docNoteDo.setDeleteFlag(this.existHdxDoc(docNoteDo.getLibId(), docNoteDo.getLibV(), docNoteDo.getLang()) ? "0" : "1");
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)docNoteDo.getLibType(), (CharSequence)"ICS")) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docNoteDo.getProjectId(), docNoteDo.getLang(), docNoteDo.getIssueDate()})) {
                return;
            }
            docNoteDo.setDeleteFlag(this.existIcsDoc(docNoteDo.getProjectId(), docNoteDo.getLibV(), docNoteDo.getLang(), docNoteDo.getIssueDate()) ? "0" : "1");
        }
    }

    private boolean existIcsDoc(String projectId, String libV, String lang, String issueDate) {
        IcsContentDo icsContentDo = new IcsContentDo();
        icsContentDo.setProjectid(projectId);
        icsContentDo.setLibV(libV);
        icsContentDo.setLang(lang);
        icsContentDo.setIssueDate(issueDate);
        return IcsManageServiceHandler.getInstance().findIcs(icsContentDo);
    }
}

