/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnote.mapper;

import com.huawei.support.icscbb.util.date.DateUtils;
import com.huawei.support.icslite.business.docnote.dto.DocNoteDto;
import com.huawei.support.icslite.business.docnote.dto.DocNoteExcelDto;
import com.huawei.support.icslite.business.docnote.dto.LiteDocNoteExcelDto;
import com.huawei.support.icslite.business.docnote.dto.QueryHomeNoteDto;
import com.huawei.support.icslite.docnote.dto.DocNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryHdxNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryHomeNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryIcsNoteDo;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper
public interface DocNoteConverter {
    public static final DateTimeFormatter DATE_TIME_FORMATTER_DAY = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER_SECOND = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DocNoteConverter INSTANCE = (DocNoteConverter)Mappers.getMapper(DocNoteConverter.class);

    public DocNoteDto domainToDto(DocNoteDo var1);

    public List<DocNoteDto> domainToDtoList(List<DocNoteDo> var1);

    public DocNoteDo domainToDo(DocNoteDto var1);

    public QueryIcsNoteDo domainToIcsQueryDo(DocNoteDto var1);

    public QueryHdxNoteDo domainToHdxQueryDo(DocNoteDto var1);

    @Mappings(value={@Mapping(source="endTime", target="endTime", qualifiedByName={"convertEndTimeString"}), @Mapping(source="searchNoteKey", target="searchNoteKey", qualifiedByName={"addFuzzyQuerySign"})})
    public QueryHomeNoteDo domainToQueryDo(QueryHomeNoteDto var1);

    @Named(value="convertEndTimeString")
    default public String convertEndTimeString(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        if (!DateUtils.isDayFormat((String)dateStr)) {
            return dateStr;
        }
        return DateUtils.formatDateToString((Date)DateUtils.plusNumDays((Date)DateUtils.parseStringToDate((String)dateStr, (DateTimeFormatter)DATE_TIME_FORMATTER_DAY), (int)1), (DateTimeFormatter)DATE_TIME_FORMATTER_SECOND);
    }

    @Named(value="addFuzzyQuerySign")
    default public String addFuzzyQuerySign(String searchNoteKey) {
        if (StringUtils.isBlank((CharSequence)searchNoteKey)) {
            return "";
        }
        return "%" + searchNoteKey + "%";
    }

    public LiteDocNoteExcelDto domainToExcelDto(DocNoteDo var1);

    public List<LiteDocNoteExcelDto> domainToExcelDtoList(List<DocNoteDo> var1);

    @Mappings(value={@Mapping(source="createTime", target="createTime", qualifiedByName={"convertNotMatchDateStr"}), @Mapping(source="lastModifyTime", target="lastModifyTime", qualifiedByName={"convertNotMatchDateStr"})})
    public DocNoteDo excelDtoToDomain(DocNoteExcelDto var1);

    public List<DocNoteDo> excelDtoToDomainList(List<DocNoteExcelDto> var1);

    @Mappings(value={@Mapping(source="createTime", target="createTime", qualifiedByName={"convertNotMatchDateStr"}), @Mapping(source="lastModifyTime", target="lastModifyTime", qualifiedByName={"convertNotMatchDateStr"})})
    public DocNoteDo liteExcelDtoToDomain(LiteDocNoteExcelDto var1);

    public List<DocNoteDo> liteExcelDtoToDomainList(List<LiteDocNoteExcelDto> var1);

    @Named(value="convertNotMatchDateStr")
    default public String convertNotMatchDateStr(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr) || !DateUtils.isSecondFormat((String)dateStr)) {
            return DateUtils.parseLongToString((long)System.currentTimeMillis());
        }
        return dateStr;
    }
}

