/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnote.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import com.huawei.support.icslite.business.docnote.dto.DocNoteDto;
import com.huawei.support.icslite.business.docnote.dto.DocNoteExcelDto;
import com.huawei.support.icslite.business.docnote.dto.LiteDocNoteExcelDto;
import com.huawei.support.icslite.business.docnote.dto.QueryHomeNoteDto;
import com.huawei.support.icslite.business.docnote.excel.DocNoteExcelDtoListener;
import com.huawei.support.icslite.business.docnote.excel.ExcelHeadListener;
import com.huawei.support.icslite.business.docnote.excel.HedexDocNoteListener;
import com.huawei.support.icslite.business.docnote.excel.LiteDocNoteListener;
import com.huawei.support.icslite.business.docnote.mapper.DocNoteConverter;
import com.huawei.support.icslite.business.docnote.service.DocNoteBusiness;
import com.huawei.support.icslite.business.docnote.util.DocNoteUtils;
import com.huawei.support.icslite.business.libmanage.serviceimpl.HdxManageServiceHandler;
import com.huawei.support.icslite.business.libmanage.serviceimpl.IcsManageServiceHandler;
import com.huawei.support.icslite.docnote.dto.DocNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryHdxNoteDo;
import com.huawei.support.icslite.docnote.dto.QueryIcsNoteDo;
import com.huawei.support.icslite.docnote.service.impl.DocNoteServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class DocNoteBusinessHandler
implements DocNoteBusiness {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DocNoteBusinessHandler.class);

    private DocNoteBusinessHandler() {
    }

    public static DocNoteBusinessHandler getInstance() {
        return DocNoteBusinessHandlerHolder.INSTANCE;
    }

    private static String getIcsTopicKey(DocNoteDto docNoteDto) {
        String docId = DocNoteUtils.getIcsDocId(docNoteDto);
        return StringUtils.isBlank((CharSequence)docId) ? "" : docId + "_" + docNoteDto.getTopicId();
    }

    @Override
    public void createTb() {
        DocNoteServiceHandler.getInstance().createTb();
    }

    @Override
    public int addNote(DocNoteDto docNoteDto) {
        if (StringUtils.startsWith((CharSequence)docNoteDto.getTocDocId(), (CharSequence)"HDX")) {
            return this.addHdxNote(docNoteDto);
        }
        return this.addIcsNote(docNoteDto);
    }

    @Override
    public int addHdxNote(DocNoteDto docNoteDto) {
        HdxContentDo hdxContentDo = HdxManageServiceHandler.getInstance().getHdx(docNoteDto.getTocDocId());
        if (hdxContentDo == null) {
            return 0;
        }
        docNoteDto.setLibId(hdxContentDo.getLibId()).setLibV((String)StringUtils.defaultIfBlank((CharSequence)hdxContentDo.getLibV(), (CharSequence)"")).setLang(hdxContentDo.getLang()).setIssueDate(hdxContentDo.getIssueDate()).setProductName(hdxContentDo.getProductName()).setProductV(hdxContentDo.getProductV()).setLibName(hdxContentDo.getLibName()).setLibType("HDX").setCreateTime(DateUtils.parseLongToString((long)System.currentTimeMillis())).setLastModifyTime(DateUtils.parseLongToString((long)System.currentTimeMillis())).setRemarkId(DocNoteUtils.createRemarkId()).setDeleteFlag("0");
        return DocNoteServiceHandler.getInstance().add(DocNoteConverter.INSTANCE.domainToDo(docNoteDto));
    }

    @Override
    public int addIcsNote(DocNoteDto docNoteDto) {
        IcsContentDo icsContentDo = IcsManageServiceHandler.getInstance().getIcsDo(docNoteDto.getTocDocId());
        IcsTopicDo topic = IcsNaviTopicServiceHandler.getInstance().getOneTopicInNavi(docNoteDto.getTocDocId(), "", docNoteDto.getTopicId(), "");
        if (icsContentDo == null || topic == null) {
            return 0;
        }
        docNoteDto.setProjectId(icsContentDo.getProjectid()).setLibId(icsContentDo.getLibId()).setPidId(topic.getPidId()).setLibV((String)StringUtils.defaultIfBlank((CharSequence)icsContentDo.getLibV(), (CharSequence)"")).setLang(icsContentDo.getLang()).setIssueDate(icsContentDo.getIssueDate()).setProductName(icsContentDo.getProductName()).setProductV(icsContentDo.getProductV()).setLibName(icsContentDo.getLibName()).setLibType("ICS").setCreateTime(DateUtils.parseLongToString((long)System.currentTimeMillis())).setLastModifyTime(DateUtils.parseLongToString((long)System.currentTimeMillis())).setRemarkId(DocNoteUtils.createRemarkId()).setDeleteFlag("0");
        return DocNoteServiceHandler.getInstance().add(DocNoteConverter.INSTANCE.domainToDo(docNoteDto));
    }

    @Override
    public List<DocNoteDto> getTopicNote(DocNoteDto docNoteDto) {
        if (StringUtils.startsWith((CharSequence)docNoteDto.getTocDocId(), (CharSequence)"HDX")) {
            return this.getHdxTopicNote(docNoteDto);
        }
        return this.getIcsTopicNote(docNoteDto);
    }

    @Override
    public List<DocNoteDto> getHdxTopicNote(DocNoteDto docNoteDto) {
        HdxContentDo hdxContentDo = HdxManageServiceHandler.getInstance().getHdx(docNoteDto.getTocDocId());
        if (hdxContentDo == null) {
            return Collections.emptyList();
        }
        docNoteDto.setLibId(hdxContentDo.getLibId()).setLibV(hdxContentDo.getLibV()).setLang(hdxContentDo.getLang());
        List<DocNoteDto> docNoteDtoList = DocNoteConverter.INSTANCE.domainToDtoList(DocNoteServiceHandler.getInstance().getHdxTopicNote(DocNoteConverter.INSTANCE.domainToHdxQueryDo(docNoteDto)));
        this.processNoteInfo(docNoteDtoList);
        return docNoteDtoList;
    }

    @Override
    public List<DocNoteDto> getIcsTopicNote(DocNoteDto docNoteDto) {
        IcsContentDo icsContentDo = IcsManageServiceHandler.getInstance().getIcsDo(docNoteDto.getTocDocId());
        if (icsContentDo == null) {
            return Collections.emptyList();
        }
        docNoteDto.setProjectId(icsContentDo.getProjectid()).setLibV((String)StringUtils.defaultIfBlank((CharSequence)icsContentDo.getLibV(), (CharSequence)"")).setLang(icsContentDo.getLang()).setIssueDate(icsContentDo.getIssueDate());
        List<DocNoteDto> docNoteDtoList = DocNoteConverter.INSTANCE.domainToDtoList(DocNoteServiceHandler.getInstance().getIcsTopicNote(DocNoteConverter.INSTANCE.domainToIcsQueryDo(docNoteDto)));
        this.processNoteInfo(docNoteDtoList);
        return docNoteDtoList;
    }

    private void processNoteInfo(List<DocNoteDto> docNoteDtoList) {
        docNoteDtoList.forEach(this::handleSetDocNoteDto);
    }

    private void handleSetDocNoteDto(DocNoteDto noteDto) {
        noteDto.setTocDocId(StringUtils.equals((CharSequence)noteDto.getLibType(), (CharSequence)"ICS") ? DocNoteUtils.getIcsDocId(noteDto) : DocNoteUtils.createHdxId(noteDto));
        noteDto.setTitle(HWEncoder.encodeForHTML((String)noteDto.getTitle()));
        noteDto.setContent(HWEncoder.encodeForHTML((String)noteDto.getContent()));
        noteDto.setLibName(HWEncoder.encodeForHTML((String)noteDto.getLibName()));
        noteDto.setLibV(HWEncoder.encodeForHTML((String)noteDto.getLibV()));
        noteDto.setLibId(HWEncoder.encodeForHTML((String)noteDto.getLibId()));
        noteDto.setProductName(HWEncoder.encodeForHTML((String)noteDto.getProductName()));
        noteDto.setProductV(HWEncoder.encodeForHTML((String)noteDto.getProductV()));
    }

    @Override
    public List<String> getNoteTopicId(String docId) {
        if (StringUtils.startsWith((CharSequence)docId, (CharSequence)"HDX")) {
            List<DocNoteDto> docNoteDos = DocNoteConverter.INSTANCE.domainToDtoList(DocNoteServiceHandler.getInstance().getHdxNoteTopicId());
            return docNoteDos.stream().map(docNoteDto -> DocNoteUtils.createHdxId(docNoteDto) + "_" + docNoteDto.getTopicId()).distinct().collect(Collectors.toList());
        }
        return DocNoteConverter.INSTANCE.domainToDtoList(DocNoteServiceHandler.getInstance().getIcsNoteTopicId()).stream().map(DocNoteBusinessHandler::getIcsTopicKey).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, List<String>> getProduct() {
        return DocNoteServiceHandler.getInstance().getProduct().stream().sorted(Comparator.comparing(DocNoteDo::getProductName, Collator.getInstance(Locale.CHINA).reversed()).thenComparing(DocNoteDo::getProductV, Comparator.reverseOrder())).collect(Collectors.groupingBy(DocNoteDo::getProductName, LinkedHashMap::new, Collectors.mapping(DocNoteDo::getProductV, Collectors.toList())));
    }

    @Override
    public List<DocNoteDto> getHomeNotes(QueryHomeNoteDto queryHomeNoteDto) {
        List<DocNoteDto> docNoteDtoList = DocNoteConverter.INSTANCE.domainToDtoList(DocNoteServiceHandler.getInstance().getHomeNotes(DocNoteConverter.INSTANCE.domainToQueryDo(queryHomeNoteDto)));
        this.processNoteInfo(docNoteDtoList);
        return docNoteDtoList;
    }

    @Override
    public int getHomeNoteSize(QueryHomeNoteDto queryHomeNoteDto) {
        return DocNoteServiceHandler.getInstance().getHomeNoteSize(DocNoteConverter.INSTANCE.domainToQueryDo(queryHomeNoteDto));
    }

    @Override
    public int update(DocNoteDto docNoteDto) {
        return DocNoteServiceHandler.getInstance().update(DocNoteConverter.INSTANCE.domainToDo(docNoteDto));
    }

    @Override
    public int updateHdxFlag(DocNoteDto docNoteDto) {
        return DocNoteServiceHandler.getInstance().updateHdxFlag(DocNoteConverter.INSTANCE.domainToDo(docNoteDto));
    }

    @Override
    public int updateIcsFlag(DocNoteDto docNoteDto) {
        return DocNoteServiceHandler.getInstance().updateIcsFlag(DocNoteConverter.INSTANCE.domainToDo(docNoteDto));
    }

    @Override
    public int del(String remarkId) {
        return DocNoteServiceHandler.getInstance().del(remarkId);
    }

    @Override
    public int delBatch(List<String> remarkIds) {
        return DocNoteServiceHandler.getInstance().delBatch(remarkIds);
    }

    @Override
    public boolean isIcsNoteExist(String projectId, String libV, String issueDate, String lang) {
        QueryIcsNoteDo queryIcsNoteDo = new QueryIcsNoteDo();
        queryIcsNoteDo.setProjectId(projectId);
        queryIcsNoteDo.setLibV((String)StringUtils.defaultIfBlank((CharSequence)libV, (CharSequence)""));
        queryIcsNoteDo.setIssueDate(issueDate);
        queryIcsNoteDo.setLang(lang);
        return DocNoteServiceHandler.getInstance().getIcsNote(queryIcsNoteDo).size() > 0;
    }

    @Override
    public boolean isHdxNoteExist(String libId, String libV, String lang) {
        QueryHdxNoteDo queryHdxNoteDo = new QueryHdxNoteDo();
        queryHdxNoteDo.setLibId(libId);
        queryHdxNoteDo.setLibV((String)StringUtils.defaultIfBlank((CharSequence)libV, (CharSequence)""));
        queryHdxNoteDo.setLang(lang);
        return DocNoteServiceHandler.getInstance().getHdxNote(queryHdxNoteDo).size() > 0;
    }

    @Override
    public boolean isContainNotes(String docId) {
        if (docId.matches("^HDX[\\w\\.\\(\\)\\-\\, ]{1,97}$")) {
            HdxContentDo hdx = HdxManageServiceHandler.getInstance().getHdx(docId);
            if (hdx == null) {
                return false;
            }
            return this.isHdxNoteExist(hdx.getLibId(), hdx.getLibV(), hdx.getLang());
        }
        IcsContentDo ics = IcsManageServiceHandler.getInstance().getIcsDo(docId);
        if (ics == null) {
            return false;
        }
        return this.isIcsNoteExist(ics.getProjectid(), ics.getLibV(), ics.getIssueDate(), ics.getLang());
    }

    @Override
    public List<LiteDocNoteExcelDto> queryAllDocNotes() {
        List docNoteDos = DocNoteServiceHandler.getInstance().getAllDocNotes();
        return DocNoteConverter.INSTANCE.domainToExcelDtoList(docNoteDos);
    }

    @Override
    public List<LiteDocNoteExcelDto> queryDocNotesByRemarkIds(List<String> remarkIds) {
        List docNoteDos = DocNoteServiceHandler.getInstance().getDocNotesByRemarkIds(remarkIds);
        return DocNoteConverter.INSTANCE.domainToExcelDtoList(docNoteDos);
    }

    @Override
    public boolean importDocNotes(MultipartFile file, List<String> headList) {
        if (CollectionUtils.isEmpty(headList) || !this.isValidExcel(headList)) {
            return false;
        }
        boolean isHedexLiteExcel = headList.stream().anyMatch(headStr -> StringUtils.equalsAnyIgnoreCase((CharSequence)headStr, (CharSequence[])new CharSequence[]{"\u7528\u6237\u7ec4", "User Group"}));
        if (isHedexLiteExcel) {
            return this.readExcel(file, DocNoteExcelDto.class, new HedexDocNoteListener());
        }
        return this.readExcel(file, LiteDocNoteExcelDto.class, new LiteDocNoteListener());
    }

    private boolean isValidExcel(List<String> headList) {
        if (headList.size() < 3) {
            return false;
        }
        String remarkId = headList.get(0);
        String title = headList.get(1);
        String content = headList.get(2);
        if (StringUtils.equalsAny((CharSequence)remarkId, (CharSequence[])new CharSequence[]{"Remark ID", "Remarks No."}) && StringUtils.equals((CharSequence)title, (CharSequence)"Title") && StringUtils.equalsAny((CharSequence)content, (CharSequence[])new CharSequence[]{"Content", "Contents"})) {
            return true;
        }
        return StringUtils.equals((CharSequence)remarkId, (CharSequence)"\u6279\u6ce8\u7f16\u53f7") && StringUtils.equals((CharSequence)title, (CharSequence)"\u6807\u9898") && StringUtils.equals((CharSequence)content, (CharSequence)"\u5185\u5bb9");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ExcelHeadListener getExcelInfo(MultipartFile file) {
        ExcelHeadListener excelHeadListener = new ExcelHeadListener();
        ExcelReader excelReader = null;
        try (InputStream inputStream = file.getInputStream();){
            excelReader = EasyExcel.read((InputStream)inputStream, (ReadListener)excelHeadListener).build();
            ReadSheet readSheet = EasyExcel.readSheet((Integer)0).build();
            excelReader.read(new ReadSheet[]{readSheet});
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Import docNotes parser head has io excepion", (Throwable)e);
            ExcelHeadListener excelHeadListener2 = null;
            return excelHeadListener2;
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
        return excelHeadListener;
    }

    private <T extends DocNoteExcelDto> boolean readExcel(MultipartFile file, Class<T> clazz, DocNoteExcelDtoListener<T> listener) {
        try (InputStream inputStream = file.getInputStream();){
            EasyExcel.read((InputStream)inputStream, clazz, listener).sheet().doRead();
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Import DocNote haas IoException", (Throwable)e);
            return false;
        }
        return true;
    }

    private static class DocNoteBusinessHandlerHolder {
        private static final DocNoteBusinessHandler INSTANCE = new DocNoteBusinessHandler();

        private DocNoteBusinessHandlerHolder() {
        }
    }
}

