/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.docnote.util;

import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.docnote.dto.DocNoteDto;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DocNoteUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DocNoteUtils.class);
    private static final int EOF = -1;
    private static final List<String> SUFFIX_LIST = Arrays.asList("xls", "xlsx");

    private DocNoteUtils() {
    }

    public static String createRemarkId() {
        return "NOTE" + UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String createHdxId(DocNoteDto docNoteDto) {
        return "HDX" + docNoteDto.getLibId() + "_" + docNoteDto.getLibV() + "_" + docNoteDto.getLang();
    }

    public static String getIcsDocId(DocNoteDto docNoteDto) {
        List icsContentDos = IcsContentPoolServiceHandler.getInstance().getByProjectid(docNoteDto.getProjectId(), docNoteDto.getLang());
        List icsContentDoList = icsContentDos.stream().filter(icsContentDo -> StringUtils.equals((CharSequence)StringUtils.defaultIfBlank((CharSequence)icsContentDo.getLibV(), (CharSequence)""), (CharSequence)docNoteDto.getLibV()) && StringUtils.equals((CharSequence)icsContentDo.getIssueDate(), (CharSequence)docNoteDto.getIssueDate())).collect(Collectors.toList());
        return CollectionUtils.isEmpty(icsContentDoList) ? "" : ((IcsContentDo)icsContentDoList.get(0)).getDocId();
    }

    public static boolean checkFileSize(long fileSize) {
        return fileSize <= 0x500000L;
    }

    public static boolean checkExcelSuffix(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        int lastIndexOf = fileName.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return false;
        }
        String fileSuffix = fileName.substring(lastIndexOf + 1);
        return SUFFIX_LIST.stream().anyMatch(suffix -> StringUtils.equalsIgnoreCase((CharSequence)fileSuffix, (CharSequence)suffix));
    }
}

