/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.doubleclicklib.service.impl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.doubleclicklib.service.DoubleClickBusiness;
import com.huawei.support.icslite.business.libmanage.task.LibManageInitTask;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.errors.EncodingException;

public class DoubleClickBusinessHandler
implements DoubleClickBusiness {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(DoubleClickBusinessHandler.class);
    private static final String HDX_BROWSE_URL = "/icslite/hdx.do?docid=%s";
    private static final String ICS_BROWSE_URL = "/icslite/portal/get.do?docid=%s#path=docnav-0";

    private DoubleClickBusinessHandler() {
    }

    public static DoubleClickBusinessHandler getInstance() {
        return DoubleClickLibBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public void loadDoubleClickLib() {
        LibManageInitTask.getInstance().toStart();
    }

    @Override
    public String getLibBrowseUrlByPath(String libPath) {
        if (libPath.toLowerCase(Locale.ENGLISH).endsWith(".hdx")) {
            HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().getByPath(libPath);
            String doubleClickDocId = hdxContentDo == null ? (String)IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().get(libPath) : hdxContentDo.getDocId();
            return this.getLibBrowseUrlByPath(doubleClickDocId, libPath);
        }
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().getByPath(libPath);
        String doubleClickDocId = icsContentDo == null ? (String)IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().get(libPath) : icsContentDo.getDocId();
        return this.getLibBrowseUrlByPath(doubleClickDocId, libPath);
    }

    private String getLibBrowseUrlByPath(String docId, String libPath) {
        String browseUrl = "";
        if (StringUtils.isBlank((CharSequence)docId)) {
            return browseUrl;
        }
        try {
            browseUrl = libPath.toLowerCase(Locale.ENGLISH).endsWith(".hwics") ? String.format(Locale.ENGLISH, ICS_BROWSE_URL, HWEncoder.encodeForURL((String)docId)) : String.format(Locale.ENGLISH, HDX_BROWSE_URL, HWEncoder.encodeForURL((String)docId));
        }
        catch (EncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "{0} : IcsEncoder.encodeForUrl EncodingException", new Object[]{docId, e});
        }
        return browseUrl;
    }

    public static class DoubleClickLibBusinessHandlerHolder {
        private static final DoubleClickBusinessHandler INSTANCE = new DoubleClickBusinessHandler();
    }
}

