/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.doubleclicklib.util;

import com.huawei.support.icslite.business.doubleclicklib.entity.enums.DoubleClickRegParams;
import com.huawei.support.icslite.common.resources.utils.CmdCharacterUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.common.utils.WinRegistryUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class DoubleClickRegUtils {
    private DoubleClickRegUtils() {
    }

    public static boolean setDoubleClickReg() {
        for (DoubleClickRegParams regisrtyParams : DoubleClickRegParams.values()) {
            String expectKeyValueContent;
            boolean isDefaultName;
            String realKeyValueContent;
            if (StringUtils.equals((CharSequence)regisrtyParams.getName(), (CharSequence)"FriendlyAppName")) {
                realKeyValueContent = WinRegistryUtil.queryWinRegistryValueContent((String)regisrtyParams.getRegistryPath(), (String)regisrtyParams.getName(), (String)regisrtyParams.getValueType());
                isDefaultName = false;
            } else {
                realKeyValueContent = WinRegistryUtil.queryDefaultWinRegistryValueContent((String)regisrtyParams.getRegistryPath(), (String)regisrtyParams.getValueType());
                isDefaultName = true;
            }
            if (StringUtils.equals((CharSequence)regisrtyParams.getName(), (CharSequence)"command")) {
                expectKeyValueContent = DoubleClickRegUtils.handleLibPathQuotationMark();
                realKeyValueContent = StringEscapeUtils.escapeJava((String)realKeyValueContent);
            } else {
                expectKeyValueContent = regisrtyParams.getKeyValueContent();
            }
            if (StringUtils.equals((CharSequence)expectKeyValueContent, (CharSequence)realKeyValueContent) || DoubleClickRegUtils.updateWinRegistry(regisrtyParams, realKeyValueContent, isDefaultName)) continue;
            return false;
        }
        return true;
    }

    private static String handleLibPathQuotationMark() {
        return CmdCharacterUtils.getIcsLiteStartPath((String)StringEscapeUtils.escapeJava((String)IcsCommonServiceHandler.getInstance().getStartupExePath())).append(" ").append((CharSequence)CmdCharacterUtils.getIcsLiteStartPath((String)"%1")).toString();
    }

    private static boolean updateWinRegistry(DoubleClickRegParams doubleClickRegParams, String realKeyValueContent, boolean isDefaultName) {
        if (StringUtils.isNotBlank((CharSequence)realKeyValueContent)) {
            DoubleClickRegUtils.deleteWinRegistry(doubleClickRegParams, isDefaultName);
        }
        return DoubleClickRegUtils.modifyWinRegistry(doubleClickRegParams, isDefaultName);
    }

    private static void deleteWinRegistry(DoubleClickRegParams doubleClickRegParams, boolean isDefaultName) {
        String registryPath = doubleClickRegParams.getRegistryPath();
        if (isDefaultName) {
            WinRegistryUtil.deleteWinRegistry((String)registryPath);
        } else {
            WinRegistryUtil.deleteWinRegistry((String)registryPath, (String)doubleClickRegParams.getName());
        }
    }

    private static boolean modifyWinRegistry(DoubleClickRegParams doubleClickRegParams, boolean isDefault) {
        String valueTyp = doubleClickRegParams.getValueType();
        String keyValueContent = doubleClickRegParams.getKeyValueContent();
        String registryPath = doubleClickRegParams.getRegistryPath();
        if (isDefault) {
            return WinRegistryUtil.modifyWinDefaultRegistry((String)registryPath, (String)valueTyp, (String)keyValueContent);
        }
        return WinRegistryUtil.modifyWinRegistry((String)registryPath, (String)doubleClickRegParams.getName(), (String)valueTyp, (String)keyValueContent);
    }
}

