/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.chain;

import com.huawei.support.icslite.business.download.chain.RefreshChain;
import com.huawei.support.icslite.business.download.chain.impl.RefreshCompletedTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshDeleteTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshDownloadDeleteTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshExecutorTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshPauseTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshRestartTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshRestoreTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshStartTask;
import com.huawei.support.icslite.business.download.chain.impl.RefreshTrashBoxTask;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilterChain {
    private static final List<RefreshChain> CHAIN_LIST;

    public void refreshProcess(DownloadSingleTaskDto downloadSingleTaskDto) {
        for (RefreshChain refreshChain : CHAIN_LIST) {
            if (!refreshChain.canApply(downloadSingleTaskDto)) continue;
            refreshChain.refreshProcess(downloadSingleTaskDto);
        }
    }

    static {
        ArrayList<RefreshChain> refreshChains = new ArrayList<RefreshChain>();
        refreshChains.add(new RefreshDownloadDeleteTask());
        refreshChains.add(new RefreshExecutorTask());
        refreshChains.add(new RefreshPauseTask());
        refreshChains.add(new RefreshStartTask());
        refreshChains.add(new RefreshRestartTask());
        refreshChains.add(new RefreshRestoreTask());
        refreshChains.add(new RefreshDeleteTask());
        refreshChains.add(new RefreshCompletedTask());
        refreshChains.add(new RefreshTrashBoxTask());
        CHAIN_LIST = Collections.unmodifiableList(refreshChains);
    }
}

