/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.chain.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.chain.RefreshChain;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.process.ProcessorChain;
import com.huawei.support.icslite.business.download.thread.DownloadFileThread;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RefreshExecutorTask
implements RefreshChain {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(RefreshExecutorTask.class);

    @Override
    public boolean canApply(DownloadSingleTaskDto downloadSingleTaskDto) {
        return StringUtils.equalsAny((CharSequence)downloadSingleTaskDto.getCurrentStatus(), (CharSequence[])new CharSequence[]{"1", "7"});
    }

    @Override
    public void refreshProcess(DownloadSingleTaskDto downloadSingleTaskDto) {
        long[][] points = downloadSingleTaskDto.getPoints();
        if (!this.checkPoint(points)) {
            return;
        }
        DownloadFileThread[] threads = downloadSingleTaskDto.getThreads();
        for (int i = 0; i < 3; ++i) {
            boolean isDownloadOver;
            if (threads[i] == null || !(isDownloadOver = threads[i].isDownloadOver())) continue;
            this.pointCompleteHandler(points, threads[i]);
            if (downloadSingleTaskDto.getPointQueue().size() == 0) break;
            long consumed = Optional.ofNullable(downloadSingleTaskDto.getPointQueue().poll()).orElse(-1L);
            downloadSingleTaskDto.getDownloadSplitCount().getAndIncrement();
            for (long[] point : points) {
                DownloadFileThread downloadFileThread;
                if (point[0] != consumed) continue;
                threads[i] = downloadFileThread = new DownloadFileThread(point, downloadSingleTaskDto.getFileSize(), downloadSingleTaskDto.getDownloadFilePath(), DownloadManangeUtils.getRealUrl(downloadSingleTaskDto.getDownloadUrl()));
                DownloadSingleUtils.executeThread(downloadFileThread);
            }
        }
        for (long[] point : points) {
            if (point[1] >= point[2]) continue;
            return;
        }
        ProcessorChain.getInstance().completedHandler(downloadSingleTaskDto);
    }

    private void pointCompleteHandler(long[][] points, DownloadFileThread thread) {
        long startPoint = thread.getStartPoint();
        for (long[] point : points) {
            if (point[1] >= point[2] || point[1] == 0L || point[0] != startPoint) continue;
            CodeCCUtils.INSTANCE.errorLog(log, "the Segment is downloaded. but no updated. current is {0}, end is {1}", new Object[]{point[1], point[2]});
            point[1] = point[2];
        }
    }

    private boolean checkPoint(long[][] points) {
        if (points == null) {
            return false;
        }
        for (long[] point : points) {
            if (point[2] != 0L) continue;
            return false;
        }
        return true;
    }
}

