/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.enums;

import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.dto.HttpHeaderDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icslite.business.authorization.serviceimpl.CertificateBusinessHandler;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.lang.Nullable;

public enum DownloadEnum {
    HOUP{

        @Override
        InputStream getSplitInputStream(HttpClientDto httpClientDto) throws DownloadException {
            return NetWorkUtil.getSplitInputStreamForHoup((HttpClientDto)httpClientDto);
        }

        @Override
        InputStream getInputStream(HttpClientDto httpClientDto) throws DownloadException {
            return NetWorkUtil.getInputStreamForHoup((HttpClientDto)httpClientDto);
        }

        @Override
        HttpHeaderDto getHttpHeaderDto(HttpClientDto httpClientDto) {
            return NetWorkUtil.getHeadersForHoup((HttpClientDto)httpClientDto);
        }

        @Override
        HttpClientDto getHttpClientDto(String downloadUrl, Long startPoint, Long endPoint) throws DownloadException {
            return DownloadEnum.getHoupHttpClient(downloadUrl, startPoint, endPoint);
        }
    }
    ,
    SUPPORT{

        @Override
        InputStream getSplitInputStream(HttpClientDto httpClientDto) throws DownloadException {
            return NetWorkUtil.getSplitInputStream((HttpClientDto)httpClientDto);
        }

        @Override
        InputStream getInputStream(HttpClientDto httpClientDto) throws DownloadException {
            return NetWorkUtil.getInputStream((HttpClientDto)httpClientDto);
        }

        @Override
        HttpHeaderDto getHttpHeaderDto(HttpClientDto httpClientDto) {
            return NetWorkUtil.getHeaders((HttpClientDto)httpClientDto);
        }

        @Override
        HttpClientDto getHttpClientDto(String downloadUrl, Long startPoint, Long endPoint) throws DownloadException {
            HttpClientDto.Builder builder = NetworkServiceHandler.getInstance().getHttpClientDefault().newBuilder().url(downloadUrl);
            if (ObjectUtils.allNotNull((Object[])new Object[]{startPoint, endPoint})) {
                return builder.startPos(startPoint.longValue()).endPos(endPoint.longValue()).build();
            }
            return builder.build();
        }
    }
    ,
    HOUPDOWNLOAD{

        @Override
        InputStream getSplitInputStream(HttpClientDto httpClientDto) throws DownloadException {
            return NetWorkUtil.getSplitInputStream((HttpClientDto)httpClientDto);
        }

        @Override
        InputStream getInputStream(HttpClientDto httpClientDto) throws DownloadException {
            return NetWorkUtil.getInputStreamForHoup((HttpClientDto)httpClientDto);
        }

        @Override
        HttpHeaderDto getHttpHeaderDto(HttpClientDto httpClientDto) {
            return NetWorkUtil.getHeaders((HttpClientDto)httpClientDto);
        }

        @Override
        HttpClientDto getHttpClientDto(String downloadUrl, Long startPoint, Long endPoint) throws DownloadException {
            return DownloadEnum.getHoupHttpClient(downloadUrl, startPoint, endPoint);
        }
    };


    private static HttpClientDto getHoupHttpClient(String downloadUrl, Long startPoint, Long endPoint) throws DownloadException {
        HttpClientDto.Builder builder = NetworkServiceHandler.getInstance().getHttpClientForHoup(CertificateBusinessHandler.getInstance().getIssueCertificateStatus()).newBuilder().url(downloadUrl);
        if (ObjectUtils.allNotNull((Object[])new Object[]{startPoint, endPoint})) {
            return builder.startPos(startPoint.longValue()).endPos(endPoint.longValue()).build();
        }
        return builder.build();
    }

    @Nullable
    public static InputStream getSplitInputStreamByUrl(String downloadUrl, long startPoint, long endPoint) throws DownloadException {
        DownloadEnum downloadEnum = DownloadEnum.getSourceTypeByUrl(downloadUrl);
        HttpClientDto httpClientDto = downloadEnum.getHttpClientDto(downloadUrl, startPoint, endPoint);
        if (Objects.isNull(httpClientDto)) {
            return null;
        }
        return downloadEnum.getSplitInputStream(httpClientDto);
    }

    @Nullable
    public static InputStream getInputStreamByUrl(String downloadUrl) throws DownloadException {
        DownloadEnum downloadEnum = DownloadEnum.getSourceTypeByUrl(downloadUrl);
        HttpClientDto httpClientDto = downloadEnum.getHttpClientDto(downloadUrl, null, null);
        if (Objects.isNull(httpClientDto)) {
            return null;
        }
        return downloadEnum.getInputStream(httpClientDto);
    }

    @Nullable
    public static HttpHeaderDto getHttpHeadDtoByUrl(String downloadUrl) throws DownloadException {
        DownloadEnum downloadEnum = DownloadEnum.getSourceTypeByUrl(downloadUrl);
        HttpClientDto httpClientDto = downloadEnum.getHttpClientDto(downloadUrl, null, null);
        if (Objects.isNull(httpClientDto)) {
            return null;
        }
        return downloadEnum.getHttpHeaderDto(httpClientDto);
    }

    private static DownloadEnum getSourceTypeByUrl(String downloadUrl) {
        if (DownloadSingleUtils.isMatchTypeDownloadUrl(downloadUrl, UrlDataServiceHandler.getInstance().getDomainByScene("HOUP.NGINX"))) {
            return DownloadEnum.valueOf("houp".toUpperCase(Locale.ROOT));
        }
        if (DownloadSingleUtils.isMatchTypeDownloadUrl(downloadUrl, UrlDataServiceHandler.getInstance().getDomainByScene("HOUP.DOWNLOAD.NGINX"))) {
            return DownloadEnum.valueOf("houpdownload".toUpperCase(Locale.ROOT));
        }
        return DownloadEnum.valueOf("support".toUpperCase(Locale.ROOT));
    }

    abstract InputStream getSplitInputStream(HttpClientDto var1) throws DownloadException;

    abstract InputStream getInputStream(HttpClientDto var1) throws DownloadException;

    abstract HttpHeaderDto getHttpHeaderDto(HttpClientDto var1);

    abstract HttpClientDto getHttpClientDto(String var1, Long var2, Long var3) throws DownloadException;
}

