/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.handler;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.handler.FilePointTaskHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadCacheHandler {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadCacheHandler.class);
    private static final Map<String, DownloadSingleTaskDto> DOWNLOADING_MAP = Collections.synchronizedMap(new LinkedHashMap());

    private DownloadCacheHandler() {
    }

    public static boolean addDownloadingTask(DownloadSingleTaskDto taskDto) {
        if (DOWNLOADING_MAP.containsKey(taskDto.getTaskId())) {
            DOWNLOADING_MAP.put(taskDto.getTaskId(), taskDto);
            return true;
        }
        if (DOWNLOADING_MAP.size() >= 1000) {
            return false;
        }
        DOWNLOADING_MAP.put(taskDto.getTaskId(), taskDto);
        return true;
    }

    public static void remove(String taskId) {
        DOWNLOADING_MAP.remove(taskId);
    }

    public static DownloadSingleTaskDto get(String taskId) {
        return DOWNLOADING_MAP.get(taskId);
    }

    public static boolean updateCategoryToTrashBox(String taskId) {
        DownloadSingleTaskDto downloadSingleTaskDto = DOWNLOADING_MAP.get(taskId);
        if (Objects.isNull(downloadSingleTaskDto)) {
            return false;
        }
        if (DownloadCacheHandler.isLoadingOrValidateTask(downloadSingleTaskDto)) {
            return true;
        }
        downloadSingleTaskDto.setCategory("3");
        return true;
    }

    private static boolean isLoadingOrValidateTask(DownloadSingleTaskDto downloadSingleTaskDto) {
        return StringUtils.equalsAny((CharSequence)downloadSingleTaskDto.getLoadingStatus(), (CharSequence[])new CharSequence[]{"0", "1", "3"}) || StringUtils.equals((CharSequence)downloadSingleTaskDto.getCurrentStatus(), (CharSequence)"7");
    }

    public static void updateStatusToPause(String taskId) {
        DownloadCacheHandler.updateStatus(taskId, "0");
    }

    public static void updateStatusToDownloading(String taskId) {
        DownloadCacheHandler.updateStatus(taskId, "1");
    }

    private static void updateStatus(String taskId, String status) {
        DownloadSingleTaskDto downloadSingleTaskDto = DOWNLOADING_MAP.get(taskId);
        if (Objects.isNull(downloadSingleTaskDto) || StringUtils.equals((CharSequence)status, (CharSequence)downloadSingleTaskDto.getCurrentStatus())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)downloadSingleTaskDto.getLoadingStatus()) && !StringUtils.equals((CharSequence)downloadSingleTaskDto.getCurrentStatus(), (CharSequence)"7")) {
            downloadSingleTaskDto.setNextStatus(status);
        }
    }

    public static boolean updateStatusToRestart(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setNextStatus("5");
        return DownloadCacheHandler.getAddDownloadingTaskResult(downloadSingleTaskDto);
    }

    public static boolean updateStatusToRestore(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setNextStatus("4");
        return DownloadCacheHandler.getAddDownloadingTaskResult(downloadSingleTaskDto);
    }

    public static boolean updateTaskToDelete(String taskId) {
        DownloadSingleTaskDto downloadSingleTaskDto = DOWNLOADING_MAP.get(taskId);
        if (Objects.isNull(downloadSingleTaskDto)) {
            return false;
        }
        if (DownloadCacheHandler.isLoadingOrValidateTask(downloadSingleTaskDto)) {
            return true;
        }
        downloadSingleTaskDto.setNextStatus("8");
        return true;
    }

    private static boolean getAddDownloadingTaskResult(DownloadSingleTaskDto downloadSingleTaskDto) {
        boolean isAdded = DownloadCacheHandler.addDownloadingTask(downloadSingleTaskDto);
        if (!isAdded) {
            downloadSingleTaskDto.setNextStatus(null);
        }
        return isAdded;
    }

    private static int getCountByDownloadStatus(String status) {
        return (int)DOWNLOADING_MAP.values().stream().filter(downloadSingleTaskDto -> StringUtils.equals((CharSequence)status, (CharSequence)downloadSingleTaskDto.getCurrentStatus())).count();
    }

    public static int getDownloadingCount() {
        return DownloadCacheHandler.getCountByDownloadStatus("1");
    }

    public static int getWaitCount() {
        return DownloadCacheHandler.getCountByDownloadStatus("2");
    }

    public static int getLoadingCount() {
        return DownloadCacheHandler.getCountByDownloadStatus("6");
    }

    public static int getVerifyingCount() {
        return DownloadCacheHandler.getCountByDownloadStatus("7");
    }

    public static int getDeletingCount() {
        return DownloadCacheHandler.getCountByDownloadStatus("8");
    }

    public static int getDownloadingListCount() {
        return DOWNLOADING_MAP.size();
    }

    public static int getDownloadingFreeSpace() {
        return 1000 - DownloadCacheHandler.getDownloadingListCount();
    }

    public static List<DownloadSingleTaskDto> getSingleTaskWaitDtos() {
        List<DownloadSingleTaskDto> waitTaskDtos = DownloadCacheHandler.getTaskDataByStatus("2");
        Collections.sort(waitTaskDtos);
        return waitTaskDtos;
    }

    public static List<DownloadSingleTaskDto> getDownloading() {
        return DownloadCacheHandler.getTaskDataByStatus("1");
    }

    public static int getSignVerifyingCount() {
        return DownloadCacheHandler.getCountByDownloadStatus("9");
    }

    private static List<DownloadSingleTaskDto> getTaskDataByStatus(String status) {
        return DOWNLOADING_MAP.values().stream().filter(downloadSingleTaskDto -> StringUtils.equals((CharSequence)downloadSingleTaskDto.getCurrentStatus(), (CharSequence)status)).collect(Collectors.toList());
    }

    public static List<DownloadSingleTaskDto> getDownloadingList() {
        return new ArrayList<DownloadSingleTaskDto>(DOWNLOADING_MAP.values());
    }

    public static List<DownloadSingleTaskDto> getLoadingDtoList() {
        return DOWNLOADING_MAP.values().stream().filter(downloadSingleTaskDto -> StringUtils.equals((CharSequence)downloadSingleTaskDto.getLoadingStatus(), (CharSequence)"1")).collect(Collectors.toList());
    }

    public static void writeAllPoint() {
        if (MapUtils.isEmpty(DOWNLOADING_MAP)) {
            CodeCCUtils.INSTANCE.warnLog(log, "write point, but downloading list is null.");
            return;
        }
        DOWNLOADING_MAP.values().stream().filter(downloadSingleTaskDto -> StringUtils.isBlank((CharSequence)downloadSingleTaskDto.getLoadingStatus())).forEach(FilePointTaskHandler::writeSinglePoint);
    }

    public static int getDownloadingListCount(String startTime, String endTime) {
        return DownloadCacheHandler.getDownloadingList(startTime, endTime).size();
    }

    public static List<DownloadSingleTaskDto> getDownloadingList(String startTime, String endTime) {
        return DOWNLOADING_MAP.values().stream().filter(downloadSingleTaskDto -> downloadSingleTaskDto.getCreateTime() != 0L).filter(downloadSingleTaskDto -> {
            if (StringUtils.isNotBlank((CharSequence)startTime)) {
                return downloadSingleTaskDto.getCreateTime() >= Long.parseLong(startTime);
            }
            return true;
        }).filter(downloadSingleTaskDto -> {
            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                return downloadSingleTaskDto.getCreateTime() <= Long.parseLong(endTime);
            }
            return true;
        }).collect(Collectors.toList());
    }
}

