/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.FileUtils;

public class FilePointTaskHandler {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(FilePointTaskHandler.class);

    public static boolean initPoint(DownloadSingleTaskDto downloadSingleTaskDto) {
        if (downloadSingleTaskDto.getFileSize() <= 0L) {
            CodeCCUtils.INSTANCE.errorLog(log, "downloadFile size error,not normal file size!");
            return true;
        }
        String filePath = downloadSingleTaskDto.getDownloadFilePath();
        File pointFile = FileUtils.getFile((String[])new String[]{FilePointTaskHandler.getPointerPath(downloadSingleTaskDto)});
        File downloadFile = FileUtils.getFile((String[])new String[]{filePath});
        if (pointFile.isFile() && downloadFile.isFile()) {
            FilePointTaskHandler.readPoint(downloadSingleTaskDto);
            return true;
        }
        if (pointFile.isDirectory() || downloadFile.isDirectory()) {
            downloadSingleTaskDto.setErrorCode(DownloadCode.ERROR_FILE_IS_DIRECTORY.getDownloadCode());
            downloadSingleTaskDto.setErrorMsg(I18nResources.INSTANCE.getValueByKey("download.error.file.is.directory"));
            return false;
        }
        if (downloadFile.exists() && downloadFile.length() != downloadSingleTaskDto.getFileSize()) {
            if (!downloadFile.delete()) {
                CodeCCUtils.INSTANCE.errorLog(log, "Delete downloadFile error,download file is null");
                return false;
            }
            if (!pointFile.delete()) {
                CodeCCUtils.INSTANCE.errorLog(log, "Delete downloadFile error,point file is null");
                return false;
            }
        }
        FilePointTaskHandler.initPointSize(downloadSingleTaskDto, downloadSingleTaskDto.getFileSize());
        FilePointTaskHandler.assignPoint(downloadSingleTaskDto);
        return true;
    }

    private static void assignPoint(DownloadSingleTaskDto downloadSingleTaskDto) {
        JSONArray array = new JSONArray();
        long[][] points = downloadSingleTaskDto.getPoints();
        if (points == null || points.length == 0) {
            return;
        }
        int length = points.length;
        ArrayBlockingQueue<Long> pointQueue = new ArrayBlockingQueue<Long>(length);
        long averageSize = downloadSingleTaskDto.getFileSize() / (long)length;
        for (int i = 0; i < length; ++i) {
            JSONObject pointObj = new JSONObject();
            long startPoint = (long)i * averageSize;
            pointObj.put("startPoint", (Object)startPoint);
            pointObj.put("currentPoint", (Object)startPoint);
            points[i][0] = startPoint;
            points[i][1] = startPoint;
            pointQueue.add(startPoint);
            long endPoint = i == length - 1 ? downloadSingleTaskDto.getFileSize() : (long)(i + 1) * averageSize;
            pointObj.put("endPoint", (Object)endPoint);
            points[i][2] = endPoint;
            array.add((Object)pointObj);
        }
        downloadSingleTaskDto.setPointQueue(pointQueue);
        FilePointTaskHandler.writePointFile(FilePointTaskHandler.getPointerPath(downloadSingleTaskDto), JSONObject.toJSONString((Object)array));
    }

    public static void initPointSize(DownloadSingleTaskDto downloadSingleTaskDto, long fileSize) {
        if (fileSize <= 0L) {
            return;
        }
        int splitCount = (int)((fileSize - 1L) / 0xC800000L + 1L);
        long[][] points = new long[splitCount][3];
        downloadSingleTaskDto.setPoints(points);
    }

    public static void writeSinglePoint(DownloadSingleTaskDto downloadSingleTaskDto) {
        String pointerPath = FilePointTaskHandler.getPointerPath(downloadSingleTaskDto);
        if (FilePointTaskHandler.validatedPoints(downloadSingleTaskDto)) {
            return;
        }
        JSONArray array = FilePointTaskHandler.writePointData(downloadSingleTaskDto);
        FilePointTaskHandler.writePointFile(pointerPath, JSONObject.toJSONString((Object)array));
    }

    private static String getPointerPath(DownloadSingleTaskDto downloadSingleTaskDto) {
        return downloadSingleTaskDto.getDownloadFilePath() + ".info";
    }

    private static boolean validatedPoints(DownloadSingleTaskDto downloadSingleTaskDto) {
        long[][] points = downloadSingleTaskDto.getPoints();
        if (points == null) {
            return true;
        }
        return points[0][2] == 0L;
    }

    private static synchronized void writePointFile(String pointerPath, String data) {
        IcsFileUtils.writeFileContent((String)pointerPath, (String)data);
    }

    private static JSONArray writePointData(DownloadSingleTaskDto downloadSingleTaskDto) {
        long[][] points;
        JSONArray ponitArray = new JSONArray();
        for (long[] point : points = downloadSingleTaskDto.getPoints()) {
            JSONObject pointObj = new JSONObject();
            pointObj.put("startPoint", (Object)point[0]);
            pointObj.put("currentPoint", (Object)point[1]);
            pointObj.put("endPoint", (Object)point[2]);
            ponitArray.add((Object)pointObj);
        }
        return ponitArray;
    }

    private static synchronized String readPointFile(String pointFilePath) {
        return IcsFileUtils.readFileContent((String)pointFilePath, null);
    }

    private static void readPoint(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.getDownloadSplitCount().set(0);
        String pointFilePath = FilePointTaskHandler.getPointerPath(downloadSingleTaskDto);
        String pointData = FilePointTaskHandler.readPointFile(pointFilePath);
        JSONArray pointArray = JSON.parseArray((String)pointData);
        if (pointArray == null) {
            CodeCCUtils.INSTANCE.errorLog(log, "read point error");
            return;
        }
        FilePointTaskHandler.readInit(downloadSingleTaskDto, pointArray);
        long[][] points = downloadSingleTaskDto.getPoints();
        ArrayBlockingQueue<Long> pointQueue = new ArrayBlockingQueue<Long>(points.length);
        for (int i = 0; i < points.length; ++i) {
            long endPoint;
            long startPoint = pointArray.getJSONObject(i).getLong("startPoint");
            long currentPoint = pointArray.getJSONObject(i).getLong("currentPoint");
            if (currentPoint >= (endPoint = pointArray.getJSONObject(i).getLong("endPoint").longValue())) {
                downloadSingleTaskDto.getDownloadSplitCount().getAndIncrement();
            } else {
                pointQueue.add(startPoint);
            }
            points[i][0] = startPoint;
            points[i][1] = currentPoint;
            points[i][2] = endPoint;
        }
        downloadSingleTaskDto.setPointQueue(pointQueue);
    }

    private static void readInit(DownloadSingleTaskDto downloadSingleTaskDto, JSONArray pointArray) {
        ArrayBlockingQueue<Long> pointQueue;
        long[][] points = downloadSingleTaskDto.getPoints();
        if (points == null) {
            points = new long[pointArray.size()][3];
            downloadSingleTaskDto.setPoints(points);
        }
        if ((pointQueue = downloadSingleTaskDto.getPointQueue()) == null) {
            pointQueue = new ArrayBlockingQueue(points.length);
            downloadSingleTaskDto.setPointQueue(pointQueue);
        }
    }

    public static void deletePoint(DownloadSingleTaskDto downloadSingleTaskDto) {
        File pointFile = FileUtils.getFile((String[])new String[]{FilePointTaskHandler.getPointerPath(downloadSingleTaskDto)});
        if (pointFile != null && pointFile.exists() && !FilePointTaskHandler.deletePointFile(pointFile)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Download success, but delete pointFile error.");
        }
    }

    private static synchronized boolean deletePointFile(File pointFile) {
        return pointFile.delete();
    }
}

