/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.helper;

import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.thread.DownloadFileThread;
import com.huawei.support.icslite.business.download.thread.SingleTaskThread;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import java.util.Deque;
import org.apache.commons.lang3.StringUtils;

public class DownloadRefreshHelper {
    public static DownloadRefreshHelper getInstance() {
        return DownloadRefreshHelperHolder.INSTANCE;
    }

    public void startDownload(DownloadSingleTaskDto downloadSingleTaskDto) {
        long[][] points = downloadSingleTaskDto.getPoints();
        if (points == null) {
            return;
        }
        DownloadFileThread[] threads = downloadSingleTaskDto.getThreads();
        int count = 0;
        long fileSize = downloadSingleTaskDto.getFileSize();
        for (int i = 0; i < 3; ++i) {
            DownloadFileThread downloadFileThread;
            threads[i] = null;
            long[] tempPoint = null;
            while (count < points.length) {
                long currentPoint;
                int tempCount;
                long endPoint = points[tempCount][2];
                if ((currentPoint = points[tempCount = count++][1]) >= endPoint) continue;
                tempPoint = points[tempCount];
                break;
            }
            if (tempPoint == null) continue;
            threads[i] = downloadFileThread = new DownloadFileThread(tempPoint, fileSize, downloadSingleTaskDto.getDownloadFilePath(), DownloadManangeUtils.getRealUrl(downloadSingleTaskDto.getDownloadUrl()));
            DownloadSingleUtils.executeThread(downloadFileThread);
            if (!downloadSingleTaskDto.getPointQueue().contains(downloadFileThread.getStartPoint())) continue;
            downloadSingleTaskDto.getPointQueue().poll();
        }
    }

    public void refreshDownloadSingleDto(DownloadSingleTaskDto downloadSingleTaskDto) {
        DownloadFileThread[] threads = downloadSingleTaskDto.getThreads();
        long[][] points = downloadSingleTaskDto.getPoints();
        if (points == null) {
            return;
        }
        long currentTotalSize = 0L;
        long totalSize = 0L;
        for (DownloadFileThread thread : threads) {
            if (thread == null) continue;
            long threadDownloadSize = 0L;
            for (int j = 0; j < points.length; ++j) {
                if (points[j][0] != thread.getStartPoint()) continue;
                points[j][1] = thread.getCurrentPoint();
                threadDownloadSize = thread.getCurrentPoint() - thread.getStartPoint();
                break;
            }
            int downloadSplitCount = downloadSingleTaskDto.getDownloadSplitCount().get();
            long preAppendSize = (long)downloadSplitCount * points[0][2];
            totalSize = (currentTotalSize += threadDownloadSize) + preAppendSize;
        }
        this.recordDownloadSizeAndTime(downloadSingleTaskDto, totalSize);
    }

    public void readyAndStart(DownloadSingleTaskDto downloadSingleTaskDto) {
        if (StringUtils.equalsIgnoreCase((CharSequence)downloadSingleTaskDto.getIsDefaultName(), (CharSequence)"1")) {
            return;
        }
        SingleTaskThread singleTaskThread = new SingleTaskThread(downloadSingleTaskDto);
        DownloadSingleUtils.executeThread(singleTaskThread);
        downloadSingleTaskDto.setSingleTaskThread(singleTaskThread);
    }

    private void recordDownloadSizeAndTime(DownloadSingleTaskDto downloadSingleTaskDto, long totalSize) {
        Deque<Long> times = downloadSingleTaskDto.getTimes();
        Deque<Long> downloadSizes = downloadSingleTaskDto.getDownloadSizes();
        if (times.size() == 20) {
            times.poll();
        }
        if (downloadSizes.size() == 20) {
            downloadSizes.poll();
        }
        times.add(System.currentTimeMillis());
        downloadSizes.add(totalSize);
    }

    private static class DownloadRefreshHelperHolder {
        private static final DownloadRefreshHelper INSTANCE = new DownloadRefreshHelper();

        private DownloadRefreshHelperHolder() {
        }
    }
}

