/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.process;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.process.impl.ChangeToCompleteProcessor;
import com.huawei.support.icslite.business.download.process.impl.FinishDownloadProcessor;
import com.huawei.support.icslite.business.download.process.impl.LibLoadProcessor;
import com.huawei.support.icslite.business.download.process.impl.Processor;
import com.huawei.support.icslite.business.download.process.impl.Sha256Processor;
import com.huawei.support.icslite.business.download.process.impl.VerifyFileProcessor;
import com.huawei.support.icslite.business.download.process.impl.VerifyPgpFileProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessorBuilder {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(ProcessorBuilder.class);
    private static final Map<String, List<Processor>> PROCESSOR_MAP = new HashMap<String, List<Processor>>();

    private ProcessorBuilder() {
        this.addProcessorMap("sw", Arrays.asList(FinishDownloadProcessor.getInstance(), VerifyFileProcessor.getInstance()));
        this.addProcessorMap("doc", Arrays.asList(Sha256Processor.getInstance(), FinishDownloadProcessor.getInstance(), LibLoadProcessor.getInstance(), VerifyPgpFileProcessor.getInstance()));
        this.addProcessorMap("houp", Arrays.asList(FinishDownloadProcessor.getInstance(), VerifyFileProcessor.getInstance()));
        this.addProcessorMap("unknown", Arrays.asList(FinishDownloadProcessor.getInstance(), VerifyPgpFileProcessor.getInstance()));
        this.addProcessorMap("normal", Arrays.asList(FinishDownloadProcessor.getInstance(), ChangeToCompleteProcessor.getInstance()));
    }

    public static ProcessorBuilder getInstance() {
        return ProcessorBuilderHolder.INSTANCE;
    }

    public void addProcessorMap(String name, List<Processor> processorList) {
        if (PROCESSOR_MAP.containsKey(name)) {
            CodeCCUtils.INSTANCE.errorLog(log, "Download processor map has key, please check config, input name is {0}", new Object[]{name});
            return;
        }
        PROCESSOR_MAP.put(name, processorList);
    }

    public List<Processor> getProcessors(String processorType) {
        return PROCESSOR_MAP.get(processorType);
    }

    private static class ProcessorBuilderHolder {
        private static final ProcessorBuilder INSTANCE = new ProcessorBuilder();

        private ProcessorBuilderHolder() {
        }
    }
}

