/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.process;

import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.process.ProcessorBuilder;
import com.huawei.support.icslite.business.download.process.impl.Processor;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import java.util.List;

public class ProcessorChain {
    public static ProcessorChain getInstance() {
        return ProcessorChainHolder.INSTANCE;
    }

    public void completedHandler(DownloadSingleTaskDto downloadSingleTaskDto) {
        List<Processor> processorList = ProcessorBuilder.getInstance().getProcessors(this.getProcessorTypeByUrl(downloadSingleTaskDto.getDownloadUrl()));
        for (Processor processor : processorList) {
            if (processor.process(downloadSingleTaskDto)) continue;
            return;
        }
    }

    private String getProcessorTypeByUrl(String downloadUrl) {
        if (DownloadSingleUtils.isMatchTypeDownloadUrl(downloadUrl, UrlDataServiceHandler.getInstance().getDomainByScene("HOUP.NGINX"))) {
            return "houp";
        }
        return DownloadSingleUtils.getSourceType(downloadUrl);
    }

    private static class ProcessorChainHolder {
        private static final ProcessorChain INSTANCE = new ProcessorChain();

        private ProcessorChainHolder() {
        }
    }
}

