/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.process.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.http.dto.HttpClientDto;
import com.huawei.support.icscbb.util.http.dto.HttpHeaderDto;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icslite.business.common.serviceimpl.NetworkServiceHandler;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.process.impl.Processor;
import com.huawei.support.icslite.business.download.thread.DownloadVerifyThread;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Sha256Processor
implements Processor {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(Sha256Processor.class);

    public static Sha256Processor getInstance() {
        return Sha256ProcessorHolder.INSTANCE;
    }

    @Override
    public boolean process(DownloadSingleTaskDto downloadSingleTaskDto) {
        if (StringUtils.isBlank((CharSequence)downloadSingleTaskDto.getSha256())) {
            String sha256Str = this.retryGetSha256(downloadSingleTaskDto.getDownloadUrl());
            if (StringUtils.isBlank((CharSequence)sha256Str)) {
                CodeCCUtils.INSTANCE.infoLog(log, "This download url cannot get sha256, {0}", new Object[]{downloadSingleTaskDto.getDownloadUrl()});
                return true;
            }
            downloadSingleTaskDto.setSha256(sha256Str);
        }
        this.asyncThreadGetSha256(downloadSingleTaskDto);
        DownloadVerifyThread downloadVerifyThread = downloadSingleTaskDto.getDownloadVerifyThread();
        if (!downloadVerifyThread.isOver()) {
            return false;
        }
        return this.getValidateResult(downloadSingleTaskDto, downloadVerifyThread.getSha256());
    }

    private String retryGetSha256(String downloadUrl) {
        CodeCCUtils.INSTANCE.infoLog(log, "Task downloaded, retry get sha256.");
        try {
            HttpClientDto httpClientDto = NetworkServiceHandler.getInstance().getHttpClientDefault().newBuilder().url(downloadUrl).build();
            return Optional.ofNullable(NetWorkUtil.getHeaders((HttpClientDto)httpClientDto)).map(HttpHeaderDto::getHeaders).map(headers -> headers.get("SHA256")).orElse("");
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Task end, Network closed.", (Throwable)e);
            return "";
        }
    }

    private void asyncThreadGetSha256(DownloadSingleTaskDto downloadSingleTaskDto) {
        DownloadVerifyThread downloadVerifyThread = downloadSingleTaskDto.getDownloadVerifyThread();
        if (Objects.nonNull(downloadVerifyThread)) {
            return;
        }
        downloadSingleTaskDto.setCurrentStatus("7");
        downloadVerifyThread = new DownloadVerifyThread(downloadSingleTaskDto.getDownloadFilePath());
        DownloadSingleUtils.executeThread(downloadVerifyThread);
        downloadSingleTaskDto.setDownloadVerifyThread(downloadVerifyThread);
    }

    private boolean getValidateResult(DownloadSingleTaskDto downloadSingleTaskDto, String sha256Hex) {
        if (StringUtils.equals((CharSequence)sha256Hex, (CharSequence)downloadSingleTaskDto.getSha256())) {
            return true;
        }
        CodeCCUtils.INSTANCE.infoLog(log, "The download file sha256 cannot pass validate");
        downloadSingleTaskDto.setErrorCode(DownloadCode.ERROR_FILE_VALIDATE_FAILED.getDownloadCode());
        downloadSingleTaskDto.setErrorMsg(I18nResources.INSTANCE.getValueByKey("download.error.file.validate.failed"));
        downloadSingleTaskDto.setCurrentStatus("0");
        return false;
    }

    private static class Sha256ProcessorHolder {
        private static final Sha256Processor INSTANCE = new Sha256Processor();

        private Sha256ProcessorHolder() {
        }
    }
}

