/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.zipfile.ZipFileUtils;
import com.huawei.support.icslite.business.common.util.WindowsUtils;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.handler.DownloadCacheHandler;
import com.huawei.support.icslite.business.download.service.DownloadFileService;
import com.huawei.support.icslite.business.download.service.impl.DownloadRefreshServiceHandler;
import com.huawei.support.icslite.business.download.service.impl.DownloadSingleServiceHandler;
import com.huawei.support.icslite.business.download.thread.VerifyFileDownloadThread;
import com.huawei.support.icslite.business.download.thread.VerifyThread;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.convert.TaskConverter;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.business.libmanage.serviceimpl.LibManageServiceHandler;
import com.huawei.support.icslite.business.preferences.serviceimpl.DocumentSettingServiceHandler;
import com.huawei.support.icslite.download.dto.TaskDo;
import com.huawei.support.icslite.download.service.impl.DownloadServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.upgrade.util.FileResourceUtils;
import com.huawei.wsf.core.HWDecoder;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadFileServiceHandler
implements DownloadFileService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadFileServiceHandler.class);

    public static DownloadFileServiceHandler getInstance() {
        return DownloadFileServiceHandlerHolder.INSTANCE;
    }

    @Override
    public synchronized void unZipAndLoadFile(DownloadSingleTaskDto downloadSingleTaskDto) {
        String taskType = downloadSingleTaskDto.getTaskType();
        String downloadFilePath = downloadSingleTaskDto.getDownloadFilePath();
        if (StringUtils.equalsAny((CharSequence)taskType, (CharSequence[])new CharSequence[]{"1", "4"})) {
            this.taskTypeOfWindow(downloadSingleTaskDto, downloadFilePath);
            return;
        }
        this.taskTypeOfOnline(downloadSingleTaskDto, downloadFilePath);
    }

    @Override
    public void loadFile(DownloadSingleTaskDto downloadSingleTaskDto) {
        String unZipFilePath = downloadSingleTaskDto.getUnZipFilePath();
        String docId = LibManageServiceHandler.getInstance().getDocIdByPath(unZipFilePath);
        if (StringUtils.isNotBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(log, "load file success, the task id is {0}", new Object[]{downloadSingleTaskDto.getTaskId()});
            downloadSingleTaskDto.setLoadingStatus("2");
            downloadSingleTaskDto.setDocId(docId);
            downloadSingleTaskDto.setCurrentStatus("3");
            downloadSingleTaskDto.setCategory("2");
            downloadSingleTaskDto.setOperateTime(System.currentTimeMillis());
            String downloadPath = downloadSingleTaskDto.getDownloadFilePath();
            FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{downloadPath}));
            File file = FileUtils.getFile((String[])new String[]{unZipFilePath});
            downloadSingleTaskDto.setFileName(file.getName());
            DownloadCacheHandler.remove(downloadSingleTaskDto.getTaskId());
            DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
        } else {
            if (LibManageServiceHandler.getInstance().getInitState()) {
                return;
            }
            CodeCCUtils.INSTANCE.errorLog(log, "libManage Init completed. but can't get Docid.");
            this.setLibManageErrorMsg(unZipFilePath, downloadSingleTaskDto);
            downloadSingleTaskDto.setLoadingStatus("-1");
            downloadSingleTaskDto.setCurrentStatus("3");
            DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{unZipFilePath}));
        }
        TaskDo taskDo = TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
        DownloadServiceHandler.getInstance().updateTask(taskDo);
    }

    private void setLibManageErrorMsg(String unZipFilePath, DownloadSingleTaskDto downloadSingleTaskDto) {
        String libLoadErrorCodeByPath = LibManageServiceHandler.getInstance().getLibLoadErrorCodeByPath(unZipFilePath);
        String i18NKey = StringUtils.equals((CharSequence)libLoadErrorCodeByPath, (CharSequence)"0") ? "download.lib.loaded.error.repeat" : "download.lib.loaded.error.other";
        downloadSingleTaskDto.setErrorMsg(I18nResources.INSTANCE.getValueByKey(i18NKey));
    }

    @Override
    public boolean openDir(String taskId, String openDir) {
        DownloadSingleTaskDto downloadSingleTaskDto = DownloadSingleServiceHandler.getInstance().queryTask(taskId);
        if (downloadSingleTaskDto == null) {
            CodeCCUtils.INSTANCE.errorLog(log, "Open dir, but relation id not exists.");
            return false;
        }
        if (StringUtils.containsAny((CharSequence)downloadSingleTaskDto.getFileName(), (CharSequence[])new CharSequence[]{"|", "||", "\""})) {
            SecurityLogUtils.INSTANCE.securityLog("Download", "Open dir, but file name contains speical char.");
            return false;
        }
        String filePath = this.getFilePath(downloadSingleTaskDto);
        File file = FileUtils.getFile((String[])new String[]{filePath});
        if (StringUtils.equals((CharSequence)openDir, (CharSequence)"0")) {
            if (WindowsUtils.openDirByPath(filePath, file)) {
                return true;
            }
            return this.openDefaultFilePath(downloadSingleTaskDto, HWDecoder.decodeForHTML((String)file.getName()));
        }
        return WindowsUtils.desktopOpenFile(file);
    }

    @Override
    public void verifyFile(DownloadSingleTaskDto downloadSingleTaskDto, boolean isSoft) {
        String downloadUrl = downloadSingleTaskDto.getDownloadUrl();
        String ascFilePath = downloadSingleTaskDto.getDownloadDir() + File.separator + downloadSingleTaskDto.getFileName() + ".asc";
        String p7sFilePath = "";
        downloadSingleTaskDto.setLoadingStatus("3");
        downloadSingleTaskDto.setCurrentStatus("9");
        if (isSoft) {
            p7sFilePath = downloadSingleTaskDto.getDownloadDir() + File.separator + downloadSingleTaskDto.getFileName() + ".p7s";
            if (this.isDownloadFailed(ascFilePath, downloadUrl, downloadSingleTaskDto, isSoft) || this.isDownloadFailed(p7sFilePath, downloadUrl, downloadSingleTaskDto, isSoft)) {
                return;
            }
        } else {
            this.handlerDocDownloadVerifyFile(ascFilePath, downloadUrl, downloadSingleTaskDto, isSoft);
        }
        DownloadSingleUtils.executeVerifyThread(new VerifyThread(downloadSingleTaskDto, ascFilePath, p7sFilePath));
    }

    private void handlerDocDownloadVerifyFile(String ascFilePath, String downloadUrl, DownloadSingleTaskDto downloadSingleTaskDto, boolean isSoft) {
        if (!this.isDownloadFailed(ascFilePath, downloadUrl, downloadSingleTaskDto, isSoft)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)downloadSingleTaskDto.getErrorMsg())) {
            return;
        }
        DownloadRefreshServiceHandler.getInstance().changeToCompleteStatus(downloadSingleTaskDto);
    }

    private boolean isDownloadFailed(String filePath, String downloadUrl, DownloadSingleTaskDto downloadSingleTaskDto, boolean isSoft) {
        if (!DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{filePath}))) {
            this.handlerVerifyError(downloadSingleTaskDto, "20003");
            return true;
        }
        if (this.downloadVerifyFile(downloadUrl, filePath)) {
            return false;
        }
        if (isSoft) {
            this.handlerVerifyError(downloadSingleTaskDto, "20004");
            return true;
        }
        CodeCCUtils.INSTANCE.infoLog(log, "Download doc file not match verify file, file name is {0}", new Object[]{downloadSingleTaskDto.getFileName()});
        return true;
    }

    private void handlerVerifyError(DownloadSingleTaskDto downloadSingleTaskDto, String errorCode) {
        String[] errors = DownloadManangeUtils.errorHandler(errorCode);
        downloadSingleTaskDto.setErrorMsg(errors[1]);
        downloadSingleTaskDto.setCurrentStatus("3");
        downloadSingleTaskDto.setLoadingStatus("-5");
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
    }

    private boolean downloadVerifyFile(String downloadUrl, String filePath) {
        Future<String> downloadByFilePath = DownloadSingleUtils.executeDownloadVerifyThread(new VerifyFileDownloadThread(downloadUrl, filePath));
        try {
            return StringUtils.equals((CharSequence)downloadByFilePath.get(), (CharSequence)"success");
        }
        catch (InterruptedException | ExecutionException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Thread download verify file has exception", (Throwable)e);
            return false;
        }
    }

    private boolean openDefaultFilePath(DownloadSingleTaskDto downloadSingleTaskDto, String libName) {
        if (StringUtils.isBlank((CharSequence)libName)) {
            CodeCCUtils.INSTANCE.errorLog(log, "LibName isBlank");
            return false;
        }
        return WindowsUtils.desktopOpenFile(FileUtils.getFile((String[])new String[]{this.getDefaultPath(downloadSingleTaskDto, libName)}));
    }

    private String getDefaultPath(DownloadSingleTaskDto downloadSingleTaskDto, String libName) {
        String loadStatus = downloadSingleTaskDto.getLoadingStatus();
        if (StringUtils.equals((CharSequence)loadStatus, (CharSequence)"2")) {
            if (StringUtils.isBlank((CharSequence)downloadSingleTaskDto.getUnZipFilePath())) {
                return "";
            }
            int folderPathLength = downloadSingleTaskDto.getUnZipFilePath().length() - libName.length();
            return downloadSingleTaskDto.getUnZipFilePath().substring(0, folderPathLength);
        }
        return downloadSingleTaskDto.getDownloadDir();
    }

    private String getFilePath(DownloadSingleTaskDto downloadSingleTaskDto) {
        String loadingStatus = downloadSingleTaskDto.getLoadingStatus();
        if (StringUtils.equals((CharSequence)loadingStatus, (CharSequence)"2")) {
            return downloadSingleTaskDto.getUnZipFilePath();
        }
        return downloadSingleTaskDto.getDownloadDir() + File.separator + HWDecoder.decodeForHTML((String)downloadSingleTaskDto.getFileName());
    }

    private void taskTypeOfWindow(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath) {
        String downloadFileName = downloadSingleTaskDto.getFileName();
        String suffixFileName = DownloadManangeUtils.getSuffixFileName(downloadFileName);
        if (StringUtils.equalsIgnoreCase((CharSequence)suffixFileName, (CharSequence)".zip")) {
            this.zipFileLoad(downloadSingleTaskDto, downloadFilePath);
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)suffixFileName, (CharSequence[])new CharSequence[]{".hdx", ".hwics"})) {
            this.hdxFileAndHwicsFileLoad(downloadSingleTaskDto, downloadFilePath, downloadFileName);
            return;
        }
        this.noLoadingRequired(downloadSingleTaskDto);
    }

    private void taskTypeOfOnline(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath) {
        String relativeHdxPath = downloadSingleTaskDto.getRelativePath();
        if (StringUtils.isBlank((CharSequence)relativeHdxPath)) {
            this.handlerRelativePathEmpty(downloadSingleTaskDto);
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)DownloadManangeUtils.getSuffixFileName(relativeHdxPath), (CharSequence[])new CharSequence[]{".hdx", ".hwics"})) {
            this.handlerLoadLib(downloadSingleTaskDto, downloadFilePath, relativeHdxPath);
            return;
        }
        downloadSingleTaskDto.setCurrentStatus("3");
        downloadSingleTaskDto.setLoadingStatus("");
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
    }

    private void handlerLoadLib(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath, String relativeHdxPath) {
        downloadSingleTaskDto.setLoadingStatus("0");
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
        this.onlineTaskUnZipAndLoad(downloadSingleTaskDto, downloadFilePath, relativeHdxPath);
    }

    private void handlerRelativePathEmpty(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setCurrentStatus("3");
        downloadSingleTaskDto.setLoadingStatus("");
        downloadSingleTaskDto.setCategory("2");
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "UPDATE", "The relative path does not exist and cannot be loaded");
    }

    private void zipFileLoad(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath) {
        String unZipFileName = DownloadManangeUtils.readZipFile(downloadFilePath);
        String suffixFileNameInZip = DownloadManangeUtils.getSuffixFileName(unZipFileName);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)suffixFileNameInZip, (CharSequence[])new CharSequence[]{".hdx", ".hwics"})) {
            downloadSingleTaskDto.setLoadingStatus("0");
            TaskDo taskDo = TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
            DownloadServiceHandler.getInstance().updateTask(taskDo);
            this.windowTaskUnZipAndLoad(downloadSingleTaskDto, downloadFilePath, unZipFileName);
            return;
        }
        DownloadServiceHandler.getInstance().updateTask(this.noLoadingRequired(downloadSingleTaskDto));
    }

    private TaskDo noLoadingRequired(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setLoadingStatus("");
        downloadSingleTaskDto.setCurrentStatus("3");
        return TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
    }

    private void hdxFileAndHwicsFileLoad(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath, String downloadFileName) {
        downloadSingleTaskDto.setLoadingStatus("0");
        TaskDo taskDo = TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
        DownloadServiceHandler.getInstance().updateTask(taskDo);
        if (this.unMatchDiskFree(downloadSingleTaskDto, downloadFilePath)) {
            return;
        }
        File copyFileDir = FileUtils.getFile((String[])new String[]{DocumentSettingServiceHandler.getInstance().getDefaultLibPath()});
        File downloadFile = FileUtils.getFile((String[])new String[]{downloadFilePath});
        try {
            FileUtils.copyFileToDirectory((File)downloadFile, (File)copyFileDir);
        }
        catch (IOException e) {
            downloadSingleTaskDto.setCurrentStatus("3");
            downloadSingleTaskDto.setLoadingStatus("-1");
            downloadSingleTaskDto.setErrorMsg(I18nResources.INSTANCE.getValueByKey("download.lib.loaded.error.file.exception"));
            taskDo = TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
            DownloadServiceHandler.getInstance().updateTask(taskDo);
            CodeCCUtils.INSTANCE.errorLog(log, "copy file error", (Throwable)e);
            return;
        }
        String copyFilePath = DocumentSettingServiceHandler.getInstance().getDefaultLibPath() + File.separator + downloadFileName;
        this.reInitFile(copyFilePath, downloadSingleTaskDto);
    }

    private void windowTaskUnZipAndLoad(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath, String unZipFileName) {
        if (this.unMatchDiskFree(downloadSingleTaskDto, downloadFilePath)) {
            return;
        }
        String tempFileDir = DocumentSettingServiceHandler.getInstance().getDefaultLibPath() + File.separator + downloadSingleTaskDto.getTaskId();
        boolean isUnZip = ZipFileUtils.unZip((String)downloadFilePath, (String)tempFileDir);
        String realFileName = this.unZipProcess(tempFileDir, unZipFileName);
        this.loadProcess(realFileName, isUnZip, downloadSingleTaskDto);
    }

    private void onlineTaskUnZipAndLoad(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath, String relativeHdxPath) {
        if (this.unMatchDiskFree(downloadSingleTaskDto, downloadFilePath)) {
            return;
        }
        String tempFileDir = DocumentSettingServiceHandler.getInstance().getDefaultLibPath() + File.separator + downloadSingleTaskDto.getTaskId();
        boolean isUnZip = ZipFileUtils.unZipForExpectFile((String)downloadFilePath, (String)tempFileDir, (String)relativeHdxPath);
        int lastIndex = relativeHdxPath.lastIndexOf("/");
        String unZipFileName = relativeHdxPath.substring(lastIndex + 1);
        String realFileName = this.unZipProcess(tempFileDir, unZipFileName);
        this.loadProcess(realFileName, isUnZip, downloadSingleTaskDto);
    }

    private boolean unMatchDiskFree(DownloadSingleTaskDto downloadSingleTaskDto, String downloadFilePath) {
        boolean isFreeDisK;
        File defaultLibFile;
        String defaultLibPath;
        File file = FileUtils.getFile((String[])new String[]{downloadFilePath});
        long fileSize = 0L;
        if (file.exists()) {
            fileSize = file.length();
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultLibPath = DocumentSettingServiceHandler.getInstance().getDefaultLibPath())) && !(defaultLibFile = FileUtils.getFile((String[])new String[]{defaultLibPath})).exists()) {
            if (defaultLibFile.mkdirs()) {
                CodeCCUtils.INSTANCE.infoLog(log, "mkDefLibPathDirs success");
            } else {
                CodeCCUtils.INSTANCE.errorLog(log, "mkDefLibPathDirs fail. path is : {0}", new Object[]{defaultLibPath});
            }
        }
        boolean bl = isFreeDisK = FileResourceUtils.getFreeDisk((String)defaultLibPath) * 1024L * 1024L - fileSize * 4L > 0L;
        if (!isFreeDisK) {
            downloadSingleTaskDto.setLoadingStatus("-1");
            downloadSingleTaskDto.setCurrentStatus("3");
            downloadSingleTaskDto.setErrorMsg(String.format(I18nResources.INSTANCE.getValueByKey("download.lib.loaded.error.space.not.enough"), FileResourceUtils.getDiskName((String)DocumentSettingServiceHandler.getInstance().getDefaultLibPath())));
            TaskDo taskDo = TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
            DownloadServiceHandler.getInstance().updateTask(taskDo);
            CodeCCUtils.INSTANCE.errorLog(log, "Insufficient disk space");
            return true;
        }
        return false;
    }

    private void loadProcess(String realFileName, boolean isUnZip, DownloadSingleTaskDto downloadSingleTaskDto) {
        if (!isUnZip) {
            downloadSingleTaskDto.setLoadingStatus("-1");
            downloadSingleTaskDto.setErrorMsg(I18nResources.INSTANCE.getValueByKey("download.lib.loaded.error.file.exception"));
            TaskDo taskDo = TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
            DownloadServiceHandler.getInstance().updateTask(taskDo);
            CodeCCUtils.INSTANCE.errorLog(log, "unZip file error");
            return;
        }
        String unZipFilePath = DocumentSettingServiceHandler.getInstance().getDefaultLibPath() + File.separator + realFileName;
        this.reInitFile(unZipFilePath, downloadSingleTaskDto);
    }

    private void reInitFile(String unZipFilePath, DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setUnZipFilePath(unZipFilePath);
        downloadSingleTaskDto.setLoadingStatus("1");
        TaskDo taskDo = TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto);
        DownloadServiceHandler.getInstance().updateTask(taskDo);
        LibManageServiceHandler.getInstance().reInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String unZipProcess(String tempFileDir, String unZipFileName) {
        String fromFile = tempFileDir + File.separator + unZipFileName;
        String realFileName = DownloadSingleUtils.getRealFileName(unZipFileName, DocumentSettingServiceHandler.getInstance().getDefaultLibPath());
        File origFile = FileUtils.getFile((String[])new String[]{fromFile});
        File toFile = FileUtils.getFile((String[])new String[]{DocumentSettingServiceHandler.getInstance().getDefaultLibPath() + File.separator + realFileName});
        try {
            boolean isSuccess = origFile.renameTo(toFile);
            if (!isSuccess) {
                CodeCCUtils.INSTANCE.errorLog(log, "renameTo error.");
            }
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{tempFileDir}));
            throw throwable;
        }
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{tempFileDir}));
        return realFileName;
    }

    private static class DownloadFileServiceHandlerHolder {
        private static final DownloadFileServiceHandler INSTANCE = new DownloadFileServiceHandler();

        private DownloadFileServiceHandlerHolder() {
        }
    }
}

