/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.service.impl;

import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.handler.DownloadCacheHandler;
import com.huawei.support.icslite.business.download.service.DownloadInfoService;
import com.huawei.support.icslite.business.downloadmanage.convert.TaskConverter;
import com.huawei.support.icslite.download.service.impl.DownloadServiceHandler;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadInfoServiceHandler
implements DownloadInfoService {
    private long secondSpeedByte = 0L;

    public static DownloadInfoServiceHandler getInstance() {
        return DownloadListServiceHandlerHolder.INSTANCE;
    }

    @Override
    public List<DownloadSingleTaskDto> getWait() {
        return DownloadCacheHandler.getSingleTaskWaitDtos();
    }

    @Override
    public List<DownloadSingleTaskDto> getDownloading() {
        return DownloadCacheHandler.getDownloading();
    }

    @Override
    public List<DownloadSingleTaskDto> getLoadingDtoList() {
        return DownloadCacheHandler.getLoadingDtoList();
    }

    @Override
    public int getDownloadingListCount() {
        return DownloadCacheHandler.getDownloadingListCount();
    }

    @Override
    public int getDownloadingListCount(String startTime, String endTime) {
        return DownloadCacheHandler.getDownloadingListCount(startTime, endTime);
    }

    @Override
    public int getCompletedListCount(String startTime, String endTime) {
        return DownloadServiceHandler.getInstance().getCompletedListCount(startTime, endTime);
    }

    @Override
    public int getTrashBoxListCount() {
        return DownloadServiceHandler.getInstance().getTrashBoxListCount();
    }

    @Override
    public List<DownloadSingleTaskDto> getDownloadingList() {
        List<DownloadSingleTaskDto> downloadSingleTaskDtos = DownloadCacheHandler.getDownloadingList();
        if (CollectionUtils.isEmpty(downloadSingleTaskDtos)) {
            return downloadSingleTaskDtos;
        }
        Collections.sort(downloadSingleTaskDtos);
        this.countSpeedRate(downloadSingleTaskDtos);
        return downloadSingleTaskDtos;
    }

    @Override
    public List<DownloadSingleTaskDto> getDownloadingList(int pageNo, int pageSize, String startTime, String endTime) {
        List<DownloadSingleTaskDto> downloadSingleTaskDtos = ObjectUtils.allNull((Object[])new Object[]{startTime, endTime}) ? DownloadCacheHandler.getDownloadingList() : DownloadCacheHandler.getDownloadingList(startTime, endTime);
        if (CollectionUtils.isEmpty(downloadSingleTaskDtos)) {
            return downloadSingleTaskDtos;
        }
        Collections.sort(downloadSingleTaskDtos);
        if (pageNo != -1 && pageSize != -1) {
            downloadSingleTaskDtos = this.pagination(pageSize, pageNo, downloadSingleTaskDtos);
        }
        this.countSpeedRate(downloadSingleTaskDtos);
        return downloadSingleTaskDtos;
    }

    @Override
    public List<DownloadSingleTaskDto> getCompletedList(int pageNo, int pageSize, String startTime, String endTime) {
        return TaskConverter.INSTANCE.toDtoList(DownloadServiceHandler.getInstance().getCompletedList(pageNo, pageSize, startTime, endTime));
    }

    @Override
    public List<DownloadSingleTaskDto> getTrashBoxList() {
        return TaskConverter.INSTANCE.toDtoList(DownloadServiceHandler.getInstance().getTrashBoxList());
    }

    @Override
    public List<DownloadSingleTaskDto> getTrashBoxList(int pageNo, int pageSize) {
        return TaskConverter.INSTANCE.toDtoList(DownloadServiceHandler.getInstance().getTrashBoxList(pageNo, pageSize));
    }

    @Override
    public List<DownloadSingleTaskDto> getAllList() {
        return TaskConverter.INSTANCE.toDtoList(DownloadServiceHandler.getInstance().queryAllTask());
    }

    @Override
    public int getWaitCount() {
        return DownloadCacheHandler.getWaitCount();
    }

    @Override
    public int getLoadingCount() {
        return DownloadCacheHandler.getLoadingCount();
    }

    @Override
    public int getVerifyingCount() {
        return DownloadCacheHandler.getVerifyingCount();
    }

    @Override
    public int getDeletingCount() {
        return DownloadCacheHandler.getDeletingCount();
    }

    @Override
    public int getDownloadingCount() {
        return DownloadCacheHandler.getDownloadingCount();
    }

    @Override
    public int getSignVerifyingCount() {
        return DownloadCacheHandler.getSignVerifyingCount();
    }

    private List<DownloadSingleTaskDto> pagination(int pageSize, int pageNo, List<DownloadSingleTaskDto> dtos) {
        int totalCount = dtos.size();
        int temp = totalCount % pageSize;
        int pageCount = totalCount / pageSize + (temp > 0 ? 1 : 0);
        int startIndex = Math.subtractExact(pageNo, 1) * pageSize;
        int endIndex = Math.multiplyExact(pageSize, pageNo);
        if (temp == 0) {
            return dtos.subList(startIndex, endIndex);
        }
        return dtos.subList(startIndex, pageNo == pageCount ? totalCount : endIndex);
    }

    private void countSpeedRate(List<DownloadSingleTaskDto> downloadSingleTaskDtos) {
        long sumBytes = 0L;
        for (DownloadSingleTaskDto downloadSingleTaskDto : downloadSingleTaskDtos) {
            long secondSpeed;
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)downloadSingleTaskDto.getCurrentStatus()) || StringUtils.isNotBlank((CharSequence)downloadSingleTaskDto.getLoadingStatus())) continue;
            Deque<Long> downloadSizes = downloadSingleTaskDto.getDownloadSizes();
            Deque<Long> times = downloadSingleTaskDto.getTimes();
            if (downloadSizes.isEmpty() || times.isEmpty()) continue;
            long speedTime = times.getLast() - times.getFirst();
            long l = secondSpeed = speedTime == 0L ? 0L : (downloadSizes.getLast() - downloadSizes.getFirst()) / speedTime * 1000L;
            if (secondSpeed < 0L) {
                secondSpeed = 0L;
            }
            sumBytes += secondSpeed;
            downloadSingleTaskDto.setSpeedRate(String.valueOf(secondSpeed));
            downloadSingleTaskDto.setDownloadSize(downloadSizes.getLast());
        }
        this.secondSpeedByte = sumBytes;
    }

    @Override
    public long getSecondBytes() {
        return this.secondSpeedByte;
    }

    private static class DownloadListServiceHandlerHolder {
        private static final DownloadInfoServiceHandler INSTANCE = new DownloadInfoServiceHandler();

        private DownloadListServiceHandlerHolder() {
        }
    }
}

