/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.handler.FilePointTaskHandler;
import com.huawei.support.icslite.business.download.helper.DownloadRefreshHelper;
import com.huawei.support.icslite.business.download.service.DownloadRefreshService;
import com.huawei.support.icslite.business.download.service.impl.DownloadInfoServiceHandler;
import com.huawei.support.icslite.business.download.thread.DownloadFileThread;
import com.huawei.support.icslite.business.download.thread.SingleTaskThread;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.convert.TaskConverter;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.download.service.impl.DownloadServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadRefreshServiceHandler
implements DownloadRefreshService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadRefreshServiceHandler.class);
    private static final Pattern PATTERN = Pattern.compile("[\\\\/:\\*?\"<>|]");

    public static DownloadRefreshServiceHandler getInstance() {
        return DownloadRefreshServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void refreshDownloadingData() {
        DownloadInfoServiceHandler.getInstance().getDownloading().forEach(downloadSingleTaskDto -> {
            this.refreshErrorData((DownloadSingleTaskDto)downloadSingleTaskDto);
            DownloadRefreshHelper.getInstance().refreshDownloadSingleDto((DownloadSingleTaskDto)downloadSingleTaskDto);
        });
    }

    @Override
    public void refreshStartDownload() {
        DownloadInfoServiceHandler.getInstance().getDownloading().forEach(this::refreshStartDownload);
    }

    @Override
    public void refreshWaitData(int maxSyncDownloadCount) {
        int downloadingSize = DownloadInfoServiceHandler.getInstance().getDownloadingCount() + DownloadInfoServiceHandler.getInstance().getVerifyingCount();
        int supplementCount = Math.subtractExact(maxSyncDownloadCount, downloadingSize);
        if (supplementCount <= 0) {
            return;
        }
        DownloadInfoServiceHandler.getInstance().getWait().stream().limit(supplementCount).forEach(downloadSingleTaskDto -> {
            downloadSingleTaskDto.setCurrentStatus("1");
            downloadSingleTaskDto.setTaskBeginTime(System.currentTimeMillis());
            DownloadRefreshHelper.getInstance().readyAndStart((DownloadSingleTaskDto)downloadSingleTaskDto);
            this.updateTask((DownloadSingleTaskDto)downloadSingleTaskDto);
        });
    }

    private void refreshStartDownload(DownloadSingleTaskDto downloadSingleTaskDto) {
        long fileSize = downloadSingleTaskDto.getFileSize();
        if (fileSize > 0L && !downloadSingleTaskDto.isStart()) {
            String realFileName = downloadSingleTaskDto.getFileName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)downloadSingleTaskDto.getIsDefaultName(), (CharSequence)"1")) {
                realFileName = DownloadSingleUtils.getRealFileName(downloadSingleTaskDto.getFileName(), downloadSingleTaskDto.getDownloadDir());
            }
            this.handlerDownloadDirNotExist(downloadSingleTaskDto.getDownloadDir());
            String filePath = downloadSingleTaskDto.getDownloadDir() + File.separator + realFileName;
            File downloadFile = FileUtils.getFile((String[])new String[]{filePath});
            if (!this.checkDiskFreeForDownloadTask(downloadSingleTaskDto) && !downloadFile.isFile()) {
                this.updateNoDiskTask(downloadSingleTaskDto);
                return;
            }
            if (!this.isExistsDownloadDir(downloadSingleTaskDto)) {
                this.updateTaskError(downloadSingleTaskDto, DownloadCode.ERROR_FILE_CREATE_FAILED.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.file.create"));
                return;
            }
            this.initTaskData(downloadSingleTaskDto, realFileName);
            FilePointTaskHandler.initPoint(downloadSingleTaskDto);
            DownloadRefreshHelper.getInstance().startDownload(downloadSingleTaskDto);
            downloadSingleTaskDto.setStart(Boolean.TRUE);
        }
        this.initTaskProcess(downloadSingleTaskDto);
    }

    private void handlerDownloadDirNotExist(String downloadDir) {
        File dirFile = FileUtils.getFile((String[])new String[]{downloadDir});
        if (dirFile.exists() && dirFile.isDirectory()) {
            return;
        }
        if (dirFile.mkdirs()) {
            CodeCCUtils.INSTANCE.infoLog(log, "Download file dir path mkdirs success");
        } else {
            CodeCCUtils.INSTANCE.errorLog(log, "Download file dir path mkdirs fail. path is : {0}", new Object[]{downloadDir});
        }
    }

    private void refreshErrorData(DownloadSingleTaskDto downloadSingleTaskDto) {
        DownloadFileThread[] threads;
        for (DownloadFileThread thread : threads = downloadSingleTaskDto.getThreads()) {
            String errorCode;
            if (thread == null || StringUtils.isBlank((CharSequence)(errorCode = thread.getErrorCode())) || StringUtils.equalsAny((CharSequence)errorCode, (CharSequence[])new CharSequence[]{DownloadCode.ERROR.getDownloadCode(), DownloadCode.ERROR_CONNECT_FAILED.getDownloadCode(), DownloadCode.ERROR_DATA_FAILED.getDownloadCode(), DownloadCode.ERROR_FILE_NOT_EXISTS.getDownloadCode()}) && thread.getFailedCount() < Integer.parseInt(ConfigServiceHandler.getInstance().get("download.max.retry.times"))) continue;
            this.countSpendTime(downloadSingleTaskDto);
            downloadSingleTaskDto.setErrorCode(errorCode);
            downloadSingleTaskDto.setErrorMsg(thread.getErrorMessage());
            downloadSingleTaskDto.setCurrentStatus("0");
            this.updateTask(downloadSingleTaskDto);
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to create the download file or download failure retry times exceeded.");
            break;
        }
    }

    @Override
    public void countSpendTime(DownloadSingleTaskDto downloadSingleTaskDto) {
        long taskBeginTime = downloadSingleTaskDto.getTaskBeginTime();
        if (taskBeginTime == 0L) {
            return;
        }
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{downloadSingleTaskDto.getErrorCode(), downloadSingleTaskDto.getLoadingStatus()})) {
            return;
        }
        long singleSpend = Math.subtractExact(System.currentTimeMillis(), taskBeginTime);
        downloadSingleTaskDto.setSpendTime(singleSpend + downloadSingleTaskDto.getSpendTime());
    }

    @Override
    public void changeToStartStatus(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setLastStatus(downloadSingleTaskDto.getCurrentStatus());
        downloadSingleTaskDto.setCurrentStatus("2");
        downloadSingleTaskDto.setNextStatus("");
        downloadSingleTaskDto.setStart(Boolean.FALSE);
        DownloadServiceHandler.getInstance().updateTaskAndRecordOperate(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
    }

    @Override
    public void changeToCompleteStatus(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setCurrentStatus("3");
        downloadSingleTaskDto.setLoadingStatus("");
        downloadSingleTaskDto.setCategory("2");
        downloadSingleTaskDto.setOperateTime(System.currentTimeMillis());
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
    }

    private boolean checkDiskFreeForDownloadTask(DownloadSingleTaskDto downloadSingleTaskDto) {
        long fileSize = downloadSingleTaskDto.getFileSize();
        int hit = downloadSingleTaskDto.getDownloadDir().indexOf(":");
        String diskChar = downloadSingleTaskDto.getDownloadDir().substring(0, hit + 1);
        long freeDiskSpace = DownloadManangeUtils.getFreeDisk(diskChar);
        return freeDiskSpace - fileSize > 0L;
    }

    private void updateNoDiskTask(DownloadSingleTaskDto downloadSingleTaskDto) {
        downloadSingleTaskDto.setCurrentStatus("0");
        downloadSingleTaskDto.setErrorCode(DownloadCode.ERROR_NO_FREE_DISK.getDownloadCode());
        downloadSingleTaskDto.setErrorMsg(I18nResources.INSTANCE.getValueByKey("download.error.no.free.disk"));
        CodeCCUtils.INSTANCE.errorLog(log, "Insufficient disk space for download task");
        this.updateTask(downloadSingleTaskDto);
    }

    private boolean isExistsDownloadDir(DownloadSingleTaskDto downloadSingleTaskDto) {
        File foldr = FileUtils.getFile((String[])new String[]{downloadSingleTaskDto.getDownloadDir()});
        if (foldr.exists()) {
            return true;
        }
        if (!foldr.mkdirs()) {
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to create the download directory.");
            return false;
        }
        return true;
    }

    private void initTaskProcess(DownloadSingleTaskDto downloadSingleTaskDto) {
        if (downloadSingleTaskDto.isStart()) {
            return;
        }
        SingleTaskThread singleTaskThread = downloadSingleTaskDto.getSingleTaskThread();
        if (singleTaskThread == null) {
            return;
        }
        if (!singleTaskThread.isOver()) {
            return;
        }
        String errorCode = singleTaskThread.getErrorCode();
        if (StringUtils.isNotBlank((CharSequence)errorCode)) {
            this.updateTaskError(downloadSingleTaskDto, errorCode, singleTaskThread.getErrorMsg());
            return;
        }
        if (!singleTaskThread.isInit()) {
            return;
        }
        long fileSize = singleTaskThread.getFileSize();
        downloadSingleTaskDto.setFileSize(singleTaskThread.getFileSize());
        downloadSingleTaskDto.setFileName(singleTaskThread.getFileName());
        downloadSingleTaskDto.setSha256(singleTaskThread.getSha256());
        FilePointTaskHandler.initPointSize(downloadSingleTaskDto, fileSize);
    }

    private void initTaskData(DownloadSingleTaskDto downloadSingleTaskDto, String realFileName) {
        downloadSingleTaskDto.setIsDefaultName("1");
        downloadSingleTaskDto.setFileName(realFileName);
        this.updateTask(downloadSingleTaskDto);
        this.handlerFileNameCharacter(downloadSingleTaskDto);
        this.initDownloadFile(downloadSingleTaskDto.getDownloadFilePath(), downloadSingleTaskDto.getFileSize());
        downloadSingleTaskDto.setErrorCode("");
        downloadSingleTaskDto.setErrorMsg("");
        if (downloadSingleTaskDto.getTaskBeginTime() == 0L) {
            downloadSingleTaskDto.setTaskBeginTime(System.currentTimeMillis());
        }
    }

    private void initDownloadFile(String downloadFilePath, long fileSize) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(downloadFilePath, "rw");){
            randomAccessFile.setLength(fileSize);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Create task file, occur error.", (Throwable)e);
        }
    }

    private void handlerFileNameCharacter(DownloadSingleTaskDto downloadSingleTaskDto) {
        Matcher matcher = PATTERN.matcher(downloadSingleTaskDto.getFileName());
        downloadSingleTaskDto.setFileName(matcher.replaceAll("_").trim());
    }

    private void updateTaskError(DownloadSingleTaskDto downloadSingleTaskDto, String errorCode, String errorMsg) {
        downloadSingleTaskDto.setCurrentStatus("0");
        downloadSingleTaskDto.setErrorCode(errorCode);
        downloadSingleTaskDto.setErrorMsg(errorMsg);
        this.updateTask(downloadSingleTaskDto);
    }

    private void updateTask(DownloadSingleTaskDto downloadSingleTaskDto) {
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
    }

    private static class DownloadRefreshServiceHandlerHolder {
        private static final DownloadRefreshServiceHandler INSTANCE = new DownloadRefreshServiceHandler();

        private DownloadRefreshServiceHandlerHolder() {
        }
    }
}

