/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.handler.DownloadCacheHandler;
import com.huawei.support.icslite.business.download.handler.FilePointTaskHandler;
import com.huawei.support.icslite.business.download.service.DownloadSingleService;
import com.huawei.support.icslite.business.download.thread.DownloadFileThread;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.convert.TaskConverter;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.business.preferences.serviceimpl.PreferencesServiceHandler;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.download.dto.TaskDo;
import com.huawei.support.icslite.download.service.impl.DownloadServiceHandler;
import com.huawei.wsf.core.HWEncoder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadSingleServiceHandler
implements DownloadSingleService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadSingleServiceHandler.class);
    private static final TypeReference<List<String>> LIST_STRING_REFERENCE = new TypeReference<List<String>>(){};

    public static DownloadSingleServiceHandler getInstance() {
        return DownloadSingleServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        DownloadServiceHandler.getInstance().createTb();
    }

    @Override
    public boolean addDownloadingTask(DownloadSingleTaskDto taskDto) {
        return DownloadCacheHandler.addDownloadingTask(taskDto);
    }

    @Override
    public boolean addDownloadingTasks(List<DownloadSingleTaskDto> taskDtos) {
        return Boolean.parseBoolean(this.addTasks(taskDtos).get("isSuccess").toString());
    }

    @Override
    public List<String> addOffLineTasks(List<DownloadSingleTaskDto> taskDtos) {
        return (List)new ObjectMapper().convertValue(this.addTasks(taskDtos).get("idList"), LIST_STRING_REFERENCE);
    }

    private Map<String, Object> addTasks(List<DownloadSingleTaskDto> taskDtos) {
        ArrayList<DownloadSingleTaskDto> addList = new ArrayList<DownloadSingleTaskDto>();
        ArrayList<String> idList = new ArrayList<String>();
        boolean isSuccess = true;
        for (DownloadSingleTaskDto taskDto : taskDtos) {
            if (taskDto == null || StringUtils.equalsAny((CharSequence)taskDto.getTaskType(), (CharSequence[])new CharSequence[]{"4", "1"}) && !this.canonicalPath(taskDto)) continue;
            if (!this.addDownloadingTask(taskDto)) {
                isSuccess = false;
                break;
            }
            addList.add(taskDto);
            idList.add(taskDto.getTaskId());
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("isSuccess", isSuccess);
        resultMap.put("idList", idList);
        if (CollectionUtils.isEmpty(idList)) {
            return resultMap;
        }
        DownloadServiceHandler.getInstance().addTasks(TaskConverter.INSTANCE.toDoList(addList));
        return resultMap;
    }

    private boolean canonicalPath(DownloadSingleTaskDto taskDto) {
        File file = FileUtils.getFile((String[])new String[]{taskDto.getDownloadDir()});
        try {
            String canonicalPath = file.getCanonicalPath();
            if (!StringUtils.equals((CharSequence)canonicalPath, (CharSequence)taskDto.getDownloadDir())) {
                taskDto.setDownloadDir(canonicalPath);
                SecurityLogUtils.INSTANCE.securityLog("Download", "DownloadDir transform to canonicalPath.");
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Invalid downloadDir.");
            return false;
        }
        return true;
    }

    @Override
    public void updateSingleTaskStatus(DownloadSingleTaskDto downloadSingleTaskDto) {
        DownloadCacheHandler.remove(downloadSingleTaskDto.getTaskId());
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
    }

    @Override
    public void directDeleteTask(String taskId) {
        if (!DownloadCacheHandler.updateTaskToDelete(taskId)) {
            DownloadServiceHandler.getInstance().finalDeleteTask(taskId);
        }
    }

    @Override
    public void deleteTask(String taskId) {
        if (!DownloadCacheHandler.updateCategoryToTrashBox(taskId)) {
            DownloadServiceHandler.getInstance().deleteTask(taskId);
        }
    }

    @Override
    public void deleteTaskByTrashBox(String taskId) {
        DownloadCacheHandler.remove(taskId);
        DownloadServiceHandler.getInstance().finalDeleteTask(taskId);
    }

    @Override
    public void deleteAllTrashTask() {
        DownloadServiceHandler.getInstance().deleteAllTrashTask();
    }

    @Override
    public void writeAllPoint() {
        DownloadCacheHandler.writeAllPoint();
    }

    @Override
    public void toStart(DownloadFileThread downloadFileThread) {
        downloadFileThread.setErrorCode("");
        downloadFileThread.setErrorMessage("");
        downloadFileThread.splitterRestoreStop();
        DownloadSingleUtils.executeThread(downloadFileThread);
    }

    @Override
    public void stopDownload(DownloadSingleTaskDto downloadSingleTaskDto) {
        DownloadFileThread[] downloadFileThreads = downloadSingleTaskDto.getThreads();
        Arrays.stream(downloadFileThreads).filter(Objects::nonNull).forEach(DownloadFileThread::splitterStop);
        FilePointTaskHandler.writeSinglePoint(downloadSingleTaskDto);
    }

    @Override
    public boolean checkTaskDto(DownloadSingleTaskDto taskDto) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskDto.getDownloadUrl(), taskDto.getTaskType()})) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)taskDto.getDownloadDir())) {
            taskDto.setDownloadDir(PreferencesServiceHandler.getInstance().getDownloadConfig().getPath());
        }
        return true;
    }

    @Override
    public void updateTask(DownloadSingleTaskDto downloadSingleTaskDto) {
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(downloadSingleTaskDto));
    }

    @Override
    public void updateNoLoginInData() {
        DownloadCacheHandler.getDownloadingList().stream().filter(downloadSingleTaskDto -> StringUtils.equals((CharSequence)downloadSingleTaskDto.getErrorCode(), (CharSequence)DownloadCode.ERROR_NO_LOGIN_IN.getDownloadCode())).forEach(downloadSingleTaskDto -> {
            downloadSingleTaskDto.setErrorCode("");
            downloadSingleTaskDto.setErrorMsg("");
            DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo((DownloadSingleTaskDto)downloadSingleTaskDto));
        });
    }

    @Override
    public void pauseTask(String taskId) {
        DownloadCacheHandler.updateStatusToPause(taskId);
    }

    @Override
    public void startTask(String taskId) {
        DownloadCacheHandler.updateStatusToDownloading(taskId);
    }

    @Override
    public boolean deleteDownloadFile(String taskId) {
        TaskDo taskDo = DownloadServiceHandler.getInstance().queryTask(taskId);
        if (taskDo != null) {
            boolean isDelete;
            String pointFilePath = taskDo.getDownloadDir() + File.separator + taskDo.getFileName() + ".info";
            File pointFile = FileUtils.getFile((String[])new String[]{pointFilePath});
            if (pointFile.exists() && !(isDelete = pointFile.delete())) {
                CodeCCUtils.INSTANCE.errorLog(log, "delete task error.");
            }
            return this.deleteAllDownloadFile(taskDo.getDownloadDir() + File.separator + taskDo.getFileName());
        }
        return true;
    }

    private boolean deleteAllDownloadFile(String downloadFilePath) {
        boolean mainFileDelete = DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{downloadFilePath}));
        boolean ascFileDelete = DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{downloadFilePath + ".asc"}));
        boolean p7sFileDelete = DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{downloadFilePath + ".p7s"}));
        return mainFileDelete && ascFileDelete && p7sFileDelete;
    }

    @Override
    public boolean restoreCompleteTask(List<DownloadSingleTaskDto> taskDtos) {
        Collections.reverse(taskDtos);
        for (DownloadSingleTaskDto taskDto : taskDtos) {
            if (taskDto == null) {
                CodeCCUtils.INSTANCE.errorLog(log, "restore task, but task is null.");
                continue;
            }
            TaskDo taskDo = TaskConverter.INSTANCE.dtoToDo(taskDto);
            taskDo.setCategory("2");
            DownloadServiceHandler.getInstance().updateTaskAndRecordOperate(taskDo);
        }
        return true;
    }

    @Override
    public boolean restoreDownloadTask(List<DownloadSingleTaskDto> taskDtos) {
        boolean isSuccess = true;
        Collections.reverse(taskDtos);
        for (DownloadSingleTaskDto taskDto : taskDtos) {
            if (taskDto == null) {
                CodeCCUtils.INSTANCE.errorLog(log, "restore task, but task is null.");
                continue;
            }
            isSuccess = DownloadCacheHandler.updateStatusToRestore(taskDto);
            if (isSuccess) continue;
            break;
        }
        return isSuccess;
    }

    @Override
    public boolean restartTask(String taskId) {
        TaskDo taskDo = DownloadServiceHandler.getInstance().queryTask(taskId);
        if (taskDo == null) {
            CodeCCUtils.INSTANCE.errorLog(log, "restart task, but task is null.");
            return true;
        }
        DownloadSingleTaskDto taskDto = TaskConverter.INSTANCE.doToDto(taskDo);
        boolean isSucceed = DownloadCacheHandler.updateStatusToRestart(taskDto);
        if (isSucceed) {
            DownloadServiceHandler.getInstance().updateTaskAndRecordOperate(taskDo);
        }
        return isSucceed;
    }

    @Override
    public DownloadSingleTaskDto queryTask(String taskId) {
        DownloadSingleTaskDto downloadSingleTaskDto = DownloadCacheHandler.get(taskId);
        if (downloadSingleTaskDto != null) {
            return downloadSingleTaskDto;
        }
        TaskDo taskDo = DownloadServiceHandler.getInstance().queryTask(taskId);
        return TaskConverter.INSTANCE.doToDto(taskDo);
    }

    @Override
    public Map<String, Set<String>> validatedRepeatedTask(List<String> taskDownloadUrlList) {
        List recordDownloadUrlList = DownloadServiceHandler.getInstance().queryAllTask().stream().map(TaskDo::getDownloadUrl).filter(StringUtils::isNotBlank).map(downloadUrl -> HWEncoder.encodeForHTMLAttribute((String)downloadUrl.trim())).collect(Collectors.toList());
        List taskDownloadUrlListEncoder = taskDownloadUrlList.stream().filter(downloadUrl -> StringUtils.isNotBlank((CharSequence)downloadUrl) && downloadUrl.length() <= 2048).map(downloadUrl -> HWEncoder.encodeForHTMLAttribute((String)downloadUrl.trim())).collect(Collectors.toList());
        Set repeatedTaskDownloadUrlSet = taskDownloadUrlListEncoder.stream().filter(recordDownloadUrlList::contains).collect(Collectors.toSet());
        Set addTaskDownloadUrlSet = taskDownloadUrlListEncoder.stream().filter(downloadUrl -> !recordDownloadUrlList.contains(downloadUrl)).collect(Collectors.toSet());
        HashMap<String, Set<String>> tasksMap = new HashMap<String, Set<String>>();
        tasksMap.put("repeatedList", repeatedTaskDownloadUrlSet);
        tasksMap.put("addList", addTaskDownloadUrlSet);
        return tasksMap;
    }

    private static class DownloadSingleServiceHandlerHolder {
        private static final DownloadSingleServiceHandler INSTANCE = new DownloadSingleServiceHandler();

        private DownloadSingleServiceHandlerHolder() {
        }
    }
}

