/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.HoupDownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icscbb.util.http.exception.SupportDownloadException;
import com.huawei.support.icslite.business.download.enums.DownloadEnum;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.business.preferences.serviceimpl.DownloadSettingServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.TimeUnit;

public class DownloadFileThread
extends Thread {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadFileThread.class);
    private static final int BYTE_DEFAULT_SIZE = 8192;
    volatile boolean downloadStop = false;
    volatile boolean downloadSleep = false;
    volatile boolean downloadOver = false;
    String errorCode;
    String errorMessage;
    long startPoint;
    long currentPoint;
    long endPoint;
    String downloadPath;
    String downloadUrl;
    volatile long fileSize;
    int failedCount;

    public DownloadFileThread(long[] point, long fileSize, String downloadPath, String downloadUrl) {
        super.setName("DownloadFileThread");
        this.startPoint = point[0];
        this.currentPoint = point[1];
        this.endPoint = point[2];
        this.fileSize = fileSize;
        this.downloadPath = downloadPath;
        this.downloadUrl = downloadUrl;
    }

    @Override
    public void run() {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.downloadPath, "rw");){
            randomAccessFile.setLength(this.fileSize);
            this.downloadProcess(randomAccessFile);
        }
        catch (IOException e) {
            this.errorCode = DownloadCode.ERROR_FILE_CREATE_FAILED.getDownloadCode();
            this.errorMessage = I18nResources.INSTANCE.getValueByKey("download.error");
            CodeCCUtils.INSTANCE.errorLog(log, "Download error, pointer error.", (Throwable)e);
        }
    }

    private void downloadProcess(RandomAccessFile randomAccessFile) {
        this.failedCount = 0;
        if (this.download(randomAccessFile)) {
            return;
        }
        while (this.failedCount < Integer.parseInt(ConfigServiceHandler.getInstance().get("download.max.retry.times")) && !this.downloadStop && !this.download(randomAccessFile)) {
            ++this.failedCount;
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.errorLog(log, "Download retry, interrupted.", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean download(RandomAccessFile randomAccessFile) {
        this.errorCode = "";
        this.errorMessage = "";
        try (InputStream input = DownloadEnum.getSplitInputStreamByUrl(this.downloadUrl, this.currentPoint, this.endPoint);){
            if (input == null) {
                this.errorCode = DownloadCode.NETWORK_ERROR_OR_PROXY_ERROR.getDownloadCode();
                this.errorMessage = I18nResources.INSTANCE.getValueByKey("download.error.conn.exception");
                CodeCCUtils.INSTANCE.errorLog(log, "Download InputStream is null.");
                boolean bl = false;
                return bl;
            }
            randomAccessFile.seek(this.currentPoint);
            byte[] bytes = new byte[8192];
            int readByte = input.read(bytes, 0, this.getDownloadBufferSize());
            while (readByte > 0 && !this.downloadStop) {
                randomAccessFile.write(bytes, 0, readByte);
                this.currentPoint += (long)readByte;
                this.downloadSleep();
                readByte = input.read(bytes, 0, this.getDownloadBufferSize());
            }
            if (this.currentPoint < this.endPoint) return this.downloadOver;
            this.downloadOver = true;
            return this.downloadOver;
        }
        catch (NetWorkSwitchException e) {
            this.errorCode = DownloadCode.ERROR_NETWORK_CLOSED.getDownloadCode();
            this.errorMessage = I18nResources.INSTANCE.getValueByKey("download.error.network.closed");
            CodeCCUtils.INSTANCE.errorLog(log, "NetWorkSwitchException.", (Throwable)e);
            return this.downloadOver;
        }
        catch (HoupDownloadException | SupportDownloadException e) {
            String[] errors = DownloadManangeUtils.errorHandler(e.getMessage());
            this.errorCode = errors[0];
            this.errorMessage = errors[1];
            CodeCCUtils.INSTANCE.errorLog(log, "SupportDownloadException.", e);
            return this.downloadOver;
        }
        catch (DownloadException e) {
            this.errorCode = DownloadCode.ERROR_DATA_FAILED.getDownloadCode();
            this.errorMessage = I18nResources.INSTANCE.getValueByKey("download.error.data.failed");
            CodeCCUtils.INSTANCE.errorLog(log, "DownloadException.", (Throwable)e);
            return this.downloadOver;
        }
        catch (IOException e) {
            this.errorCode = DownloadCode.ERROR.getDownloadCode();
            this.errorMessage = I18nResources.INSTANCE.getValueByKey("download.error");
            CodeCCUtils.INSTANCE.errorLog(log, "Download IOException.", (Throwable)e);
        }
        return this.downloadOver;
    }

    private void downloadSleep() {
        if (this.downloadSleep) {
            try {
                TimeUnit.MILLISECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.errorLog(log, "DownloadFileThread interrupted.", (Throwable)e);
            }
        }
    }

    private int getDownloadBufferSize() {
        if (!DownloadSettingServiceHandler.getInstance().isOpenDownloadRate()) {
            return 8192;
        }
        return DownloadSettingServiceHandler.getInstance().getLeftBufferSize(8192);
    }

    public void splitterStop() {
        this.downloadStop = true;
    }

    public void splitterSleep() {
        this.downloadSleep = true;
    }

    public void splitterAwake() {
        this.downloadSleep = false;
    }

    public void splitterRestoreStop() {
        this.downloadStop = false;
    }

    public long getStartPoint() {
        return this.startPoint;
    }

    public long getCurrentPoint() {
        return this.currentPoint;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public boolean isDownloadOver() {
        return this.downloadOver;
    }
}

