/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.dto.HttpHeaderDto;
import com.huawei.support.icscbb.util.http.exception.DownloadException;
import com.huawei.support.icscbb.util.http.exception.NetWorkSwitchException;
import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.enums.DownloadEnum;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Headers;
import org.apache.commons.lang3.StringUtils;

public class SingleTaskThread
extends Thread {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(SingleTaskThread.class);
    private DownloadSingleTaskDto downloadSingleTaskDto;
    private String redirectUrl;
    private String downloadUrl;
    private boolean isInit;
    private boolean isOver;
    private String errorCode;
    private String errorMsg;
    private String fileName;
    private long fileSize;
    private String sha256;

    public SingleTaskThread(DownloadSingleTaskDto downloadSingleTaskDto) {
        super.setName("SingleTaskThread");
        this.downloadSingleTaskDto = downloadSingleTaskDto;
        this.downloadUrl = downloadSingleTaskDto.getDownloadUrl();
    }

    @Override
    public void run() {
        this.isInit = false;
        this.initFileNameAndFileSize();
        this.isOver = true;
    }

    private void initFileNameAndFileSize() {
        String realUrl = "";
        if (StringUtils.isNotBlank((CharSequence)this.downloadUrl)) {
            realUrl = DownloadManangeUtils.getRealUrl(this.downloadUrl);
        }
        this.handlerInit(realUrl);
        if (StringUtils.isNotBlank((CharSequence)this.redirectUrl)) {
            this.downloadSingleTaskDto.setDownloadUrl(this.redirectUrl);
            this.handlerInit(this.redirectUrl);
        }
    }

    private void handlerInit(String realUrl) {
        try {
            Optional<HttpHeaderDto> httpHeaderDtoOptional = this.getHttpHeaderDto(realUrl);
            if (!httpHeaderDtoOptional.isPresent()) {
                return;
            }
            HttpHeaderDto httpHeaderDto = httpHeaderDtoOptional.get();
            this.fileName = httpHeaderDto.getFileName();
            if (StringUtils.isBlank((CharSequence)this.fileName)) {
                this.fileName = DownloadSingleUtils.getFileNameFromUrl(realUrl);
            }
            this.fileSize = httpHeaderDto.getSize();
            this.isInit = true;
            CodeCCUtils.INSTANCE.infoLog(log, "Download task has been initialized, filename is {0}, download url is {1}", new Object[]{this.fileName, this.downloadUrl});
        }
        catch (NetWorkSwitchException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Network closed.", (Throwable)e);
            this.errorCode = DownloadCode.ERROR_NETWORK_CLOSED.getDownloadCode();
            this.errorMsg = I18nResources.INSTANCE.getValueByKey("download.error.network.closed");
        }
        catch (IllegalArgumentException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Download url is illegal.", (Throwable)e);
            this.errorCode = DownloadCode.ERROR_CONNECT_FAILED.getDownloadCode();
            this.errorMsg = I18nResources.INSTANCE.getValueByKey("download.error.connect.failed");
        }
        catch (DownloadException e) {
            String[] errors = DownloadManangeUtils.errorHandler(e.getMessage());
            this.errorCode = errors[0];
            this.errorMsg = errors[1];
            CodeCCUtils.INSTANCE.errorLog(log, "DownloadException.", (Throwable)e);
        }
        catch (IOException e) {
            if (this.hasRedirectUrl(this.downloadUrl)) {
                return;
            }
            CodeCCUtils.INSTANCE.errorLog(log, "Failed to connect to the server.", (Throwable)e);
            this.errorCode = DownloadCode.ERROR_CONNECT_FAILED.getDownloadCode();
            this.errorMsg = I18nResources.INSTANCE.getValueByKey("download.error.connect.failed");
        }
    }

    private boolean hasRedirectUrl(String downloadUrl) {
        if (!StringUtils.startsWith((CharSequence)downloadUrl, (CharSequence)UrlDataServiceHandler.getInstance().getDomainByScene("HOUP.DOWNLOAD.NGINX"))) {
            return false;
        }
        String[] split = downloadUrl.split("\\?");
        this.redirectUrl = UrlDataServiceHandler.getInstance().getDomainByScene("DOWNLOAD.NGINX") + "/dl/download.do?actionFlag=download&" + split[1];
        return true;
    }

    private Optional<HttpHeaderDto> getHttpHeaderDto(String realUrl) throws DownloadException, IOException {
        String errCode;
        Optional<HttpHeaderDto> httpHeaderDto = Optional.ofNullable(DownloadEnum.getHttpHeadDtoByUrl(realUrl));
        if (!httpHeaderDto.isPresent()) {
            CodeCCUtils.INSTANCE.errorLog(log, "Task init, but http header is null.");
            this.errorCode = DownloadCode.ERROR_CONNECT_FAILED.getDownloadCode();
            this.errorMsg = I18nResources.INSTANCE.getValueByKey("download.error.connect.failed");
            return Optional.empty();
        }
        Headers headers = httpHeaderDto.get().getHeaders();
        if (headers != null) {
            this.sha256 = headers.get("SHA256");
            CodeCCUtils.INSTANCE.infoLog(log, "The will be download file sha256 is {0}.", new Object[]{this.sha256});
        }
        if (StringUtils.isNotBlank((CharSequence)(errCode = httpHeaderDto.get().getErrCode()))) {
            String[] errors = DownloadManangeUtils.errorHandler(errCode);
            this.errorCode = errors[0];
            this.errorMsg = errors[1];
            return Optional.empty();
        }
        if (httpHeaderDto.get().getSize() == 0L) {
            CodeCCUtils.INSTANCE.errorLog(log, "Init completed. but can't get return data.");
            this.errorCode = DownloadCode.ERROR_CONNECT_FAILED.getDownloadCode();
            this.errorMsg = I18nResources.INSTANCE.getValueByKey("download.error.connect.failed");
            return Optional.empty();
        }
        return httpHeaderDto;
    }

    public DownloadSingleTaskDto getDownloadSingleTaskDto() {
        return this.downloadSingleTaskDto;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public boolean isOver() {
        return this.isOver;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getSha256() {
        return this.sha256;
    }
}

