/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.download.attr.DownloadCode;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class VerifyFileDownloadThread
implements Callable<String> {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(VerifyFileDownloadThread.class);
    private static final int RETRY_DOWNLOAD_VERIFY = 3;
    private final String filePath;
    private String downloadUrl;
    private int failedCount = 0;

    public VerifyFileDownloadThread(String downloadUrl, String filePath) {
        this.downloadUrl = downloadUrl;
        this.filePath = filePath;
    }

    @Override
    public String call() throws Exception {
        while (this.failedCount < 3) {
            if (this.download()) {
                return "success";
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.errorLog(log, "Download verify file retry, interrupted.", (Throwable)e);
            }
            if (DownloadManangeUtils.deleteFile(FileUtils.getFile((String[])new String[]{this.filePath}))) {
                CodeCCUtils.INSTANCE.errorLog(log, "Delete verify file has error, please manual delete, {0}", new Object[]{this.filePath});
                break;
            }
            ++this.failedCount;
        }
        return DownloadCode.ERROR.getDownloadCode();
    }

    /*
     * Exception decompiling
     */
    private boolean download() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getDownloadUrlByPath(boolean isOldHoupUrl) {
        if (StringUtils.endsWith((CharSequence)this.filePath, (CharSequence)".asc")) {
            if (isOldHoupUrl) {
                return this.downloadUrl + ".asc";
            }
            String partNoByUrl = DownloadSingleUtils.getPartNoByUrl(this.downloadUrl);
            return this.getTargetDownloadUrl(this.downloadUrl, this.getPgpSignFilePartNo(partNoByUrl));
        }
        if (isOldHoupUrl) {
            return this.downloadUrl + ".p7s";
        }
        return this.getTargetDownloadUrl(this.downloadUrl, "partNo=x002");
    }

    private String getPgpSignFilePartNo(String partNoByUrl) {
        if (StringUtils.isBlank((CharSequence)partNoByUrl)) {
            return "";
        }
        if (StringUtils.equalsAny((CharSequence)partNoByUrl, (CharSequence[])new CharSequence[]{"3001", "h001"})) {
            return "partNo=x001";
        }
        return "partNo=" + partNoByUrl.charAt(0) + "x" + partNoByUrl.substring(1);
    }

    public String getTargetDownloadUrl(String downloadUrl, String partNo) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = DownloadSingleUtils.PART_NO_PATTERN.matcher(downloadUrl);
        if (matcher.find()) {
            matcher.appendReplacement(stringBuffer, partNo);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

