/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.verify.service.lmpl.CMSVerifyServiceImpl;
import com.huawei.support.icscbb.verify.service.lmpl.PGPVerifyServiceImpl;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.handler.DownloadCacheHandler;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.convert.TaskConverter;
import com.huawei.support.icslite.business.softwaremanage.dto.SoftwareManageDirDto;
import com.huawei.support.icslite.business.softwaremanage.enums.VerifyStatusEnum;
import com.huawei.support.icslite.business.softwaremanage.service.impl.SoftwareManageDirBusinessHandler;
import com.huawei.support.icslite.business.softwaremanage.service.impl.SoftwareManageFileBusinessHandler;
import com.huawei.support.icslite.download.service.impl.DownloadServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class VerifyThread
extends Thread {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(VerifyThread.class);
    private static final String PGP_TYPE = "pgp";
    private static final String CMS_TYPE = "cms";
    private DownloadSingleTaskDto downloadSingleTaskDto;
    private String ascFilePath;
    private String p7sFilePath;

    public VerifyThread(DownloadSingleTaskDto downloadSingleTaskDto, String ascFilePath, String p7sFilePath) {
        super.setName("VerifySignThread");
        this.downloadSingleTaskDto = downloadSingleTaskDto;
        this.ascFilePath = ascFilePath;
        this.p7sFilePath = p7sFilePath;
    }

    @Override
    public void run() {
        if (StringUtils.equals((CharSequence)this.downloadSingleTaskDto.getCurrentStatus(), (CharSequence)"3")) {
            return;
        }
        String filePath = this.downloadSingleTaskDto.getDownloadDir() + "/" + this.downloadSingleTaskDto.getFileName();
        boolean ascVerifyResult = PGPVerifyServiceImpl.getInstance().verify(this.ascFilePath, filePath);
        boolean p7sVerifyResult = CMSVerifyServiceImpl.getInstance().verify(this.p7sFilePath, filePath);
        if (ascVerifyResult && (StringUtils.isBlank((CharSequence)this.p7sFilePath) || p7sVerifyResult)) {
            this.downloadSingleTaskDto.setLoadingStatus("4");
            this.downloadSingleTaskDto.setCategory("2");
            this.downloadSingleTaskDto.setOperateTime(System.currentTimeMillis());
            DownloadCacheHandler.remove(this.downloadSingleTaskDto.getTaskId());
            DownloadSingleUtils.executeAddSoftManage(() -> this.addToSoftManager(this.downloadSingleTaskDto));
        } else {
            CodeCCUtils.INSTANCE.errorLog(log, "Verify file result has error, asc result is {0}, p7s result is {1}", new Object[]{ascVerifyResult, p7sVerifyResult});
            this.downloadSingleTaskDto.setLoadingStatus("-5");
            this.downloadSingleTaskDto.setErrorMsg(this.getErrorMsg(ascVerifyResult, p7sVerifyResult, StringUtils.isBlank((CharSequence)this.p7sFilePath)));
        }
        this.downloadSingleTaskDto.setCurrentStatus("3");
        DownloadServiceHandler.getInstance().updateTask(TaskConverter.INSTANCE.dtoToDo(this.downloadSingleTaskDto));
    }

    private void addToSoftManager(DownloadSingleTaskDto downloadSingleTaskDto) {
        String downloadDir = downloadSingleTaskDto.getDownloadDir();
        String originalDownloadDir = downloadSingleTaskDto.getOriginalDownloadDir();
        String offeringDir = (String)StringUtils.defaultIfBlank((CharSequence)originalDownloadDir, (CharSequence)downloadDir);
        SoftwareManageDirDto softwareManageDirDto = SoftwareManageDirBusinessHandler.getInstance().addDir(downloadDir, offeringDir);
        CodeCCUtils.INSTANCE.infoLog(log, "Download file verified, fileName is {0}", new Object[]{downloadSingleTaskDto.getFileName()});
        SoftwareManageFileBusinessHandler.getInstance().addFiles(softwareManageDirDto.getId(), downloadDir, downloadSingleTaskDto.getFileName(), VerifyStatusEnum.VERIFIED.getStatus());
    }

    private String getErrorMsg(boolean ascVerifyResult, boolean p7sVerifyResult, boolean isPgp) {
        if (isPgp) {
            return String.format(Locale.ROOT, I18nResources.INSTANCE.getValueByKey("download.file.verify.status.failed"), PGP_TYPE);
        }
        return this.getMsgByResult(ascVerifyResult, PGP_TYPE) + ", " + this.getMsgByResult(p7sVerifyResult, CMS_TYPE);
    }

    private String getMsgByResult(boolean verifyResult, String type) {
        return String.format(Locale.ROOT, I18nResources.INSTANCE.getValueByKey(verifyResult ? "download.file.verify.status.success" : "download.file.verify.status.failed"), type);
    }
}

