/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.download.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icscbb.util.thread.ThreadPoolFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadSingleUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadSingleUtils.class);
    public static final Pattern PART_NO_PATTERN = Pattern.compile("partNo=([^&]*)");
    public static final Pattern MID_PATTERN = Pattern.compile("mid=([^&]*)");
    private static final List<String> PART_NO_LIST = Collections.unmodifiableList(Arrays.asList("3001", "4001", "6001", "8001", "h001"));
    private static final ThreadPoolExecutor DOWNLOAD_POOL = ThreadPoolFactory.getThreadPool((String)"downloadSingleTaskExecutor", (int)30, (int)50, (int)50, (int)20);
    private static final ThreadPoolExecutor VERIFY_FILE_DOWNLOAD_POOL = ThreadPoolFactory.getThreadPool((String)"downloadVerifyTaskExecutor", (int)15, (int)50, (int)30, (int)150);
    private static final Pattern DOMAIN_CHECK_PATTERN = Pattern.compile("\\?");
    private static final Pattern DIR_PATTERN = Pattern.compile("^[A-z]:\\\\([^|><?*\":\\/]*)?$");

    private DownloadSingleUtils() {
    }

    public static String getRealFileName(String fileName, String path) {
        File downloadDir = FileUtils.getFile((String[])new String[]{path});
        if (!downloadDir.exists()) {
            return fileName;
        }
        String realPath = path + File.separator + fileName;
        String realFileName = fileName;
        int count = 1;
        while (FileUtils.getFile((String[])new String[]{realPath}).exists()) {
            String filePrefix;
            String fileSuffix = "";
            int separator = fileName.lastIndexOf(".");
            if (separator == -1) {
                filePrefix = fileName;
            } else {
                filePrefix = fileName.substring(0, separator);
                fileSuffix = fileName.substring(separator);
            }
            realFileName = filePrefix + "(" + count + ")" + fileSuffix;
            realPath = path + File.separator + realFileName;
            ++count;
        }
        return realFileName;
    }

    public static String getDomainString(String downloadUrl) {
        if (StringUtils.isBlank((CharSequence)downloadUrl)) {
            return "";
        }
        String[] domainSplits = DOMAIN_CHECK_PATTERN.split(downloadUrl);
        String domainUrl = domainSplits[0];
        if (StringUtils.isBlank((CharSequence)domainUrl) || !StringUtils.startsWithAny((CharSequence)domainUrl, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            CodeCCUtils.INSTANCE.errorLog(log, "Download url is blank or illegal, url is {0}", new Object[]{downloadUrl});
            return "";
        }
        try {
            URL url = new URL(domainUrl);
            String domain = url.getHost();
            if (StringUtils.isBlank((CharSequence)domain)) {
                CodeCCUtils.INSTANCE.errorLog(log, "Download get domain is blank");
                return "";
            }
            return domain;
        }
        catch (MalformedURLException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "Url not match protocol, please check url {0}", (Throwable)e, new Object[]{domainUrl});
            return "";
        }
    }

    public static boolean isMatchTypeDownloadUrl(String downloadUrl, String domain) {
        String domainString = "https://" + DownloadSingleUtils.getDomainString(downloadUrl);
        return StringUtils.equalsIgnoreCase((CharSequence)domainString, (CharSequence)domain);
    }

    public static void executeThread(Thread thread) {
        DOWNLOAD_POOL.execute(thread);
    }

    public static Future<String> executeDownloadVerifyThread(Callable<String> thread) {
        return VERIFY_FILE_DOWNLOAD_POOL.submit(thread);
    }

    public static void executeVerifyThread(Thread thread) {
        VERIFY_FILE_DOWNLOAD_POOL.execute(thread);
    }

    public static void executeAddSoftManage(Runnable runnable) {
        VERIFY_FILE_DOWNLOAD_POOL.execute(runnable);
    }

    public static String getFileNameFromUrl(String realUrl) {
        if (StringUtils.isBlank((CharSequence)realUrl)) {
            return "";
        }
        String downloadNameByUrl = NetWorkUtil.getDownloadNameByUrl((String)realUrl);
        if (StringUtils.length((CharSequence)downloadNameByUrl) > 110) {
            CodeCCUtils.INSTANCE.warnLog(log, "Url length so long, please check file name : {0}", new Object[]{downloadNameByUrl});
            return downloadNameByUrl.substring(0, 110);
        }
        return downloadNameByUrl;
    }

    public static boolean isUnVerifyDownload(String downloadUrl) {
        String partNoByUrl = DownloadSingleUtils.getPartNoByUrl(downloadUrl);
        if (StringUtils.isBlank((CharSequence)partNoByUrl)) {
            return true;
        }
        return !PART_NO_LIST.contains(partNoByUrl);
    }

    public static String getPartNoByUrl(String downloadUrl) {
        Matcher matcher = PART_NO_PATTERN.matcher(downloadUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String getSourceType(String downloadUrl) {
        Matcher matcher = MID_PATTERN.matcher(downloadUrl);
        if (!matcher.find()) {
            return "normal";
        }
        String midStr = matcher.group(1);
        String partNoByUrl = DownloadSingleUtils.getPartNoByUrl(downloadUrl);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)midStr, (CharSequence[])new CharSequence[]{"sup_sw", "supe_sw"}) && StringUtils.equals((CharSequence)partNoByUrl, (CharSequence)"3001")) {
            return "sw";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)midStr, (CharSequence[])new CharSequence[]{"sup_doc", "supe_doc"})) {
            if (StringUtils.equals((CharSequence)partNoByUrl, (CharSequence)"h001")) {
                return "unknown";
            }
            if (StringUtils.equalsAny((CharSequence)partNoByUrl, (CharSequence[])new CharSequence[]{"4001", "6001", "8001"})) {
                return "doc";
            }
        }
        return "normal";
    }

    public static String getRealPath(String dirPath) {
        if (StringUtils.isBlank((CharSequence)dirPath)) {
            return "";
        }
        Matcher matcher = DIR_PATTERN.matcher(dirPath);
        if (!matcher.find()) {
            return dirPath.replaceAll("[\\\\/:\\*?\"<>|]", "");
        }
        return dirPath;
    }
}

