/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.convert;

import com.huawei.support.icscbb.util.date.DateUtils;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadExcelDto;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper
public interface ExcelConverter {
    public static final ExcelConverter INSTANCE = (ExcelConverter)Mappers.getMapper(ExcelConverter.class);

    @Mappings(value={@Mapping(source="createTime", target="createTime", qualifiedByName={"formatDateTime"}), @Mapping(source="currentStatus", target="currentStatus", qualifiedByName={"changeStatusToI18n"})})
    public DownloadExcelDto dtoToExcelDto(DownloadSingleTaskDto var1);

    public List<DownloadExcelDto> toExcelDtoList(List<DownloadSingleTaskDto> var1);

    @Named(value="formatDateTime")
    default public String formatDateTime(long createTime) {
        return DateUtils.parseLongToString((long)createTime);
    }

    @Named(value="changeStatusToI18n")
    default public String changeStatusToI18n(String currentStatus) {
        return DownloadManangeUtils.getStatusI18n(currentStatus);
    }

    @AfterMapping
    default public void taskDtoToExcelDto(@MappingTarget DownloadExcelDto downloadExcelDto, DownloadSingleTaskDto downloadSingleTaskDto) {
        if (StringUtils.isNotBlank((CharSequence)downloadSingleTaskDto.getErrorCode()) && !StringUtils.equals((CharSequence)downloadSingleTaskDto.getErrorCode(), (CharSequence)DownloadCode.SUCCESS.getDownloadCode())) {
            downloadExcelDto.setCurrentStatus(I18nResources.INSTANCE.getValueByKey("download.detail.tips.error"));
        }
    }
}

