/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.convert;

import com.huawei.support.icslite.business.common.serviceimpl.UrlDataServiceHandler;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadResponseDto;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.common.resources.utils.LiteCommonUtils;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.download.dto.TaskDo;
import com.huawei.wsf.core.HWEncoder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

@Mapper
public interface TaskConverter {
    public static final TaskConverter INSTANCE = (TaskConverter)Mappers.getMapper(TaskConverter.class);

    public TaskDo dtoToDo(DownloadSingleTaskDto var1);

    public DownloadSingleTaskDto doToDto(TaskDo var1);

    public List<DownloadSingleTaskDto> toDtoList(List<TaskDo> var1);

    public List<TaskDo> toDoList(List<DownloadSingleTaskDto> var1);

    public DownloadResponseDto singleTaskDtoToResponseTaskDto(DownloadSingleTaskDto var1);

    public List<DownloadResponseDto> taskDtosToResponseTaskDtos(List<DownloadSingleTaskDto> var1);

    @AfterMapping
    default public void handlerToResponseDto(@MappingTarget DownloadResponseDto downloadResponseDto) {
        String downloadUrl = downloadResponseDto.getDownloadUrl();
        if (StringUtils.isBlank((CharSequence)downloadUrl)) {
            return;
        }
        this.handlerTypeAndUrl(downloadResponseDto, downloadUrl);
        this.handlerSpeedTime(downloadResponseDto);
    }

    default public void handlerSpeedTime(DownloadResponseDto downloadResponseDto) {
        String speedRateStr = downloadResponseDto.getSpeedRate();
        if (StringUtils.equals((CharSequence)speedRateStr, (CharSequence)"0.00B")) {
            return;
        }
        long secondSpeed = Long.parseLong(speedRateStr);
        downloadResponseDto.setSpeedRate(LiteCommonUtils.fileUnitExchange((long)secondSpeed));
        if (!StringUtils.equals((CharSequence)downloadResponseDto.getCurrentStatus(), (CharSequence)"1") || secondSpeed == 0L) {
            return;
        }
        long remainSize = downloadResponseDto.getFileSize() - downloadResponseDto.getDownloadSize();
        BigDecimal remainSizeDecimal = BigDecimal.valueOf(remainSize);
        BigDecimal secondSpeedDecimal = BigDecimal.valueOf(secondSpeed);
        long secondNums = remainSizeDecimal.divide(secondSpeedDecimal, RoundingMode.UP).longValue();
        downloadResponseDto.setRemainTime(DownloadManangeUtils.timeUnitExchange(secondNums));
    }

    default public void handlerTypeAndUrl(DownloadResponseDto downloadResponseDto, String downloadUrl) {
        String houpDownloadDomain = UrlDataServiceHandler.getInstance().getDomainByScene("HOUP.DOWNLOAD.NGINX");
        String houpDomain = UrlDataServiceHandler.getInstance().getDomainByScene("HOUP.NGINX");
        if (StringUtils.startsWithAny((CharSequence)downloadResponseDto.getDownloadUrl(), (CharSequence[])new CharSequence[]{houpDomain, houpDownloadDomain})) {
            downloadResponseDto.setDownloadType("houp");
        }
        downloadResponseDto.setDownloadUrl(HWEncoder.encodeForHTMLAttribute((String)downloadUrl));
        String supportDomain = UrlDataServiceHandler.getInstance().getDomainByScene("SUPPORT.NGINX");
        downloadResponseDto.setSignUrl(String.join((CharSequence)"/", supportDomain, "enterprise", ConfigServiceHandler.getInstance().get("system.lang"), "software-policy"));
        downloadResponseDto.setPermissionUrl(supportDomain + UrlDataServiceHandler.getInstance().getUrlFromKey(StringUtils.equals((CharSequence)ConfigServiceHandler.getInstance().get("system.ics.scene"), (CharSequence)"supporte") ? "icslite.enterprise.permission.url" : "icslite.carrier.permission.url"));
    }
}

