/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.dataquery;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.downloadmanage.convert.ExcelConverter;
import com.huawei.support.icslite.business.downloadmanage.convert.TaskConverter;
import com.huawei.support.icslite.business.downloadmanage.dataquery.DownloadQuery;
import com.huawei.support.icslite.business.downloadmanage.dataquery.impl.CompletedQueryImpl;
import com.huawei.support.icslite.business.downloadmanage.dataquery.impl.DownloadingQueryImpl;
import com.huawei.support.icslite.business.downloadmanage.dataquery.impl.TrashBoxQueryImpl;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadExcelDto;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadQueryDto;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadResponseDto;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadQueryFacade {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadQueryFacade.class);
    private final Map<String, DownloadQuery> DOWNLOAD_LIST_QUERY_MAP = new HashMap<String, DownloadQuery>();

    private DownloadQueryFacade() {
        this.DOWNLOAD_LIST_QUERY_MAP.put("1", new DownloadingQueryImpl());
        this.DOWNLOAD_LIST_QUERY_MAP.put("2", new CompletedQueryImpl());
        this.DOWNLOAD_LIST_QUERY_MAP.put("3", new TrashBoxQueryImpl());
    }

    public static DownloadQueryFacade getInstance() {
        return DownloadQueryFacadeHolder.INSTANCE;
    }

    public int getListCount(DownloadQueryDto downloadQueryDto) {
        if (this.DOWNLOAD_LIST_QUERY_MAP.containsKey(downloadQueryDto.getCategory())) {
            return this.DOWNLOAD_LIST_QUERY_MAP.get(downloadQueryDto.getCategory()).getListCount(downloadQueryDto);
        }
        CodeCCUtils.INSTANCE.errorLog(log, "Error category in download!");
        return 0;
    }

    public List<DownloadResponseDto> getPageList(DownloadQueryDto downloadQueryDto) {
        if (this.DOWNLOAD_LIST_QUERY_MAP.containsKey(downloadQueryDto.getCategory())) {
            List<DownloadSingleTaskDto> pageList = this.DOWNLOAD_LIST_QUERY_MAP.get(downloadQueryDto.getCategory()).getPageList(downloadQueryDto);
            if (CollectionUtils.isEmpty(pageList)) {
                return Collections.emptyList();
            }
            return TaskConverter.INSTANCE.taskDtosToResponseTaskDtos(pageList);
        }
        CodeCCUtils.INSTANCE.errorLog(log, "Error category in download!");
        return Collections.emptyList();
    }

    public List<DownloadExcelDto> getExportList(DownloadQueryDto downloadQueryDto) {
        if (StringUtils.equals((CharSequence)downloadQueryDto.getCategory(), (CharSequence)"3")) {
            return Collections.emptyList();
        }
        if (this.DOWNLOAD_LIST_QUERY_MAP.containsKey(downloadQueryDto.getCategory())) {
            return ExcelConverter.INSTANCE.toExcelDtoList(this.DOWNLOAD_LIST_QUERY_MAP.get(downloadQueryDto.getCategory()).getAllList(downloadQueryDto));
        }
        CodeCCUtils.INSTANCE.errorLog(log, "Error category in download!");
        return Collections.emptyList();
    }

    private static class DownloadQueryFacadeHolder {
        private static final DownloadQueryFacade INSTANCE = new DownloadQueryFacade();

        private DownloadQueryFacadeHolder() {
        }
    }
}

