/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.authorization.serviceimpl.UniportalAuthorizationBusinessHandler;
import com.huawei.support.icslite.business.download.constant.DownloadConstants;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.service.impl.DownloadFileServiceHandler;
import com.huawei.support.icslite.business.download.service.impl.DownloadInfoServiceHandler;
import com.huawei.support.icslite.business.download.service.impl.DownloadSingleServiceHandler;
import com.huawei.support.icslite.business.download.util.DownloadSingleUtils;
import com.huawei.support.icslite.business.downloadmanage.convert.TaskConverter;
import com.huawei.support.icslite.business.downloadmanage.dataquery.DownloadQueryFacade;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadExcelDto;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadPageDto;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadQueryDto;
import com.huawei.support.icslite.business.downloadmanage.dto.DownloadResponseDto;
import com.huawei.support.icslite.business.downloadmanage.service.DownloadManageService;
import com.huawei.support.icslite.business.downloadmanage.thread.CpuMonitorThread;
import com.huawei.support.icslite.business.downloadmanage.thread.DownloadTaskManageThread;
import com.huawei.support.icslite.business.downloadmanage.util.CpuMonitorUtils;
import com.huawei.support.icslite.business.preferences.serviceimpl.DownloadSettingServiceHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadManageServiceHandler
implements DownloadManageService,
DownloadConstants {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadManageServiceHandler.class);
    private static final List<Integer> CPU_LIST = new CopyOnWriteArrayList<Integer>();
    private static final AtomicBoolean IS_POP_OUT_TIPS = new AtomicBoolean(false);
    private static boolean isLogin = false;

    public static DownloadManageServiceHandler getInstance() {
        return DownloadManageServiceHandlerHolder.INSTANCE;
    }

    private static void setLogin(boolean isAuthorized) {
        isLogin = isAuthorized;
    }

    @Override
    public void init() {
        this.initDownloadTask();
        DownloadTaskManageThread.getInstance().start();
        CpuMonitorThread.getInstance().start();
    }

    private void initDownloadTask() {
        List<DownloadSingleTaskDto> allTaskList = DownloadInfoServiceHandler.getInstance().getAllList();
        if (CollectionUtils.isEmpty(allTaskList)) {
            return;
        }
        for (DownloadSingleTaskDto downloadSingleTaskDto : allTaskList) {
            this.handlerDownloadSingleTaskDto(downloadSingleTaskDto);
        }
    }

    private void handlerDownloadSingleTaskDto(DownloadSingleTaskDto downloadSingleTaskDto) {
        if (StringUtils.equals((CharSequence)downloadSingleTaskDto.getCategory(), (CharSequence)"2")) {
            if (StringUtils.equalsAny((CharSequence)downloadSingleTaskDto.getLoadingStatus(), (CharSequence[])new CharSequence[]{"1", "0"})) {
                DownloadFileServiceHandler.getInstance().loadFile(downloadSingleTaskDto);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)downloadSingleTaskDto.getCategory(), (CharSequence)"3")) {
            return;
        }
        if (StringUtils.equals((CharSequence)downloadSingleTaskDto.getCategory(), (CharSequence)"1")) {
            String loadingStatus = downloadSingleTaskDto.getLoadingStatus();
            if (StringUtils.equals((CharSequence)loadingStatus, (CharSequence)"0")) {
                DownloadFileServiceHandler.getInstance().unZipAndLoadFile(downloadSingleTaskDto);
            }
            if (StringUtils.equals((CharSequence)loadingStatus, (CharSequence)"1")) {
                DownloadFileServiceHandler.getInstance().loadFile(downloadSingleTaskDto);
            }
            if (StringUtils.equals((CharSequence)loadingStatus, (CharSequence)"3")) {
                DownloadFileServiceHandler.getInstance().verifyFile(downloadSingleTaskDto, StringUtils.equals((CharSequence)"sw", (CharSequence)DownloadSingleUtils.getSourceType(downloadSingleTaskDto.getDownloadUrl())));
            }
        }
        if (StringUtils.equals((CharSequence)downloadSingleTaskDto.getCurrentStatus(), (CharSequence)"1")) {
            downloadSingleTaskDto.setCurrentStatus("2");
            DownloadSingleServiceHandler.getInstance().updateTask(downloadSingleTaskDto);
        }
        DownloadSingleServiceHandler.getInstance().addDownloadingTask(downloadSingleTaskDto);
    }

    @Override
    public void createTb() {
        DownloadSingleServiceHandler.getInstance().createTb();
    }

    @Override
    public DownloadPageDto getDownloadListByCategory(DownloadQueryDto downloadQueryDto) {
        this.isLiveAndLoading();
        int listCount = DownloadQueryFacade.getInstance().getListCount(downloadQueryDto);
        int pageSize = downloadQueryDto.getPageSize();
        if (listCount == 0) {
            return new DownloadPageDto();
        }
        int pageCount = this.getPageCount(pageSize, listCount);
        int realPageNo = this.getRealPageNo(downloadQueryDto.getPageNo(), pageCount);
        downloadQueryDto.setPageNo(realPageNo);
        return DownloadPageDto.builder().realPageNo(realPageNo).pageCount(pageCount).totalCount(listCount).list(DownloadQueryFacade.getInstance().getPageList(downloadQueryDto)).build();
    }

    private void isLiveAndLoading() {
        if (!DownloadTaskManageThread.getInstance().isUse()) {
            return;
        }
        List<DownloadSingleTaskDto> loadingDtoList = DownloadInfoServiceHandler.getInstance().getLoadingDtoList();
        if (loadingDtoList.isEmpty()) {
            return;
        }
        for (DownloadSingleTaskDto taskDto : loadingDtoList) {
            if (!StringUtils.equals((CharSequence)taskDto.getLoadingStatus(), (CharSequence)"1")) continue;
            DownloadFileServiceHandler.getInstance().loadFile(taskDto);
        }
    }

    private int getRealPageNo(int pageNo, int pageCount) {
        return Math.min(pageNo, pageCount);
    }

    private int getPageCount(int pageSize, int totalCount) {
        BigDecimal result = new BigDecimal(totalCount).subtract(new BigDecimal(1)).divide(new BigDecimal(pageSize), RoundingMode.DOWN).add(new BigDecimal(1));
        return result.intValue();
    }

    @Override
    public boolean isUse() {
        return DownloadTaskManageThread.getInstance().isUse();
    }

    @Override
    public boolean isAuthorized() {
        return (Boolean)UniportalAuthorizationBusinessHandler.getInstance().getAuthorizedInfo().get("status");
    }

    @Override
    public void updateLoginState(boolean isAuthorized) {
        if (!isLogin && isAuthorized) {
            DownloadSingleServiceHandler.getInstance().updateNoLoginInData();
        }
        DownloadManageServiceHandler.setLogin(isAuthorized);
    }

    @Override
    public boolean isPopDownloadRateModal() {
        boolean isExtraRate;
        if (IS_POP_OUT_TIPS.get()) {
            return false;
        }
        CPU_LIST.add(CpuMonitorUtils.getInstance().getCpu());
        if (CPU_LIST.size() < 3) {
            return false;
        }
        if (!this.allMatchMaxCpu()) {
            return false;
        }
        boolean bl = isExtraRate = Long.compare(DownloadInfoServiceHandler.getInstance().getSecondBytes(), DownloadSettingServiceHandler.getInstance().getConfigRate()) == 1;
        if (isExtraRate) {
            IS_POP_OUT_TIPS.compareAndSet(false, true);
            CodeCCUtils.INSTANCE.infoLog(log, "Need pop download rate modal");
        }
        return IS_POP_OUT_TIPS.get();
    }

    @Override
    public List<DownloadExcelDto> getExportList(String category, String startTime, String endTime) {
        DownloadQueryDto downloadQueryDto = new DownloadQueryDto();
        downloadQueryDto.setCategory(category).setStartTime(startTime).setEndTime(endTime);
        return DownloadQueryFacade.getInstance().getExportList(downloadQueryDto);
    }

    private boolean allMatchMaxCpu() {
        boolean isMatch = CPU_LIST.stream().allMatch(cpuSize -> cpuSize > 70);
        CPU_LIST.remove(0);
        return isMatch;
    }

    @Override
    public boolean openDir(String taskId, String openDir) {
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "OPENED", "Open the directory for downloading file successful.");
        return DownloadFileServiceHandler.getInstance().openDir(taskId, openDir);
    }

    @Override
    public DownloadResponseDto queryTask(String taskId) {
        return TaskConverter.INSTANCE.singleTaskDtoToResponseTaskDto(DownloadSingleServiceHandler.getInstance().queryTask(taskId));
    }

    @Override
    public Map<String, Set<String>> validatedRepeatedTask(List<String> taskDownloadUrlList) {
        return DownloadSingleServiceHandler.getInstance().validatedRepeatedTask(taskDownloadUrlList);
    }

    @Override
    public boolean validateDiskExists(String downloadDir) {
        return IcsCommonServiceHandler.getInstance().isExistDisk(downloadDir);
    }

    @Override
    public boolean checkTaskDto(DownloadSingleTaskDto taskDto) {
        return DownloadSingleServiceHandler.getInstance().checkTaskDto(taskDto);
    }

    private static class DownloadManageServiceHandlerHolder {
        private static final DownloadManageServiceHandler INSTANCE = new DownloadManageServiceHandler();

        private DownloadManageServiceHandlerHolder() {
        }
    }
}

