/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.service.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.http.NetWorkUtil;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.service.impl.DownloadInfoServiceHandler;
import com.huawei.support.icslite.business.download.service.impl.DownloadSingleServiceHandler;
import com.huawei.support.icslite.business.downloadmanage.service.DownloadOperationService;
import com.huawei.support.icslite.business.downloadmanage.thread.CpuMonitorThread;
import com.huawei.support.icslite.business.downloadmanage.thread.DownloadTaskManageThread;
import com.huawei.support.icslite.business.downloadmanage.util.DownloadManangeUtils;
import com.huawei.support.icslite.download.attr.DownloadCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadOperationServiceHandler
implements DownloadOperationService {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadOperationServiceHandler.class);

    public static DownloadOperationServiceHandler getInstance() {
        return DownloadOperationServiceHandlerHolder.INSTANCE;
    }

    @Override
    public void reStart() {
        DownloadTaskManageThread.getInstance().toStart();
        CpuMonitorThread.getInstance().toStart();
    }

    @Override
    public void continueDownloadTasks() {
        CodeCCUtils.INSTANCE.infoLog(log, "Login success, continueDownloadTasks!");
        List<DownloadSingleTaskDto> allTaskList = DownloadInfoServiceHandler.getInstance().getAllList();
        if (CollectionUtils.isEmpty(allTaskList)) {
            return;
        }
        List<String> downloadingTaskIds = allTaskList.stream().filter(downloadSingleTaskDto -> StringUtils.equalsAny((CharSequence)downloadSingleTaskDto.getCurrentStatus(), (CharSequence[])new CharSequence[]{"1", "0", "2"})).map(DownloadSingleTaskDto::getTaskId).collect(Collectors.toList());
        this.startTask(downloadingTaskIds);
    }

    @Override
    public String pauseTask(List<String> taskIds) {
        for (String taskId : taskIds) {
            DownloadSingleServiceHandler.getInstance().pauseTask(taskId);
        }
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "SELECT", "Pause the downloading tasks successful.");
        this.reStart();
        return DownloadCode.SUCCESS.getDownloadCode();
    }

    @Override
    public String startTask(List<String> taskIds) {
        for (String taskId : taskIds) {
            DownloadSingleServiceHandler.getInstance().startTask(taskId);
        }
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "STARTUP", "Start the download tasks successful.");
        this.reStart();
        return DownloadCode.SUCCESS.getDownloadCode();
    }

    @Override
    public String deleteTask(List<String> taskIds) {
        Collections.reverse(taskIds);
        for (String taskId : taskIds) {
            DownloadSingleServiceHandler.getInstance().deleteTask(taskId);
        }
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "DELETE", "Tasks deleted successfully.");
        this.reStart();
        return DownloadCode.SUCCESS.getDownloadCode();
    }

    @Override
    public String deleteTaskByTrashBox(List<String> taskIds) {
        for (String taskId : taskIds) {
            DownloadSingleServiceHandler.getInstance().deleteTaskByTrashBox(taskId);
        }
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "DELETE", "Trash box task deleted successfully.");
        return DownloadCode.SUCCESS.getDownloadCode();
    }

    @Override
    public String directDeleteTask(List<String> taskIds) {
        for (String taskId : taskIds) {
            DownloadSingleServiceHandler.getInstance().directDeleteTask(taskId);
        }
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "DELETE", "Downloading Tasks update download delete successfully.");
        this.reStart();
        return DownloadCode.SUCCESS.getDownloadCode();
    }

    @Override
    public String clearTrashTasks(boolean isDelFile) {
        List<DownloadSingleTaskDto> trashBoxList = DownloadInfoServiceHandler.getInstance().getTrashBoxList();
        String code = DownloadCode.SUCCESS.getDownloadCode();
        if (CollectionUtils.isEmpty(trashBoxList)) {
            return code;
        }
        if (isDelFile) {
            this.deleteAllDownloadFile(trashBoxList.stream().map(DownloadSingleTaskDto::getTaskId).collect(Collectors.toList()));
        }
        DownloadSingleServiceHandler.getInstance().deleteAllTrashTask();
        return code;
    }

    @Override
    public boolean restoreTask(List<String> taskIds) {
        ArrayList<DownloadSingleTaskDto> completeTask = new ArrayList<DownloadSingleTaskDto>();
        ArrayList<DownloadSingleTaskDto> downloadingTask = new ArrayList<DownloadSingleTaskDto>();
        for (String taskId : taskIds) {
            DownloadSingleTaskDto taskDto = DownloadSingleServiceHandler.getInstance().queryTask(taskId);
            if (taskDto == null) continue;
            if (StringUtils.equalsAny((CharSequence)taskDto.getLoadingStatus(), (CharSequence[])new CharSequence[]{"-1", "-5"})) {
                downloadingTask.add(taskDto);
                continue;
            }
            if (StringUtils.equals((CharSequence)taskDto.getCurrentStatus(), (CharSequence)"3")) {
                completeTask.add(taskDto);
                continue;
            }
            downloadingTask.add(taskDto);
        }
        if (CollectionUtils.isNotEmpty(completeTask)) {
            DownloadSingleServiceHandler.getInstance().restoreCompleteTask(completeTask);
        }
        boolean isSuccess = true;
        if (CollectionUtils.isNotEmpty(downloadingTask)) {
            isSuccess = DownloadSingleServiceHandler.getInstance().restoreDownloadTask(downloadingTask);
        }
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "CREATE", "Download task restored successfully.");
        this.reStart();
        return isSuccess;
    }

    @Override
    public boolean addTasks(List<DownloadSingleTaskDto> taskDtos) {
        if (CollectionUtils.isEmpty(taskDtos)) {
            CodeCCUtils.INSTANCE.warnLog(log, "The taskDtos info is null, can't add tasks.");
            return true;
        }
        if (!taskDtos.stream().allMatch(this::isSignFile)) {
            taskDtos.removeIf(this::isSignFile);
        }
        this.initTasks(taskDtos);
        boolean isSuccess = DownloadSingleServiceHandler.getInstance().addDownloadingTasks(taskDtos);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "CREATE", "The download tasks are added successfully.");
        this.reStart();
        return isSuccess;
    }

    private boolean isSignFile(DownloadSingleTaskDto downloadSingleTaskDto) {
        return StringUtils.containsAny((CharSequence)downloadSingleTaskDto.getDownloadUrl(), (CharSequence[])new CharSequence[]{"partNo=x001", "partNo=x002", ".asc", ".p7s"});
    }

    @Override
    public List<String> addTasksReturnTaskIds(List<DownloadSingleTaskDto> taskDtos) {
        if (CollectionUtils.isEmpty(taskDtos)) {
            CodeCCUtils.INSTANCE.warnLog(log, "The offline taskDtos info is null, can't add tasks.");
            return Collections.emptyList();
        }
        this.initTasks(taskDtos);
        List<String> idList = DownloadSingleServiceHandler.getInstance().addOffLineTasks(taskDtos);
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "CREATE", "The offline download tasks are added successfully.");
        this.reStart();
        return idList;
    }

    private void initTasks(List<DownloadSingleTaskDto> taskDtos) {
        for (DownloadSingleTaskDto taskDto : taskDtos) {
            if (taskDto == null) {
                CodeCCUtils.INSTANCE.errorLog(log, "The task info is null, can't add task.");
                continue;
            }
            this.taskInit(taskDto);
        }
    }

    private void taskInit(DownloadSingleTaskDto taskDto) {
        taskDto.setTaskId((String)StringUtils.defaultIfBlank((CharSequence)taskDto.getTaskId(), (CharSequence)UUID.randomUUID().toString()));
        taskDto.setCreateTime(System.currentTimeMillis());
        taskDto.setOperateTime(System.currentTimeMillis());
        taskDto.setFileName(this.defaultFileNameHandler(taskDto));
        if (!StringUtils.startsWithAny((CharSequence)taskDto.getDownloadUrl(), (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            taskDto.setDownloadUrl("https:" + taskDto.getDownloadUrl());
        }
    }

    @Override
    public boolean restartTask(List<DownloadSingleTaskDto> taskDtos) {
        boolean isSuccess = true;
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "STARTUP", "Task re-downloading succeeded.");
        for (DownloadSingleTaskDto taskDto : taskDtos) {
            isSuccess = DownloadSingleServiceHandler.getInstance().restartTask(taskDto.getTaskId());
            if (isSuccess) continue;
            break;
        }
        this.reStart();
        return isSuccess;
    }

    @Override
    public String deleteAllDownloadFile(List<String> taskIds) {
        for (String taskId : taskIds) {
            DownloadSingleServiceHandler.getInstance().deleteDownloadFile(taskId);
        }
        OperationLogUtils.INSTANCE.successOperationLog("icslite-download", "DELETE", "Succeeded in deleting the object file.");
        return DownloadCode.SUCCESS.getDownloadCode();
    }

    private String defaultFileNameHandler(DownloadSingleTaskDto taskDto) {
        String realUrl = DownloadManangeUtils.getRealUrl(taskDto.getDownloadUrl());
        String compareName = realUrl.substring("http://".length());
        String fileName = this.getFileName(taskDto, realUrl);
        if (StringUtils.indexOf((CharSequence)compareName, (CharSequence)"/") == -1 || StringUtils.isBlank((CharSequence)fileName)) {
            return "index.html";
        }
        if (StringUtils.length((CharSequence)fileName) > 110) {
            fileName = fileName.substring(0, 110);
        }
        return fileName;
    }

    private String getFileName(DownloadSingleTaskDto taskDto, String realUrl) {
        if (StringUtils.isNotBlank((CharSequence)taskDto.getFileName())) {
            return taskDto.getFileName();
        }
        if (StringUtils.isNotBlank((CharSequence)taskDto.getRelativePath())) {
            return StringUtils.substring((String)taskDto.getRelativePath(), (int)(taskDto.getRelativePath().indexOf("/") + 1));
        }
        String downloadNameByUrl = NetWorkUtil.getDownloadNameByUrl((String)realUrl);
        return StringUtils.equals((CharSequence)downloadNameByUrl, (CharSequence)"support") ? "houp" : downloadNameByUrl;
    }

    private static class DownloadOperationServiceHandlerHolder {
        private static final DownloadOperationServiceHandler INSTANCE = new DownloadOperationServiceHandler();

        private DownloadOperationServiceHandlerHolder() {
        }
    }
}

