/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.dto.DownloadSingleTaskDto;
import com.huawei.support.icslite.business.download.service.impl.DownloadInfoServiceHandler;
import com.huawei.support.icslite.business.download.thread.DownloadFileThread;
import com.huawei.support.icslite.business.downloadmanage.util.CpuMonitorUtils;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CpuMonitorThread
extends Thread {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(CpuMonitorThread.class);
    private volatile boolean isUse = true;
    private Lock cpuMonitorLock = new ReentrantLock();
    private Condition cpuMonitorCondition = this.cpuMonitorLock.newCondition();
    private Deque<Integer> cpuRecords = new LinkedList<Integer>();

    private CpuMonitorThread() {
        super.setName("CpuMonitorThread");
        this.setUncaughtExceptionHandler((thisThread, exception) -> CodeCCUtils.INSTANCE.errorLog(log, thisThread.getName(), exception));
    }

    public static CpuMonitorThread getInstance() {
        return CpuMonitorThreadHandler.INSTANCE;
    }

    public void toStart() {
        this.signal();
    }

    private void signal() {
        this.cpuMonitorLock.lock();
        this.isUse = true;
        try {
            this.cpuMonitorCondition.signal();
        }
        finally {
            this.cpuMonitorLock.unlock();
        }
    }

    @Override
    public void run() {
        CodeCCUtils.INSTANCE.infoLog(log, "Download cpu monitor Thread run start");
        while (Boolean.TRUE.booleanValue()) {
            if (this.isStop()) {
                this.cpuMonitorLock.lock();
                this.isUse = false;
                try {
                    this.cpuMonitorCondition.await();
                }
                catch (InterruptedException e) {
                    CodeCCUtils.INSTANCE.errorLog(log, "await: ", (Throwable)e);
                }
                finally {
                    this.cpuMonitorLock.unlock();
                }
            }
            try {
                if (this.cpuRecords.size() == 3) {
                    this.cpuRecords.poll();
                }
                this.cpuRecords.add(CpuMonitorUtils.getInstance().getCpu());
                this.monitorCpuAndOperate(this.countAverageCpu());
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(log, "Download monitor exception.", (Throwable)e);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.errorLog(log, "Download cpu monitor, interrupted.", (Throwable)e);
            }
        }
        CodeCCUtils.INSTANCE.infoLog(log, "Download cpu monitor Thread run end");
    }

    private boolean isStop() {
        return DownloadInfoServiceHandler.getInstance().getDownloadingCount() == 0 && DownloadInfoServiceHandler.getInstance().getWaitCount() == 0 && DownloadInfoServiceHandler.getInstance().getLoadingCount() == 0;
    }

    private void monitorCpuAndOperate(int averageCpu) {
        List<DownloadSingleTaskDto> downloadingList = DownloadInfoServiceHandler.getInstance().getDownloadingList();
        for (DownloadSingleTaskDto downloadSingleTaskDto : downloadingList) {
            DownloadFileThread[] threads = downloadSingleTaskDto.getThreads();
            Arrays.stream(threads).filter(Objects::nonNull).forEach(downloadFileThread -> {
                if (averageCpu > 70) {
                    downloadFileThread.splitterSleep();
                }
                if (averageCpu < 50) {
                    downloadFileThread.splitterAwake();
                }
            });
        }
    }

    private int countAverageCpu() {
        OptionalDouble average = this.cpuRecords.stream().mapToInt(Integer::intValue).average();
        return average.isPresent() ? (int)average.getAsDouble() : 0;
    }

    public boolean isUse() {
        return this.isUse;
    }

    private static class CpuMonitorThreadHandler {
        private static final CpuMonitorThread INSTANCE = new CpuMonitorThread();

        private CpuMonitorThreadHandler() {
        }
    }
}

