/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.thread;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.download.chain.FilterChain;
import com.huawei.support.icslite.business.download.service.impl.DownloadInfoServiceHandler;
import com.huawei.support.icslite.business.download.service.impl.DownloadRefreshServiceHandler;
import com.huawei.support.icslite.business.download.service.impl.DownloadSingleServiceHandler;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadTaskManageThread
extends Thread {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadTaskManageThread.class);
    private static final String FIRST_SYNC_DOWNLOAD_COUNT = "1";
    private static final String SECOND_SYNC_DOWNLOAD_COUNT = "2";
    private static final String THIRD_SYNC_DOWNLOAD_COUNT = "5";
    private static final String FOURTH_SYNC_DOWNLOAD_COUNT = "10";
    private static final FilterChain FILTER_CHAIN = new FilterChain();
    private volatile boolean isUse = true;
    private Lock downloadManageLock = new ReentrantLock();
    private Condition downloadManageCondition = this.downloadManageLock.newCondition();
    private volatile boolean isLoop = true;
    private int counter = 0;

    private DownloadTaskManageThread() {
        super.setName("DownloadTaskManage");
        this.setUncaughtExceptionHandler((thisThread, exception) -> CodeCCUtils.INSTANCE.errorLog(log, thisThread.getName(), exception));
    }

    public static DownloadTaskManageThread getInstance() {
        return DownloadTaskManageThreadHandler.INSTANCE;
    }

    public void toStart() {
        this.isLoop = true;
        this.signal();
    }

    private void signal() {
        this.downloadManageLock.lock();
        this.isUse = true;
        try {
            this.downloadManageCondition.signal();
        }
        finally {
            this.downloadManageLock.unlock();
        }
    }

    @Override
    public void run() {
        CodeCCUtils.INSTANCE.infoLog(log, "DownloadTaskManage Thread run start");
        while (this.isLoop) {
            if (this.isStop()) {
                this.downloadManageLock.lock();
                this.isUse = false;
                try {
                    this.downloadManageCondition.await();
                }
                catch (InterruptedException e) {
                    CodeCCUtils.INSTANCE.errorLog(log, "await: ", (Throwable)e);
                }
                finally {
                    this.downloadManageLock.unlock();
                }
            }
            try {
                this.refreshData();
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(log, "refresh data exception.", (Throwable)e);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException e) {
                CodeCCUtils.INSTANCE.errorLog(log, "Download Task schedule, interrupted.", (Throwable)e);
            }
        }
        CodeCCUtils.INSTANCE.infoLog(log, "DownloadTaskManage Thread run end");
    }

    private boolean isStop() {
        return BooleanUtils.and((boolean[])new boolean[]{DownloadInfoServiceHandler.getInstance().getDownloadingCount() == 0, DownloadInfoServiceHandler.getInstance().getWaitCount() == 0, DownloadInfoServiceHandler.getInstance().getLoadingCount() == 0, DownloadInfoServiceHandler.getInstance().getVerifyingCount() == 0, DownloadInfoServiceHandler.getInstance().getDeletingCount() == 0, DownloadInfoServiceHandler.getInstance().getSignVerifyingCount() == 0});
    }

    public boolean isUse() {
        return this.isUse;
    }

    private void refreshData() {
        DownloadRefreshServiceHandler.getInstance().refreshDownloadingData();
        DownloadRefreshServiceHandler.getInstance().refreshWaitData(this.getMaxSyncDownloadCount());
        DownloadInfoServiceHandler.getInstance().getDownloadingList().forEach(FILTER_CHAIN::refreshProcess);
        this.refreshPointData();
        DownloadRefreshServiceHandler.getInstance().refreshStartDownload();
    }

    private void refreshPointData() {
        if (this.counter == 1000) {
            this.counter = 0;
            DownloadSingleServiceHandler.getInstance().writeAllPoint();
        }
        ++this.counter;
    }

    private int getMaxSyncDownloadCount() {
        String threadNum = ConfigServiceHandler.getInstance().getOrSetDefault("download.max.concurrency.number", THIRD_SYNC_DOWNLOAD_COUNT);
        int maxSyncDownloadCount = Integer.parseInt(threadNum);
        if (!StringUtils.equalsAny((CharSequence)threadNum, (CharSequence[])new CharSequence[]{FIRST_SYNC_DOWNLOAD_COUNT, SECOND_SYNC_DOWNLOAD_COUNT, THIRD_SYNC_DOWNLOAD_COUNT, FOURTH_SYNC_DOWNLOAD_COUNT})) {
            maxSyncDownloadCount = Integer.parseInt(THIRD_SYNC_DOWNLOAD_COUNT);
            CodeCCUtils.INSTANCE.errorLog(log, "The maximum number of downloads is abnormal. The application uses the default value.");
        }
        return maxSyncDownloadCount;
    }

    private static class DownloadTaskManageThreadHandler {
        private static final DownloadTaskManageThread INSTANCE = new DownloadTaskManageThread();

        private DownloadTaskManageThreadHandler() {
        }
    }
}

