/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.downloadmanage.util;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.zipfile.ZipFileUtils;
import com.huawei.support.icslite.business.authorization.dto.CertificateStatus;
import com.huawei.support.icslite.business.authorization.serviceimpl.UniportalAuthorizationBusinessHandler;
import com.huawei.support.icslite.download.attr.DownloadCode;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadManangeUtils {
    private static final CommonLogger log = CommonLoggerFactory.getLogger(DownloadManangeUtils.class);
    private static final int EOF = -1;
    private static final Map<String, String[]> ERROR_CODE_MAP = new HashMap<String, String[]>();
    private static final Map<String, String> STATUS_I18N_MAP = new HashMap<String, String>();
    private static final String SWITCH_STATUS = I18nResources.INSTANCE.getValueByKey("download.lib.status.switch");
    private static final String TIME_UNIT_FORMAT = "%02d:%02d:%02d";
    private static final List<String> HOUP_ERROR_CODE = new ArrayList<String>();

    private DownloadManangeUtils() {
    }

    private static void initStatusI18nMap() {
        STATUS_I18N_MAP.put("0", I18nResources.INSTANCE.getValueByKey("download.detail.tips.pause"));
        STATUS_I18N_MAP.put("1", I18nResources.INSTANCE.getValueByKey("download.detail.tips.downloading"));
        STATUS_I18N_MAP.put("2", I18nResources.INSTANCE.getValueByKey("download.detail.tips.waiting"));
        STATUS_I18N_MAP.put("3", I18nResources.INSTANCE.getValueByKey("download.detail.tips.completed"));
        STATUS_I18N_MAP.put("6", I18nResources.INSTANCE.getValueByKey("download.lib.status.waiting"));
        STATUS_I18N_MAP.put("7", I18nResources.INSTANCE.getValueByKey("download.file.status.validate"));
    }

    private static void initHoupErrorCode() {
        HOUP_ERROR_CODE.add("107");
        HOUP_ERROR_CODE.add("400");
        HOUP_ERROR_CODE.add("401");
        HOUP_ERROR_CODE.add("403");
        HOUP_ERROR_CODE.add("404");
        HOUP_ERROR_CODE.add("416");
        HOUP_ERROR_CODE.add(CertificateStatus.INIT_CERTIFICATE.getCode());
        HOUP_ERROR_CODE.add(CertificateStatus.ISSUING_CERTIFICATE.getCode());
        HOUP_ERROR_CODE.add(CertificateStatus.ISSUE_CERTIFICATE_ERROR.getCode());
        HOUP_ERROR_CODE.add("20003");
        HOUP_ERROR_CODE.add("20004");
        HOUP_ERROR_CODE.add("20005");
    }

    private static void putHoupErrorCode() {
        ERROR_CODE_MAP.put("107", DownloadManangeUtils.getErrors(DownloadCode.HOUP_ERROR_NO_PERMISSION.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.no.login")));
        ERROR_CODE_MAP.put("400", DownloadManangeUtils.getErrors(DownloadCode.HOUP_ERROR.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error")));
        ERROR_CODE_MAP.put("401", DownloadManangeUtils.getErrors(DownloadCode.ERROR_NO_PERMISSION.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.no.permission")));
        ERROR_CODE_MAP.put("403", DownloadManangeUtils.getErrors(DownloadCode.ERROR_NO_PERMISSION.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.no.permission")));
        ERROR_CODE_MAP.put("404", DownloadManangeUtils.getErrors(DownloadCode.HOUP_ERROR_FILE_NOT_EXISTS.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.file.not.exists")));
        ERROR_CODE_MAP.put("416", DownloadManangeUtils.getErrors(DownloadCode.HOUP_ERROR_DATA_FAILED.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.data.failed")));
        ERROR_CODE_MAP.put("500", DownloadManangeUtils.getErrors(DownloadCode.HOUP_ERROR_DATA_FAILED.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.data.failed")));
        ERROR_CODE_MAP.put(CertificateStatus.INIT_CERTIFICATE.getCode(), DownloadManangeUtils.getErrors(DownloadCode.HOUP_ERROR_NO_PERMISSION.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.no.login")));
        ERROR_CODE_MAP.put(CertificateStatus.ISSUING_CERTIFICATE.getCode(), DownloadManangeUtils.getErrors(DownloadCode.ISSUING_CERTIFICATE.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.issuing.certificate.error")));
        ERROR_CODE_MAP.put(CertificateStatus.ISSUE_CERTIFICATE_ERROR.getCode(), DownloadManangeUtils.getErrors(DownloadCode.CERTIFICATE_ERROR.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.get.certificate.error")));
        ERROR_CODE_MAP.put("20003", DownloadManangeUtils.getErrors(DownloadCode.ERROR_DELETE_VERIFY_FILE.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.delete.verify.file.error")));
        ERROR_CODE_MAP.put("20004", DownloadManangeUtils.getErrors(DownloadCode.DOWNLOAD_VERIFY_FILE_FAILED.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.verify.file.error")));
        ERROR_CODE_MAP.put("20005", DownloadManangeUtils.getErrors(DownloadCode.ERROR_FILE_VERIFY_FAILED.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.file.verify.error")));
    }

    private static void putSupportErrorCode() {
        ERROR_CODE_MAP.put("10002", DownloadManangeUtils.getErrors(DownloadCode.ERROR_NO_PERMISSION.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.no.permission")));
        ERROR_CODE_MAP.put("10005", DownloadManangeUtils.getErrors(DownloadCode.ERROR_FILE_NOT_EXISTS.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.file.not.exists")));
        ERROR_CODE_MAP.put("10003", DownloadManangeUtils.getErrors(DownloadCode.ERROR_FILE_NOT_EXISTS.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.file.not.exists")));
        ERROR_CODE_MAP.put("10009", DownloadManangeUtils.getErrors(DownloadCode.ERROR_DOWNLOAD_LIMIT_EXCEEDED.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.limit.exceeded")));
        ERROR_CODE_MAP.put("10010", DownloadManangeUtils.getErrors(DownloadCode.NOT_SINGED_LICENSE.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.not.singed.license")));
        ERROR_CODE_MAP.put("10011", DownloadManangeUtils.getErrors(DownloadCode.NOT_PASSED_APPLICATION.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.not.passed.application")));
    }

    public static String getRealUrl(String downloadUrl) {
        String realUrl = downloadUrl.trim();
        if (!StringUtils.startsWithIgnoreCase((CharSequence)realUrl, (CharSequence)"http://") && !StringUtils.startsWithIgnoreCase((CharSequence)realUrl, (CharSequence)"https://")) {
            realUrl = "http://" + realUrl;
        }
        return realUrl;
    }

    public static boolean deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            CodeCCUtils.INSTANCE.errorLog(log, "file delete error");
            return false;
        }
        return true;
    }

    public static long getFreeDisk(String downloadDir) {
        long freeSpaceSize = 0L;
        if (StringUtils.isNotBlank((CharSequence)downloadDir)) {
            File file = FileUtils.getFile((String[])new String[]{downloadDir});
            freeSpaceSize = file.getFreeSpace();
        }
        return freeSpaceSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readZipFile(String path) {
        File file = FileUtils.getFile((String[])new String[]{path});
        if (!file.exists()) {
            return "";
        }
        try (ZipFile zipFile = ZipFileUtils.createZipFile((File)file);){
            if (zipFile == null) {
                CodeCCUtils.INSTANCE.infoLog(log, "The zip file create error.");
                String string = "-1";
                return string;
            }
            String unZipFileName = DownloadManangeUtils.getUnZipFileName(zipFile);
            return unZipFileName;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(log, "The zip file read error.", (Throwable)e);
            return "-1";
        }
    }

    private static String getUnZipFileName(ZipFile zipFile) {
        int fileNumber = 0;
        Enumeration entries = zipFile.getEntries();
        String unZipFileName = "";
        while (entries.hasMoreElements()) {
            ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
            if (zipEntry.isDirectory()) {
                CodeCCUtils.INSTANCE.infoLog(log, "The zip file contains directory.");
                return "";
            }
            unZipFileName = zipEntry.getName();
            if (++fileNumber <= 1) continue;
            CodeCCUtils.INSTANCE.infoLog(log, "The zip file contains more than two files.");
            return "";
        }
        return unZipFileName;
    }

    public static String getSuffixFileName(String fileName) {
        int suffixIndex = fileName.lastIndexOf(".");
        if (suffixIndex == -1) {
            return "";
        }
        return fileName.substring(suffixIndex);
    }

    public static String[] errorHandler(String errCode) {
        CodeCCUtils.INSTANCE.errorLog(log, "support download return exception: {0}", new Object[]{errCode});
        String[] errors = new String[2];
        if (StringUtils.isBlank((CharSequence)errCode)) {
            return errors;
        }
        if ((StringUtils.equals((CharSequence)errCode, (CharSequence)"10002") || HOUP_ERROR_CODE.contains(errCode) || !ERROR_CODE_MAP.containsKey(errCode)) && !UniportalAuthorizationBusinessHandler.getInstance().isLogin()) {
            return DownloadManangeUtils.getErrors(DownloadCode.ERROR_NO_LOGIN_IN.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.no.login"));
        }
        if (ERROR_CODE_MAP.containsKey(errCode)) {
            return ERROR_CODE_MAP.get(errCode);
        }
        return DownloadManangeUtils.getErrors(DownloadCode.ERROR_NO_PERMISSION.getDownloadCode(), I18nResources.INSTANCE.getValueByKey("download.error.no.permission"));
    }

    private static String[] getErrors(String errorCode, String errorMsg) {
        String[] errors = new String[]{errorCode, errorMsg};
        return errors;
    }

    public static String getSha256Hex(String filePath) {
        String fileSha256 = "";
        try (FileInputStream fis = FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{filePath}));
             BufferedInputStream bis = new BufferedInputStream(fis);){
            fileSha256 = DigestUtils.sha256Hex((InputStream)bis);
        }
        catch (IOException ex) {
            CodeCCUtils.INSTANCE.errorLog(log, "getSha256Hex error. ", (Throwable)ex);
        }
        return fileSha256;
    }

    public static String getStatusI18n(String currentStatus) {
        if (STATUS_I18N_MAP.containsKey(currentStatus)) {
            return STATUS_I18N_MAP.get(currentStatus);
        }
        CodeCCUtils.INSTANCE.errorLog(log, "The status is being switched.");
        return SWITCH_STATUS;
    }

    public static String timeUnitExchange(long secondNums) {
        if (secondNums < 0L) {
            return "--:--:--";
        }
        long hours = TimeUnit.SECONDS.toHours(secondNums);
        if (hours > 24L) {
            return I18nResources.INSTANCE.getValueByKey("download.spend.time.exceed");
        }
        long minutes = TimeUnit.SECONDS.toMinutes(secondNums) % 60L;
        long secs = TimeUnit.SECONDS.toSeconds(secondNums) % 60L;
        return String.format(TIME_UNIT_FORMAT, hours, minutes, secs);
    }

    static {
        DownloadManangeUtils.putSupportErrorCode();
        DownloadManangeUtils.putHoupErrorCode();
        DownloadManangeUtils.initHoupErrorCode();
        DownloadManangeUtils.initStatusI18nMap();
    }
}

