/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.hdx.navi.handle;

import com.huawei.support.icscbb.hdx.common.navi.dto.HdxNaviStatusDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviBaseDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviExpandDo;
import com.huawei.support.icscbb.hdx.common.navi.service.impl.NaviContentServiceHandler;
import com.huawei.support.icscbb.hdx.common.navi.service.impl.NaviStatusServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.hdx.navi.handle.HdxNaviPathHandle;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class HdxNaviHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxNaviHandler.class);

    private HdxNaviHandler() {
    }

    public static HdxNaviHandler getInstance() {
        return HdxNaviHandlerHolder.INSTANCE;
    }

    public void initNaviProcess(String newXmlPath, NaviBaseDo baseDo, NaviBaseDo profile, List<NaviExpandDo> exdHdxList, HdxLibType libType) {
        String docId = Optional.ofNullable(profile).orElse(new NaviBaseDo()).getDocId();
        if (StringUtils.isBlank((CharSequence)docId)) {
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "InitNaviProcess start. docId:" + docId);
        HdxNaviStatusDo statu = NaviStatusServiceHandler.getInstance().getByDocId(docId);
        if (statu == null) {
            statu = new HdxNaviStatusDo();
            statu.setDocId(docId);
        }
        statu.setStatus("102");
        NaviStatusServiceHandler.getInstance().updateStatus(statu);
        String currentXmlPath = HdxNaviPathHandle.getInstance().getCurrentXmlPath(docId);
        int code = 10100001;
        switch (libType) {
            case BASE: {
                code = NaviContentServiceHandler.getInstance().init(newXmlPath, profile, exdHdxList);
                HdxNaviPathHandle.getInstance().deleteOldFile(docId, currentXmlPath, newXmlPath);
                break;
            }
            case EXPAND: {
                code = NaviContentServiceHandler.getInstance().initExpand(HdxNaviPathHandle.getInstance().getNewXmlPath(docId), profile);
                break;
            }
            case MEND: {
                code = NaviContentServiceHandler.getInstance().initPatch(newXmlPath, baseDo, profile, exdHdxList);
                HdxNaviPathHandle.getInstance().deleteOldFile(docId, currentXmlPath, newXmlPath);
                break;
            }
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "{0} navi init end. code: {1}", new Object[]{docId, code});
        if (code == 10100001) {
            statu.setStatus("103");
        } else {
            statu.setStatus("100");
        }
        NaviStatusServiceHandler.getInstance().updateStatus(statu);
    }

    public static enum HdxLibType {
        BASE,
        EXPAND,
        MEND;

    }

    private static class HdxNaviHandlerHolder {
        private static final HdxNaviHandler INSTANCE = new HdxNaviHandler();

        private HdxNaviHandlerHolder() {
        }
    }
}

