/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.hdx.navi.handle;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.hdx.common.navi.constant.NaviHdxConstants;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxNaviPathHandle {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HdxNaviPathHandle.class);

    private HdxNaviPathHandle() {
    }

    public static HdxNaviPathHandle getInstance() {
        return HdxNaviPathHandleHolder.INSTANCE;
    }

    public String getNaviPath(String docId, FilePathHandle handle) {
        String newNavXmlPath = String.format(Locale.ENGLISH, NaviHdxConstants.NEW_NAVIXML_PATH, IcsLiteStorageAdapter.INSTANCE.getNavPath(), docId);
        String dirPath = String.format(Locale.ENGLISH, NaviHdxConstants.NAVI_PATH_PRE, IcsLiteStorageAdapter.INSTANCE.getNavPath(), docId);
        File dir = FileUtils.getFile((String[])new String[]{dirPath});
        if (!dir.exists() || dir.isFile()) {
            return newNavXmlPath;
        }
        Object[] list = this.getFileList(dir);
        if (ArrayUtils.isNotEmpty((Object[])list)) {
            Object name = list[list.length - 1];
            newNavXmlPath = handle.getPath(dirPath, (String)name);
        }
        return newNavXmlPath;
    }

    private String[] getFileList(File dir) {
        return dir.list((file, name) -> {
            String fileName = name.toLowerCase(Locale.ENGLISH);
            return fileName.indexOf(46) > 0 && fileName.startsWith("newnavi");
        });
    }

    public String getNewXmlPath(String docId) {
        return this.getNaviPath(docId, (dirPath, name) -> {
            int endIndex = name.lastIndexOf(".");
            int pathNum = 1;
            if ("newnavi".length() <= endIndex) {
                String num = name.substring("newnavi".length(), endIndex);
                pathNum = StringUtils.isBlank((CharSequence)num) ? 1 : Integer.parseInt(num) + 1;
            }
            String newName = "newnavi" + pathNum + ".xml";
            return dirPath + newName;
        });
    }

    public String getCurrentXmlPath(String docId) {
        return this.getNaviPath(docId, (dirPath, name) -> dirPath + name);
    }

    public void deleteOldFile(String docId, String oldPath, String newPath) {
        if (StringUtils.equals((CharSequence)oldPath, (CharSequence)newPath)) {
            return;
        }
        File naviFile = FileUtils.getFile((String[])new String[]{oldPath});
        if (FileUtils.deleteQuietly((File)naviFile)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "delete oldnavifile success. docId:" + docId);
        } else {
            CodeCCUtils.INSTANCE.infoLog(LOG, "delete oldnavifile failed. docId:" + docId);
        }
    }

    private static class HdxNaviPathHandleHolder {
        private static final HdxNaviPathHandle INSTANCE = new HdxNaviPathHandle();

        private HdxNaviPathHandleHolder() {
        }
    }

    public static interface FilePathHandle {
        public String getPath(String var1, String var2);
    }
}

