/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.hdx.navi.service.impl;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.hdx.common.navi.constant.NaviHdxConstants;
import com.huawei.support.icscbb.hdx.common.navi.dto.HdxNaviStatusDo;
import com.huawei.support.icscbb.hdx.common.navi.dto.NaviExpandDo;
import com.huawei.support.icscbb.hdx.common.navi.service.impl.NaviContentServiceHandler;
import com.huawei.support.icscbb.hdx.common.navi.service.impl.NaviStatusServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.business.hdx.navi.dto.mapper.HdxNaviExpandConverter;
import com.huawei.support.icslite.business.hdx.navi.handle.HdxNaviPathHandle;
import com.huawei.support.icslite.business.hdx.navi.service.HdxNaviBusiness;
import com.huawei.support.icslite.business.hdx.navi.thread.HdxInitQueueConsumer;
import com.huawei.support.icslite.business.hdx.navi.thread.HdxInitQueueProducer;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HdxNaviBusinessHandler
implements HdxNaviBusiness {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxNaviBusinessHandler.class);
    private static final String NEWNAVI_SUFFIX_RULER = "[0-9]*";
    private static Map<String, Integer> naviMap = new ConcurrentHashMap<String, Integer>();

    private HdxNaviBusinessHandler() {
    }

    public static HdxNaviBusinessHandler getInstance() {
        return HdxNaviBusinessHandlerHolder.INSTANCE;
    }

    @Override
    public void createTb() {
        NaviStatusServiceHandler.getInstance().createTb();
    }

    @Override
    public void startQueue() {
        HdxInitQueueConsumer.getInstance().start();
        HdxInitQueueProducer.getInstance().start();
    }

    private void addQueue() {
        if (!HdxInitQueueProducer.getInstance().isRun()) {
            HdxInitQueueProducer.getInstance().taskStart();
        }
        HdxInitQueueProducer.getInstance().toReLoop();
    }

    @Override
    public void init(HdxContentDo hdxContentDo, List<HdxContentDo> exdHdxList) {
        List<NaviExpandDo> expands = HdxNaviExpandConverter.INSTANCE.dto2do(exdHdxList);
        this.addStatus(hdxContentDo, expands);
        this.addQueue();
    }

    @Override
    public void initExpand(HdxContentDo hdxContentDo) {
        this.addStatus(hdxContentDo, new ArrayList<NaviExpandDo>());
        this.addQueue();
    }

    @Override
    public void initMend(HdxContentDo base, HdxContentDo mend, List<HdxContentDo> expandList) {
        List<NaviExpandDo> expands = HdxNaviExpandConverter.INSTANCE.dto2do(expandList);
        this.addStatus(mend, expands);
        this.addQueue();
    }

    @Override
    public int remove(String docId) {
        NaviStatusServiceHandler.getInstance().delete(docId);
        naviMap.remove(docId);
        String currentXmlPath = HdxNaviPathHandle.getInstance().getCurrentXmlPath(docId);
        int statu = NaviContentServiceHandler.getInstance().remove(currentXmlPath);
        if (10100000 == statu) {
            IcsFileUtils.delFileOrDir((File)FileUtils.getFile((String[])new String[]{currentXmlPath}), (String)IcsLiteStorageAdapter.INSTANCE.getNavPath());
        }
        return statu;
    }

    @Override
    public int reinitializeNavigation(String docId) {
        naviMap.put(docId, naviMap.getOrDefault(docId, 0) + 1);
        Integer times = naviMap.get(docId);
        String docStatus = this.getDocStatus(docId);
        if (StringUtils.equals((CharSequence)docStatus, (CharSequence)"1")) {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "{0} navi is creating.", new Object[]{docId});
            return times;
        }
        NaviStatusServiceHandler.getInstance().delete(docId);
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (hdxContentDo == null) {
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "Not found {0}.", new Object[]{docId});
            return times;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "reenter navi start, docid:{0}", new Object[]{docId});
        String libType = hdxContentDo.getLibType();
        if (StringUtils.equals((CharSequence)libType, (CharSequence)"0") || StringUtils.equals((CharSequence)libType, (CharSequence)"2")) {
            List extendList = Optional.ofNullable(HdxContentPoolServiceHandler.getInstance().getExtendList(hdxContentDo)).orElseGet(() -> new ArrayList());
            this.init(hdxContentDo, extendList);
        }
        if (StringUtils.equals((CharSequence)libType, (CharSequence)"1")) {
            HdxContentDo baseDo = HdxContentPoolServiceHandler.getInstance().getBaseByMend(docId);
            if (baseDo == null) {
                return times;
            }
            List extendList = Optional.ofNullable(HdxContentPoolServiceHandler.getInstance().getExtendList(baseDo)).orElseGet(() -> new ArrayList());
            this.initMend(baseDo, hdxContentDo, extendList);
        }
        return times;
    }

    @Override
    public String get(String docId) {
        String status = this.getDocStatus(docId);
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)status)) {
            return status;
        }
        return NaviContentServiceHandler.getInstance().get(HdxNaviPathHandle.getInstance().getCurrentXmlPath(docId));
    }

    @Override
    public String getByTopicId(String docId, String topicId) {
        String status = this.getDocStatus(docId);
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)status)) {
            return status;
        }
        return NaviContentServiceHandler.getInstance().getByTopicId(topicId, HdxNaviPathHandle.getInstance().getCurrentXmlPath(docId));
    }

    @Override
    public String getByTopicUrl(String docId, String topicUrl) {
        String status = this.getDocStatus(docId);
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)status)) {
            return status;
        }
        return NaviContentServiceHandler.getInstance().getByTopicUrl(topicUrl, HdxNaviPathHandle.getInstance().getCurrentXmlPath(docId));
    }

    @Override
    public String getSublist(String docId, String position) {
        String status = this.getDocStatus(docId);
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)status)) {
            return status;
        }
        return NaviContentServiceHandler.getInstance().getSublist(position, HdxNaviPathHandle.getInstance().getCurrentXmlPath(docId));
    }

    @Override
    public String getInitNavis(String docId, String topicId) {
        String initNavis = "";
        if (StringUtils.isNotBlank((CharSequence)topicId)) {
            initNavis = this.getByTopicId(docId, topicId);
        }
        if (StringUtils.isBlank((CharSequence)initNavis)) {
            initNavis = this.get(docId);
        }
        return initNavis;
    }

    @Override
    public String getNaviByTopicUrl(String docId, String topicUrl) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, topicUrl})) {
            return "";
        }
        return this.getByTopicUrl(docId, topicUrl);
    }

    @Override
    public void verifyNaviFile() {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "app start. verifyNaviFile.");
        File hdxFile = FileUtils.getFile((String[])new String[]{IcsLiteStorageAdapter.INSTANCE.getNavPath()});
        if (!IcsFileUtils.isDirectory((File)hdxFile)) {
            return;
        }
        Object[] docFiles = hdxFile.listFiles();
        if (ArrayUtils.isEmpty((Object[])docFiles)) {
            return;
        }
        for (Object docFile : docFiles) {
            Object[] newNavis;
            String docId = ((File)docFile).getName();
            HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docId);
            if (hdxContentDo == null) {
                File deleteFile = this.getDeleteFile((File)docFile);
                if (!IcsFileUtils.delFileOrDir((File)deleteFile, (String)IcsCommonServiceHandler.getInstance().getAppRootDir())) continue;
                CodeCCUtils.INSTANCE.infoLog(LOGGER, "delete nav directory success. directoryname:" + ((File)docFile).getName());
                continue;
            }
            File navFile = FileUtils.getFile((String[])new String[]{String.format(Locale.ENGLISH, NaviHdxConstants.NAVI_PATH_PRE, IcsLiteStorageAdapter.INSTANCE.getNavPath(), docId)});
            if (!IcsFileUtils.isDirectory((File)navFile) || ArrayUtils.isEmpty((Object[])(newNavis = navFile.listFiles()))) continue;
            if (newNavis.length == 1) {
                this.deleteNoNormFile((File)newNavis[0]);
                continue;
            }
            this.deleteOldNaviFile((File[])newNavis);
        }
    }

    private File getDeleteFile(File docFile) {
        Object deleteFile = null;
        if (docFile == null || !docFile.isDirectory()) {
            return deleteFile;
        }
        Object[] files = docFile.listFiles();
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)((File)file).getName(), (CharSequence)"nav")) continue;
                deleteFile = file;
                break;
            }
        }
        return deleteFile;
    }

    @Override
    public void continueInitNavi() {
        Set allDocId = HdxContentPoolServiceHandler.getInstance().getAllDocId();
        allDocId.forEach(docid -> {
            HdxNaviStatusDo docDo = NaviStatusServiceHandler.getInstance().getByDocId(docid);
            if (docDo == null) {
                HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(docid);
                List extendList = HdxContentPoolServiceHandler.getInstance().getExtendList(hdxContentDo);
                this.addStatus(hdxContentDo, HdxNaviExpandConverter.INSTANCE.dto2do(extendList));
            }
        });
        this.addQueue();
    }

    private void deleteOldNaviFile(File[] naviFiles) {
        String fileName;
        int number;
        int maxNum = 0;
        for (File naviFile : naviFiles) {
            if (this.deleteNoNormFile(naviFile) || maxNum >= (number = Integer.parseInt("".equals(this.getNumStr(fileName = naviFile.getName())) ? "0" : this.getNumStr(fileName)))) continue;
            maxNum = number;
        }
        for (File naviFile : naviFiles) {
            if (!IcsFileUtils.isFile((File)FileUtils.getFile((String[])new String[]{IcsFileUtils.getCanonicalPath((File)naviFile)})) || (number = Integer.parseInt(StringUtils.isEmpty((CharSequence)this.getNumStr(fileName = naviFile.getName())) ? "0" : this.getNumStr(fileName))) == maxNum) continue;
            this.deleteFile(naviFile);
        }
    }

    private boolean deleteNoNormFile(File naviFile) {
        if (!IcsFileUtils.isFile((File)naviFile)) {
            this.deleteFile(naviFile);
            return true;
        }
        String fileName = naviFile.getName();
        if (!StringUtils.startsWith((CharSequence)fileName, (CharSequence)"newnavi") || !StringUtils.endsWith((CharSequence)fileName, (CharSequence)".xml")) {
            this.deleteFile(naviFile);
            return true;
        }
        String numStr = this.getNumStr(fileName);
        Pattern pattern = Pattern.compile(NEWNAVI_SUFFIX_RULER);
        Matcher matcher = pattern.matcher(numStr);
        if (!matcher.matches()) {
            this.deleteFile(naviFile);
            return true;
        }
        return false;
    }

    private String getNumStr(String fileName) {
        return fileName.substring("newnavi".length(), fileName.lastIndexOf("."));
    }

    private void deleteFile(File file) {
        if (IcsFileUtils.delFileOrDir((File)file, (String)IcsCommonServiceHandler.getInstance().getAppRootDir())) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "delete file success. filename:" + file.getName());
        }
    }

    private void addStatus(HdxContentDo contentDo, List<NaviExpandDo> exdHdxList) {
        if (contentDo == null) {
            return;
        }
        HdxNaviStatusDo hdxNaviStatusDo = new HdxNaviStatusDo();
        hdxNaviStatusDo.setDocId(contentDo.getDocId());
        hdxNaviStatusDo.setLibId(contentDo.getLibId());
        hdxNaviStatusDo.setLibV(contentDo.getLibV());
        hdxNaviStatusDo.setLang(contentDo.getLang());
        hdxNaviStatusDo.setLibType(contentDo.getLibType());
        hdxNaviStatusDo.setDocPath(contentDo.getPath());
        hdxNaviStatusDo.setStatus("101");
        List collect = exdHdxList.stream().map(dto -> dto.getDocId()).collect(Collectors.toList());
        hdxNaviStatusDo.setExpandList(JSON.toJSONString(collect));
        if (NaviStatusServiceHandler.getInstance().getByDocId(contentDo.getDocId()) != null) {
            NaviStatusServiceHandler.getInstance().updateStatus(hdxNaviStatusDo);
        } else {
            NaviStatusServiceHandler.getInstance().add(hdxNaviStatusDo);
        }
    }

    private String getDocStatus(String docId) {
        HdxNaviStatusDo doc = NaviStatusServiceHandler.getInstance().getByDocId(docId);
        String status = "3";
        if (doc != null) {
            switch (doc.getStatus()) {
                case "100": {
                    status = "0";
                    break;
                }
                case "101": 
                case "102": {
                    status = "1";
                    break;
                }
                case "103": {
                    status = "2";
                    break;
                }
            }
        }
        return status;
    }

    private static class HdxNaviBusinessHandlerHolder {
        private static final HdxNaviBusinessHandler INSTANCE = new HdxNaviBusinessHandler();

        private HdxNaviBusinessHandlerHolder() {
        }
    }
}

