/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.hdx.navi.thread;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.hdx.common.content.constant.HdxLibraryConstants;
import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.hdx.common.navi.dto.HdxNaviStatusDo;
import com.huawei.support.icscbb.hdx.common.navi.service.impl.NaviStatusServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icslite.business.common.dto.DocPriorityQueueTaskDto;
import com.huawei.support.icslite.business.doubleclicklib.entity.message.DoubleClickSceneMessage;
import com.huawei.support.icslite.business.hdx.navi.dto.mapper.HdxNaviBaseConvert;
import com.huawei.support.icslite.business.hdx.navi.dto.mapper.HdxNaviExpandConverter;
import com.huawei.support.icslite.business.hdx.navi.handle.HdxNaviHandler;
import com.huawei.support.icslite.business.hdx.navi.handle.HdxNaviPathHandle;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.lang3.StringUtils;

public class HdxInitQueueConsumer
extends Thread
implements HdxLibraryConstants {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxInitQueueConsumer.class);
    private static final PriorityBlockingQueue<DocPriorityQueueTaskDto> QUEUE = new PriorityBlockingQueue(1);
    private final AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();

    private HdxInitQueueConsumer() {
        super.setName("HdxInitQueueConsumer");
    }

    public static HdxInitQueueConsumer getInstance() {
        return HdxInitQueueConsumerHolder.INSTANCE;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    HdxNaviHandler.HdxLibType libType;
                    DocPriorityQueueTaskDto naviQueueTaskDto = QUEUE.take();
                    String docId = naviQueueTaskDto.getDocId();
                    HdxContentDo profile = this.getProfile(docId);
                    HdxContentDo baseDo = null;
                    List exdHdxList = HdxContentPoolServiceHandler.getInstance().getExtendList(profile);
                    switch (profile.getLibType()) {
                        case "0": {
                            libType = HdxNaviHandler.HdxLibType.BASE;
                            break;
                        }
                        case "2": {
                            libType = HdxNaviHandler.HdxLibType.EXPAND;
                            break;
                        }
                        case "1": {
                            libType = HdxNaviHandler.HdxLibType.MEND;
                            baseDo = HdxContentPoolServiceHandler.getInstance().getBaseByMend(docId);
                            exdHdxList = HdxContentPoolServiceHandler.getInstance().getExtendList(baseDo);
                            break;
                        }
                        default: {
                            libType = HdxNaviHandler.HdxLibType.BASE;
                        }
                    }
                    String newXmlPath = HdxNaviPathHandle.getInstance().getNewXmlPath(docId);
                    HdxNaviHandler.getInstance().initNaviProcess(newXmlPath, HdxNaviBaseConvert.INSTANCE.domain2dto(baseDo), HdxNaviBaseConvert.INSTANCE.domain2dto(profile), HdxNaviExpandConverter.INSTANCE.dto2do(exdHdxList), libType);
                    if (!IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().containsValue(docId)) continue;
                    this.eventBus.post((Object)new DoubleClickSceneMessage("0", profile.getPath()));
                }
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "HdxInitQueueConsumer Exception: ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private HdxContentDo getProfile(String docId) {
        HdxNaviStatusDo statusDo = NaviStatusServiceHandler.getInstance().getByDocId(docId);
        HdxContentDo profile = new HdxContentDo();
        profile.setDocId(statusDo.getDocId());
        profile.setLibId(statusDo.getLibId());
        profile.setLibV(statusDo.getLibV());
        profile.setLang(statusDo.getLang());
        profile.setLibType(statusDo.getLibType());
        profile.setPath(statusDo.getDocPath());
        return profile;
    }

    public void queueAdd(DocPriorityQueueTaskDto docPriorityQueueTaskDto) {
        if (this.exists(docPriorityQueueTaskDto)) {
            return;
        }
        QUEUE.put(docPriorityQueueTaskDto);
    }

    private boolean exists(DocPriorityQueueTaskDto docPriorityQueueTaskDto) {
        return QUEUE.stream().anyMatch(queueTask -> StringUtils.equals((CharSequence)queueTask.getDocId(), (CharSequence)docPriorityQueueTaskDto.getDocId()));
    }

    private static class HdxInitQueueConsumerHolder {
        private static final HdxInitQueueConsumer INSTANCE = new HdxInitQueueConsumer();

        private HdxInitQueueConsumerHolder() {
        }
    }
}

