/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.hdx.navi.thread;

import com.huawei.support.icscbb.hdx.common.navi.dto.HdxNaviStatusDo;
import com.huawei.support.icscbb.hdx.common.navi.service.impl.NaviStatusServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.common.dto.DocPriorityQueueTaskDto;
import com.huawei.support.icslite.business.hdx.navi.thread.HdxInitQueueConsumer;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HdxInitQueueProducer
extends Thread {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxInitQueueProducer.class);
    private static final int MAX_PRIORITY_NUM = 0;
    private final Lock hdxInitLock = new ReentrantLock();
    private final Condition hdxInitCondition = this.hdxInitLock.newCondition();
    private final AtomicBoolean reLoop;
    private final AtomicBoolean isRun;
    private int taskPriorityNum = 0;

    private HdxInitQueueProducer() {
        super.setName("HdxInitQueueProducer");
        this.reLoop = new AtomicBoolean(false);
        this.isRun = new AtomicBoolean(true);
    }

    public static HdxInitQueueProducer getInstance() {
        return HdxInitQueueProducerHolder.INSTANCE;
    }

    @Override
    public void run() {
        while (true) {
            this.reLoop.set(false);
            List hdxNaviStatusDos = NaviStatusServiceHandler.getInstance().getUnfinishedDoc();
            for (HdxNaviStatusDo hdxNaviStatusDo : hdxNaviStatusDos) {
                String docId = hdxNaviStatusDo.getDocId();
                DocPriorityQueueTaskDto naviQueueTask = this.isDoubleClickTask(docId) ? new DocPriorityQueueTaskDto(0, docId) : new DocPriorityQueueTaskDto(this.taskPriorityNum++, docId);
                HdxInitQueueConsumer.getInstance().queueAdd(naviQueueTask);
            }
            if (this.reLoop.get()) continue;
            this.taskAwait();
        }
    }

    private boolean isDoubleClickTask(String docId) {
        return IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().containsValue(docId);
    }

    public void taskStart() {
        this.hdxInitLock.lock();
        try {
            this.isRun.set(true);
            this.hdxInitCondition.signal();
        }
        finally {
            this.hdxInitLock.unlock();
        }
    }

    private void taskAwait() {
        this.hdxInitLock.lock();
        try {
            this.isRun.set(false);
            this.hdxInitCondition.await();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "hdx producer await: ", (Throwable)e);
        }
        finally {
            this.hdxInitLock.unlock();
        }
    }

    public boolean isRun() {
        boolean rst;
        this.hdxInitLock.lock();
        try {
            rst = this.isRun.get();
        }
        finally {
            this.hdxInitLock.unlock();
        }
        return rst;
    }

    public void toReLoop() {
        this.reLoop.set(true);
    }

    private static class HdxInitQueueProducerHolder {
        private static final HdxInitQueueProducer INSTANCE = new HdxInitQueueProducer();

        private HdxInitQueueProducerHolder() {
        }
    }
}

