/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.hdx.topic.service.impl;

import com.huawei.support.icscbb.hdx.common.content.dto.HdxContentDo;
import com.huawei.support.icscbb.hdx.common.content.service.impl.HdxContentPoolServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icslite.business.docexport.util.FontUtils;
import com.huawei.support.icslite.business.hdx.topic.service.HdxTopicBusiness;
import com.huawei.support.icslite.business.officepreview.dto.PreviewDto;
import com.huawei.support.icslite.business.officepreview.handler.PreviewHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class HdxTopicBusinessHandler
implements HdxTopicBusiness {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxTopicBusinessHandler.class);
    private static final String HDX_RESOURCE_PATH = IcsCommonServiceHandler.getInstance().getDefaultResPath() + File.separator + "hdx";
    private String hdxPreviewDownload = I18nResources.INSTANCE.getValueByKey("browse.hdx.topic.download.url.three.param");

    private HdxTopicBusinessHandler() {
    }

    public static HdxTopicBusinessHandler getInstance() {
        return HdxTopicBusinessHandleerHoder.INSTANCE;
    }

    @Override
    public HdxContentDo getHdx(String docId) {
        return Optional.ofNullable(HdxContentPoolServiceHandler.getInstance().get(docId)).orElse(new HdxContentDo());
    }

    @Override
    public InputStream getTopicSourceView(String docId, String topicDocId, String filePath) throws IOException {
        if (this.checkTopicDocId(docId, topicDocId)) {
            return null;
        }
        HdxContentDo profile = Optional.ofNullable(HdxContentPoolServiceHandler.getInstance().get(topicDocId)).orElse(new HdxContentDo());
        PreviewDto previewDto = new PreviewDto().setLibPath(profile.getPath()).setFilePath(filePath);
        String officeDownloadUrl = String.format(Locale.ENGLISH, this.hdxPreviewDownload, topicDocId, topicDocId, filePath);
        HdxContentDo hdxContentDo = HdxContentPoolServiceHandler.getInstance().get(topicDocId);
        previewDto.setFontsDir(FontUtils.getFontsPath(hdxContentDo == null ? "en" : hdxContentDo.getLang()));
        return PreviewHandler.getInstance().getTopicSourceView(previewDto, topicDocId, HDX_RESOURCE_PATH, officeDownloadUrl);
    }

    @Override
    public InputStream getTopicSourceStream(String docId, String topicDocId, String filePath) throws IOException {
        if (this.checkTopicDocId(docId, topicDocId)) {
            return null;
        }
        HdxContentDo profile = Optional.ofNullable(HdxContentPoolServiceHandler.getInstance().get(topicDocId)).orElse(new HdxContentDo());
        return ZipFilePool.getInputStream((String)profile.getPath(), (String)filePath);
    }

    private boolean checkTopicDocId(String docId, String topicDocId) {
        List extendList;
        if (StringUtils.equals((CharSequence)docId, (CharSequence)topicDocId)) {
            return false;
        }
        HdxContentDo baseDoc = HdxContentPoolServiceHandler.getInstance().get(docId);
        if (baseDoc == null) {
            return true;
        }
        if ("1".equals(baseDoc.getLibType())) {
            baseDoc = HdxContentPoolServiceHandler.getInstance().getBaseByMend(baseDoc);
        }
        if (baseDoc == null) {
            return true;
        }
        return !StringUtils.equals((CharSequence)topicDocId, (CharSequence)baseDoc.getDocId()) && !(extendList = HdxContentPoolServiceHandler.getInstance().getExtendList(baseDoc)).contains(HdxContentPoolServiceHandler.getInstance().get(topicDocId));
    }

    @Override
    public String getFreeTopicUrl(String docId, String tocDocId, String topicUrl) {
        String url = "";
        try (InputStream is = this.getTopicSourceView(docId, tocDocId, topicUrl);){
            if (is != null) {
                url = String.format(Locale.ENGLISH, "hdx/pages/%s/%s/%s", docId, tocDocId, topicUrl);
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "IOException when getFreeTopicUrl.", (Throwable)e);
        }
        return url;
    }

    @Override
    public String getConvertStatus(String topicDocId, String filePath) {
        return PreviewHandler.getInstance().getConvertStatus(topicDocId, filePath, HDX_RESOURCE_PATH);
    }

    private static class HdxTopicBusinessHandleerHoder {
        private static final HdxTopicBusinessHandler INSTANCE = new HdxTopicBusinessHandler();

        private HdxTopicBusinessHandleerHoder() {
        }
    }
}

