/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.navi.handler;

import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl.IcsVersionRelationPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicMetaServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicServiceHandler;
import com.huawei.support.icslite.business.ics.navi.dto.IcsTopicDto;
import com.huawei.support.icslite.business.ics.navi.dto.mapper.IcsTopicConverter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IcsNaviHandler {
    private IcsNaviHandler() {
    }

    public static IcsNaviHandler getInstance() {
        return IcsNaviHandlerHolder.INSTANCE;
    }

    public IcsTopicDto getTopicByRelationGroup(String docId, String topicId) {
        IcsTopicDto topic = IcsTopicConverter.INSTANCE.domain2dto(IcsNaviTopicServiceHandler.getInstance().getTopic(docId, topicId));
        if (topic == null || StringUtils.isBlank((CharSequence)topic.getTopicUrl())) {
            List docIdList = IcsVersionRelationPoolServiceHandler.getInstance().getRelationDocIcList(docId);
            topic = topic != null ? this.getTopicFromMeta(topicId, topic, docIdList) : this.getTopicFromPid(topicId, docIdList);
        }
        return topic;
    }

    private IcsTopicDto getTopicFromMeta(String topicId, IcsTopicDto topic, List<String> docIdList) {
        IcsTopicDto tempTopic = topic;
        for (String reDocId : docIdList) {
            IcsTopicDto reTopic = IcsTopicConverter.INSTANCE.domain2dto(IcsNaviTopicMetaServiceHandler.getInstance().getTopicByDocId(reDocId, topicId));
            if (reTopic == null || !StringUtils.isNotBlank((CharSequence)reTopic.getTopicUrl())) continue;
            tempTopic.setDocId(reDocId);
            tempTopic.setTopicUrl(reTopic.getTopicUrl());
            tempTopic.setTagsJson(reTopic.getTagsJson());
            break;
        }
        return tempTopic;
    }

    private IcsTopicDto getTopicFromPid(String topicId, List<String> docIdList) {
        IcsTopicDto topic = null;
        for (String reDocId : docIdList) {
            topic = IcsTopicConverter.INSTANCE.domain2dto(IcsNaviTopicServiceHandler.getInstance().getTopic(reDocId, topicId));
            if (topic == null || !StringUtils.isNotBlank((CharSequence)topic.getTopicUrl())) continue;
            break;
        }
        return topic;
    }

    private static class IcsNaviHandlerHolder {
        private static final IcsNaviHandler INSTANCE = new IcsNaviHandler();

        private IcsNaviHandlerHolder() {
        }
    }
}

