/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.navi.handler;

import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.icspid.service.impl.IcsPidPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicBaseDo;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviStatusServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.NaviInitServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.ics.navi.dto.mapper.IcsContentConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsNaviInitHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviInitHandler.class);

    private IcsNaviInitHandler() {
    }

    public static IcsNaviInitHandler getInstance() {
        return IcsNaviInitHandlerHolder.INSTANCE;
    }

    public void initNavi(IcsContentDo profile, Map<String, String> rePaths, boolean isUpdateDb) {
        if (profile == null) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "init navi failed, CODE:{0}", new Object[]{30100005});
            return;
        }
        String docId = profile.getDocId();
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "init navi failed, CODE:{0}", new Object[]{30100002});
            return;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "init navi start, docid:{0}", new Object[]{docId});
        List<String> pids = this.getPidsByDocId(docId);
        this.initPidStatus(docId, pids);
        boolean isSuccess = this.init(isUpdateDb, IcsContentConverter.INSTANCE.dto2do(profile), pids, rePaths);
        this.updateDocStatus(docId, profile, isSuccess);
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "init navi end, docid:{0}", new Object[]{docId});
    }

    private List<String> getPidsByDocId(String docId) {
        ArrayList pidList = new ArrayList(IcsPidPoolServiceHandler.getInstance().get(docId));
        if (CollectionUtils.isEmpty(pidList)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "init navi failed, CODE:{0}", new Object[]{30100005});
            return new ArrayList<String>();
        }
        List<String> pids = pidList.parallelStream().map(pid -> pid.getPidId()).collect(Collectors.toList());
        CodeCCUtils.INSTANCE.infoLog(LOGGER, String.format(Locale.ENGLISH, "docId:%s pidList total:%d", docId, pids.size()));
        return pids;
    }

    private boolean init(boolean isUpdateDb, IcsTopicBaseDo profile, List<String> pidList, Map<String, String> rePaths) {
        if (isUpdateDb) {
            String docId = Optional.ofNullable(profile).orElse(new IcsTopicBaseDo()).getDocId();
            NaviInitServiceHandler.getInstance().initNaviToDb(rePaths.get(docId), profile, pidList);
        }
        return NaviInitServiceHandler.getInstance().initNavi(profile, pidList, rePaths);
    }

    private void initPidStatus(String docId, List<String> pids) {
        for (String pidId : pids) {
            IcsNaviStatusDo status = new IcsNaviStatusDo();
            status.setDocId(docId);
            status.setPidId(pidId);
            if (IcsNaviStatusServiceHandler.getInstance().getPidByDocId(docId, pidId) == null) {
                status.setStatus("101");
                IcsNaviStatusServiceHandler.getInstance().add(status);
                continue;
            }
            status.setStatus("201");
            IcsNaviStatusServiceHandler.getInstance().updateStatus(status);
        }
    }

    private void updateDocStatus(String docId, IcsContentDo profile, boolean isSuccess) {
        List statusDos = IcsNaviStatusServiceHandler.getInstance().getDocStatusByDocId(docId);
        if (CollectionUtils.isNotEmpty((Collection)statusDos)) {
            for (IcsNaviStatusDo status : statusDos) {
                if (!StringUtils.equals((CharSequence)status.getStatus(), (CharSequence)"102") && !StringUtils.equals((CharSequence)status.getStatus(), (CharSequence)"202")) continue;
                String type = this.getStatus(isSuccess, status);
                status.setStatus(type);
                IcsNaviStatusServiceHandler.getInstance().updateStatus(status);
                return;
            }
        }
        IcsNaviStatusDo status = new IcsNaviStatusDo();
        status.setDocId(docId);
        status.setProjectId(profile.getProjectid());
        status.setLang(profile.getLang());
        status.setPath(profile.getPath());
        status.setIssuedate(profile.getIssueDate());
        status.setStatus(isSuccess ? "100" : "103");
        IcsNaviStatusServiceHandler.getInstance().add(status);
    }

    private String getStatus(boolean isSuccess, IcsNaviStatusDo statusDo) {
        String type = StringUtils.equals((CharSequence)statusDo.getStatus(), (CharSequence)"202") ? (isSuccess ? "200" : "203") : (StringUtils.equals((CharSequence)statusDo.getStatus(), (CharSequence)"102") ? (isSuccess ? "100" : "103") : statusDo.getStatus());
        return type;
    }

    private static class IcsNaviInitHandlerHolder {
        private static final IcsNaviInitHandler INSTANCE = new IcsNaviInitHandler();

        private IcsNaviInitHandlerHolder() {
        }
    }
}

