/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.navi.handler;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icspid.dto.IcsPidDo;
import com.huawei.support.icscbb.hwics.common.icspid.service.impl.IcsPidPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl.IcsVersionRelationPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicRelationServiceHandler;
import com.huawei.support.icslite.business.ics.navi.dto.IcsRelationDto;
import com.huawei.support.icslite.business.ics.navi.dto.IcsTopicDto;
import com.huawei.support.icslite.business.ics.navi.dto.mapper.IcsRelationConverter;
import com.huawei.support.icslite.business.ics.navi.dto.query.IcsRelationQuery;
import com.huawei.support.icslite.business.ics.navi.handler.IcsNaviHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.wsf.core.HWEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class IcsRelationHandler {
    private IcsRelationHandler() {
    }

    public static IcsRelationHandler getInstance() {
        return IcsRelationHandlerHolder.INSTANCE;
    }

    public String getRelatedRecommends(IcsRelationQuery icsRelationQuery) {
        String contextPath = icsRelationQuery.getContextPath();
        String docId = icsRelationQuery.getDocId();
        String pidId = icsRelationQuery.getPidId();
        String topicId = icsRelationQuery.getTopicId();
        HashMap map = new HashMap(16);
        ArrayList pidRelations = this.getPidRelations(docId, pidId);
        ArrayList topicRelations = IcsRelationConverter.INSTANCE.domain2dto(IcsNaviTopicRelationServiceHandler.getInstance().getRelationsByTopicId(docId, topicId));
        this.prepareRelations(contextPath, docId, pidRelations);
        this.prepareRelations(contextPath, docId, topicRelations);
        map.put("mapMeta", pidRelations == null ? new ArrayList() : pidRelations);
        map.put("mapTopic", topicRelations == null ? new ArrayList() : topicRelations);
        return JSON.toJSONString(map);
    }

    private List<IcsRelationDto> getPidRelations(String docId, String pidId) {
        IcsPidDo pidDtoForRelations = Optional.ofNullable(IcsPidPoolServiceHandler.getInstance().getOne(docId, pidId)).orElseGet(IcsPidDo::new);
        String pidDtoForRelationStr = pidDtoForRelations.getRelationsJson();
        if (StringUtils.isBlank((CharSequence)pidDtoForRelationStr)) {
            return new ArrayList<IcsRelationDto>();
        }
        pidDtoForRelationStr = pidDtoForRelationStr.replaceAll("\"pid_id\"", "\"relationPidId\"");
        pidDtoForRelationStr = pidDtoForRelationStr.replaceAll("\"projectid\"", "\"relationProjectId\"");
        return JSON.parseArray((String)pidDtoForRelationStr, IcsRelationDto.class);
    }

    private void prepareRelations(String contextpath, String docId, List<IcsRelationDto> relations) {
        if (relations != null) {
            this.putRelationElm(docId, contextpath, relations);
        }
    }

    private void putRelationElm(String docId, String contextpath, List<IcsRelationDto> relations) {
        IcsContentDo originProfile = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (originProfile == null) {
            return;
        }
        List reDocIdList = IcsVersionRelationPoolServiceHandler.getInstance().getRelationDocIcList(docId);
        for (IcsRelationDto relationDto : relations) {
            String url = relationDto.getUrl();
            String relationPid = relationDto.getRelationPidId();
            String relationTopicId = relationDto.getRelationTopicId();
            String currentDocId = relationDto.getDocId();
            if (StringUtils.isNotBlank((CharSequence)url) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{relationPid, relationTopicId})) {
                relationDto.setName(HWEncoder.encodeForHTML((String)relationDto.getName()));
                continue;
            }
            String relationDocId = docId;
            if (StringUtils.isNotBlank((CharSequence)currentDocId) && !StringUtils.equals((CharSequence)docId, (CharSequence)currentDocId)) {
                relationDocId = currentDocId;
            }
            if (StringUtils.isBlank((CharSequence)relationTopicId) && StringUtils.isNotBlank((CharSequence)relationPid)) {
                this.setPidUrl(contextpath, relationDocId, relationDto, reDocIdList);
                continue;
            }
            this.setTopicUrl(contextpath, relationDocId, relationDto);
        }
    }

    private void setTopicUrl(String contextpath, String relationDocId, IcsRelationDto relationDto) {
        String newUlr = "";
        IcsTopicDto naviTopic = IcsNaviHandler.getInstance().getTopicByRelationGroup(relationDocId, relationDto.getRelationTopicId());
        if (naviTopic != null) {
            String name = relationDto.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = naviTopic.getName();
            }
            relationDto.setName(HWEncoder.encodeForHTML((String)name));
            String reDocId = naviTopic.getDocId();
            newUlr = this.getRelationUrl(contextpath, naviTopic.getPidId(), relationDto.getRelationTopicId(), reDocId);
        }
        relationDto.setUrl(newUlr);
    }

    private void setPidUrl(String contextpath, String relationDocId, IcsRelationDto relationDto, List<String> reDocIdList) {
        String newUlr = "";
        IcsPidDo pidMetas = this.getPidByRelationGroup(relationDocId, relationDto.getRelationPidId(), reDocIdList);
        if (pidMetas != null) {
            String name = relationDto.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = pidMetas.getPidName();
            }
            relationDto.setName(HWEncoder.encodeForHTML((String)name));
            String reDocId = pidMetas.getDocId();
            newUlr = this.getRelationUrl(contextpath, relationDto.getRelationPidId(), relationDto.getRelationTopicId(), reDocId);
        }
        relationDto.setUrl(newUlr);
    }

    private IcsPidDo getPidByRelationGroup(String relationDocId, String relationPid, List<String> reDocIdList) {
        IcsPidDo pidDto = IcsPidPoolServiceHandler.getInstance().getOne(relationDocId, relationPid);
        if (pidDto != null) {
            return pidDto;
        }
        for (String reDocId : reDocIdList) {
            pidDto = IcsPidPoolServiceHandler.getInstance().getOne(reDocId, relationPid);
            if (pidDto == null) continue;
            break;
        }
        return pidDto;
    }

    private String getRelationUrl(String contextpath, String relationPidId, String relationTopicId, String docId) {
        IcsContentDo relProfile = IcsContentPoolServiceHandler.getInstance().get(docId);
        if (relProfile == null) {
            return "";
        }
        String newUlr = contextpath + I18nResources.INSTANCE.getValueByKey("browse.topic.url") + "?docid=" + docId + "&pidid=" + relationPidId;
        if (StringUtils.isNotBlank((CharSequence)relationTopicId)) {
            newUlr = newUlr + "#topicid=" + relationTopicId;
        }
        return newUlr;
    }

    private static class IcsRelationHandlerHolder {
        private static final IcsRelationHandler INSTANCE = new IcsRelationHandler();

        private IcsRelationHandlerHolder() {
        }
    }
}

