/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.navi.service.impl;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicMetaDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.QueryMetaAndFilterDto;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviStatusServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicMetaServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicRelationServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.NaviInitServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icslite.business.docexport.util.FontUtils;
import com.huawei.support.icslite.business.ics.navi.constant.TopicInfoUtils;
import com.huawei.support.icslite.business.ics.navi.dto.IcsRelationDto;
import com.huawei.support.icslite.business.ics.navi.dto.IcsTopicDto;
import com.huawei.support.icslite.business.ics.navi.dto.mapper.IcsRelationConverter;
import com.huawei.support.icslite.business.ics.navi.dto.mapper.IcsTopicConverter;
import com.huawei.support.icslite.business.ics.navi.dto.query.IcsRelationQuery;
import com.huawei.support.icslite.business.ics.navi.dto.query.IcsTopicQuery;
import com.huawei.support.icslite.business.ics.navi.handler.IcsRelationHandler;
import com.huawei.support.icslite.business.ics.navi.service.IcsNaviBusiness;
import com.huawei.support.icslite.business.ics.navi.thread.IcsInitQueueConsumer;
import com.huawei.support.icslite.business.ics.navi.thread.IcsInitQueueProducer;
import com.huawei.support.icslite.business.officepreview.dto.PreviewDto;
import com.huawei.support.icslite.business.officepreview.handler.PreviewHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.wsf.core.HWEncoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.spring.MyBatisSystemException;
import org.owasp.esapi.errors.EncodingException;
import org.springframework.dao.DataIntegrityViolationException;

public class IcsNaviBusinessHandler
implements IcsNaviBusiness {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviBusinessHandler.class);
    private static final String ICS_RESOURCE_PATH = IcsCommonServiceHandler.getInstance().getDefaultResPath() + File.separator + "ics";
    private static Map<String, Integer> naviMap = new ConcurrentHashMap<String, Integer>();
    private String icsPreviewDownload = I18nResources.INSTANCE.getValueByKey("browse.ics.topic.download.url.two.param");

    private IcsNaviBusinessHandler() {
    }

    public static IcsNaviBusinessHandler getInstance() {
        return IcsNaviBusinessHolder.INSTANCE;
    }

    @Override
    public void createNaviTb() {
        NaviInitServiceHandler.getInstance().createNaviTb();
    }

    @Override
    public void startQueue() {
        IcsInitQueueConsumer.getInstance().start();
        IcsInitQueueProducer.getInstance().start();
    }

    private void addQueue() {
        if (!IcsInitQueueProducer.getInstance().isRun()) {
            IcsInitQueueProducer.getInstance().taskStart();
        }
        IcsInitQueueProducer.getInstance().toReLoop();
    }

    @Override
    public void init(IcsContentDo profile) {
        if (profile == null || StringUtils.isBlank((CharSequence)profile.getDocId())) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Init icsNavi's param is wrong.");
            return;
        }
        IcsNaviStatusServiceHandler.getInstance().delete(profile.getDocId());
        this.addStatus(profile, "101");
        this.addQueue();
    }

    @Override
    public void updateMainDocPids(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "Update icsNavi's docId is blank.");
            return;
        }
        String status = "201";
        IcsContentDo contentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        this.addStatus(contentDo, status);
        this.addQueue();
    }

    @Override
    public int deleteByDocId(String docId) {
        try {
            if (StringUtils.isBlank((CharSequence)docId)) {
                return 30200002;
            }
            naviMap.remove(docId);
            this.deleteNaviFromTb(docId);
            IcsNaviStatusServiceHandler.getInstance().delete(docId);
        }
        catch (MyBatisSystemException | DataIntegrityViolationException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "deleteNavis error. docId:{0}", new Object[]{docId, e});
            return 30200001;
        }
        return 30200000;
    }

    private void deleteNaviFromTb(String docId) {
        IcsNaviTopicServiceHandler.getInstance().deleteByDocId(docId);
        IcsNaviTopicMetaServiceHandler.getInstance().deleteByDocId(docId);
        IcsNaviTopicRelationServiceHandler.getInstance().deleteByDocId(docId);
    }

    @Override
    public int reinitializeNavigation(String docId) {
        naviMap.put(docId, naviMap.getOrDefault(docId, 0) + 1);
        Integer times = naviMap.get(docId);
        List statusList = IcsNaviStatusServiceHandler.getInstance().getDocStatusByDocId(docId);
        for (IcsNaviStatusDo statusDo : statusList) {
            String type = statusDo.getStatus();
            if (!StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"101", "201", "102", "202"})) continue;
            return times;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "reenter navi start, docid:{0}", new Object[]{docId});
        IcsNaviStatusServiceHandler.getInstance().delete(docId);
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        this.init(icsContentDo);
        return times;
    }

    @Override
    public String getConvertStatus(String topicDocId, String filePath) {
        return PreviewHandler.getInstance().getConvertStatus(topicDocId, filePath, ICS_RESOURCE_PATH);
    }

    @Override
    public IcsTopicDto getBaseTopic(String docId, String topicId) {
        return IcsTopicConverter.INSTANCE.domain2dto(IcsNaviTopicServiceHandler.getInstance().getTopic(docId, topicId));
    }

    @Override
    public IcsTopicDto getTopicFromNavi(IcsTopicQuery icsTopicQuery) {
        IcsTopicDto result = null;
        if (StringUtils.isBlank((CharSequence)icsTopicQuery.getTopicUrl())) {
            return result;
        }
        IcsTopicMetaDo topicMeta = IcsNaviTopicMetaServiceHandler.getInstance().getTopicByTopicUrl(icsTopicQuery.getDocId(), icsTopicQuery.getTopicUrl());
        if (topicMeta == null) {
            return result;
        }
        IcsTopicDo topic = IcsNaviTopicServiceHandler.getInstance().getOneTopicInNavi(icsTopicQuery.getDocId(), icsTopicQuery.getPidId(), icsTopicQuery.getTopicId(), icsTopicQuery.getTopicUrl());
        if (topic == null) {
            return result;
        }
        try {
            topic.setPidId(HWEncoder.encodeForURL((String)topic.getPidId()));
            topic.setTopicId(HWEncoder.encodeForURL((String)topic.getTopicId()));
        }
        catch (EncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Encoding error.", (Throwable)e);
        }
        return IcsTopicConverter.INSTANCE.domain2dto(topic);
    }

    @Override
    public List<IcsRelationDto> getRelations(String docId, String topicId) {
        return IcsRelationConverter.INSTANCE.domain2dto(IcsNaviTopicRelationServiceHandler.getInstance().getRelationsByTopicId(docId, topicId));
    }

    @Override
    public String getRelatedRecommends(IcsRelationQuery icsRelationQuery) {
        return IcsRelationHandler.getInstance().getRelatedRecommends(icsRelationQuery);
    }

    @Override
    public InputStream topicSourceView(String docId, String filePath) throws IOException {
        IcsContentDo profile = Optional.ofNullable(IcsContentPoolServiceHandler.getInstance().get(docId)).orElse(new IcsContentDo());
        String officeDownloadUrl = String.format(Locale.ENGLISH, this.icsPreviewDownload, docId, filePath);
        PreviewDto previewDto = new PreviewDto().setLibPath(profile.getPath()).setFilePath(filePath);
        IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(docId);
        previewDto.setFontsDir(FontUtils.getFontsPath(icsContentDo == null ? "en" : icsContentDo.getLang()));
        return PreviewHandler.getInstance().getTopicSourceView(previewDto, docId, ICS_RESOURCE_PATH, officeDownloadUrl);
    }

    @Override
    public InputStream topicSourceStream(String docId, String filePath) throws IOException {
        IcsContentDo profile = Optional.ofNullable(IcsContentPoolServiceHandler.getInstance().get(docId)).orElse(new IcsContentDo());
        return ZipFilePool.getInputStream((String)profile.getPath(), (String)filePath);
    }

    @Override
    public String getAll(IcsTopicQuery icsTopicQuery) {
        if (icsTopicQuery == null) {
            return "";
        }
        String loadStatus = this.getLibLoadStatus(icsTopicQuery);
        if (StringUtils.isNotBlank((CharSequence)loadStatus)) {
            return loadStatus;
        }
        return this.getNavJson(icsTopicQuery);
    }

    private String getLibLoadStatus(IcsTopicQuery icsTopicQuery) {
        String statusDocId = icsTopicQuery.getStatusDocId();
        String pidStatus = this.getPidStatus(statusDocId, icsTopicQuery.getPidId());
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)pidStatus)) {
            String docStatus = this.getPidStatus(statusDocId, null);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)docStatus)) {
                return pidStatus;
            }
            return docStatus;
        }
        return "";
    }

    private String getNavJson(IcsTopicQuery icsTopicQuery) {
        String navJson = this.getNavWithQms(icsTopicQuery);
        if (StringUtils.isBlank((CharSequence)navJson)) {
            navJson = this.getNavWithTopic(icsTopicQuery);
        }
        if (StringUtils.isBlank((CharSequence)navJson)) {
            navJson = this.getNavWithPid(icsTopicQuery);
        }
        return navJson;
    }

    private String getNavWithQms(IcsTopicQuery icsTopicQuery) {
        List<QueryMetaAndFilterDto> qmsList = TopicInfoUtils.qmsFilter(TopicInfoUtils.qmsHandle(icsTopicQuery.getQms()));
        if (CollectionUtils.isEmpty(qmsList)) {
            return "";
        }
        return IcsNaviTopicServiceHandler.getInstance().getAll(icsTopicQuery.getDocId(), icsTopicQuery.getRealRelationDocId(), icsTopicQuery.getPidId(), qmsList);
    }

    private String getNavWithTopic(IcsTopicQuery icsTopicQuery) {
        String topicId = icsTopicQuery.getTopicId();
        if (StringUtils.isBlank((CharSequence)topicId)) {
            return "";
        }
        return IcsNaviTopicServiceHandler.getInstance().getByTopicId(icsTopicQuery.getDocId(), icsTopicQuery.getRealRelationDocId(), icsTopicQuery.getPidId(), topicId);
    }

    private String getNavWithPid(IcsTopicQuery icsTopicQuery) {
        return IcsNaviTopicServiceHandler.getInstance().getFirstFloor(icsTopicQuery.getDocId(), icsTopicQuery.getRealRelationDocId(), icsTopicQuery.getPidId());
    }

    @Override
    public String getChilds(String maindDocId, String docId, String pidId, String position) {
        return IcsNaviTopicServiceHandler.getInstance().getChilds(maindDocId, StringUtils.isBlank((CharSequence)docId) ? maindDocId : docId, pidId, position);
    }

    @Override
    public String getByTopicUrl(String maindDocId, String docId, String pidId, String topicUrl) {
        return IcsNaviTopicServiceHandler.getInstance().getByTopicUrl(maindDocId, StringUtils.isBlank((CharSequence)docId) ? maindDocId : docId, pidId, topicUrl);
    }

    @Override
    public void deleteRedundancyFile() {
        File icsFile = FileUtils.getFile((String[])new String[]{IcsLiteStorageAdapter.INSTANCE.getIcsNavPath()});
        if (!IcsFileUtils.isDirectory((File)icsFile)) {
            return;
        }
        Object[] docFiles = icsFile.listFiles();
        if (ArrayUtils.isEmpty((Object[])docFiles)) {
            FileUtils.deleteQuietly((File)icsFile);
            return;
        }
        for (Object docFile : docFiles) {
            File deleteFile;
            String name = ((File)docFile).getName();
            IcsContentDo profile = IcsContentPoolServiceHandler.getInstance().get(name);
            if (profile != null || !IcsFileUtils.delFileOrDir((File)(deleteFile = this.getDeleteFile((File)docFile)), (String)IcsLiteStorageAdapter.INSTANCE.getIcsNavPath())) continue;
            this.deleteByDocId(name);
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "delete nav directory success. ics directoryname:" + ((File)docFile).getName());
        }
    }

    private File getDeleteFile(File docFile) {
        Object delFile = null;
        if (docFile == null || !docFile.isDirectory()) {
            return delFile;
        }
        Object[] files = docFile.listFiles();
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)((File)file).getName(), (CharSequence)"nav")) continue;
                delFile = file;
                break;
            }
        }
        return delFile;
    }

    private String getPidStatus(String docId, String pidId) {
        IcsNaviStatusDo pid = IcsNaviStatusServiceHandler.getInstance().getPidByDocId(docId, pidId);
        String status = "2";
        if (pid != null) {
            switch (pid.getStatus()) {
                case "200": 
                case "100": {
                    status = "0";
                    break;
                }
                case "101": 
                case "202": 
                case "201": 
                case "102": {
                    status = "1";
                    break;
                }
                case "103": 
                case "203": {
                    status = "2";
                    break;
                }
            }
        }
        return status;
    }

    @Override
    public void continueInitNavi() {
        Set allDocId = IcsContentPoolServiceHandler.getInstance().getAllDocId();
        allDocId.forEach(docId -> {
            List docDo = IcsNaviStatusServiceHandler.getInstance().getDocStatusByDocId(docId);
            if (CollectionUtils.isEmpty((Collection)docDo)) {
                this.addStatus(IcsContentPoolServiceHandler.getInstance().get(docId), "101");
            }
        });
        List unFinishedDocIds = IcsNaviStatusServiceHandler.getInstance().getDocIdsByStatus(Arrays.asList("101", "102", "201", "202"));
        unFinishedDocIds.forEach(docId -> this.processDocId((String)docId));
        this.addQueue();
    }

    private void processDocId(String docId) {
        List status = IcsNaviStatusServiceHandler.getInstance().getDocStatusByDocId(docId);
        for (IcsNaviStatusDo statusDo : status) {
            String str = statusDo.getStatus();
            if (StringUtils.equals((CharSequence)str, (CharSequence)"102")) {
                statusDo.setStatus("101");
                IcsNaviStatusServiceHandler.getInstance().updateStatus(statusDo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)str, (CharSequence)"202")) continue;
            statusDo.setStatus("201");
            IcsNaviStatusServiceHandler.getInstance().updateStatus(statusDo);
        }
    }

    private void addStatus(IcsContentDo contentDo, String status) {
        if (contentDo == null) {
            return;
        }
        IcsNaviStatusDo statusDo = this.createIcsNaviStatusDo(contentDo, status);
        IcsNaviStatusServiceHandler.getInstance().add(statusDo);
    }

    private IcsNaviStatusDo createIcsNaviStatusDo(IcsContentDo contentDo, String status) {
        IcsNaviStatusDo statusDo = new IcsNaviStatusDo();
        statusDo.setDocId(contentDo.getDocId());
        statusDo.setProjectId(contentDo.getProjectid());
        statusDo.setLang(contentDo.getLang());
        statusDo.setPath(contentDo.getPath());
        statusDo.setIssuedate(contentDo.getIssueDate());
        statusDo.setStatus(status);
        return statusDo;
    }

    private static class IcsNaviBusinessHolder {
        private static final IcsNaviBusinessHandler INSTANCE = new IcsNaviBusinessHandler();

        private IcsNaviBusinessHolder() {
        }
    }
}

