/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.navi.thread;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.support.icscbb.hwics.common.content.dto.IcsContentDo;
import com.huawei.support.icscbb.hwics.common.content.service.impl.IcsContentPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.icsversionrelation.service.impl.IcsVersionRelationPoolServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviStatusServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.eventbus.EventBusUtils;
import com.huawei.support.icslite.business.doubleclicklib.entity.message.DoubleClickSceneMessage;
import com.huawei.support.icslite.business.ics.navi.dto.QueueConsumerDo;
import com.huawei.support.icslite.business.ics.navi.handler.IcsNaviInitHandler;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.lang3.StringUtils;

public class IcsInitQueueConsumer
extends Thread {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsInitQueueConsumer.class);
    private static final PriorityBlockingQueue<QueueConsumerDo> QUEUE = new PriorityBlockingQueue(1);
    private final AsyncEventBus eventBus = EventBusUtils.INSTANCE.getEventBus();

    private IcsInitQueueConsumer() {
        super.setName("IcsInitQueueConsumer");
    }

    public static IcsInitQueueConsumer getInstance() {
        return IcsInitQueueConsumerHolder.INSTANCE;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    QueueConsumerDo task;
                    String docId;
                    if (StringUtils.isBlank((CharSequence)(docId = (task = QUEUE.take()).getDocId()))) {
                        continue;
                    }
                    IcsContentDo profile = this.getProfile(docId);
                    Map<String, String> rePaths = this.getVersionRelationsPathMap(profile);
                    IcsNaviInitHandler.getInstance().initNavi(profile, rePaths, task.isUpdateDb());
                    if (!IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().containsValue(docId)) continue;
                    this.eventBus.post((Object)new DoubleClickSceneMessage("0", profile.getPath()));
                }
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "HdxInitQueueConsumer Exception: ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private IcsContentDo getProfile(String docId) {
        IcsNaviStatusDo statusDo = IcsNaviStatusServiceHandler.getInstance().getPidByDocId(docId, null);
        IcsContentDo profile = new IcsContentDo();
        profile.setDocId(statusDo.getDocId());
        profile.setProjectid(statusDo.getProjectId());
        profile.setLang(statusDo.getLang());
        profile.setPath(statusDo.getPath());
        profile.setIssueDate(statusDo.getIssuedate());
        return profile;
    }

    public void queueAdd(QueueConsumerDo queueDo) {
        QUEUE.put(queueDo);
    }

    private Map<String, String> getVersionRelationsPathMap(IcsContentDo profile) {
        LinkedHashMap<String, String> rePaths = new LinkedHashMap<String, String>();
        if (profile == null) {
            return rePaths;
        }
        String docId = profile.getDocId();
        rePaths.put(docId, profile.getPath());
        List reDocIds = IcsVersionRelationPoolServiceHandler.getInstance().getRelationDocIcList(docId);
        for (String reDocId : reDocIds) {
            IcsContentDo icsContentDo = IcsContentPoolServiceHandler.getInstance().get(reDocId);
            if (icsContentDo == null) continue;
            rePaths.put(reDocId, icsContentDo.getPath());
        }
        return rePaths;
    }

    private static class IcsInitQueueConsumerHolder {
        private static final IcsInitQueueConsumer INSTANCE = new IcsInitQueueConsumer();

        private IcsInitQueueConsumerHolder() {
        }
    }
}

