/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.business.ics.navi.thread;

import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviStatusServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicMetaServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.business.ics.navi.dto.QueueConsumerDo;
import com.huawei.support.icslite.business.ics.navi.thread.IcsInitQueueConsumer;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsInitQueueProducer
extends Thread {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsInitQueueProducer.class);
    private static final int MAX_PRIORITY_NUM = 0;
    private final Lock icsInitLock = new ReentrantLock();
    private final Condition icsInitCondition = this.icsInitLock.newCondition();
    private AtomicBoolean reLoop;
    private AtomicBoolean isRun;
    private List<String> initStatus;
    private List<String> updateStatus;
    private int taskPriorityNum = 0;

    private IcsInitQueueProducer() {
        super.setName("IcsInitQueueProducer");
        this.reLoop = new AtomicBoolean(false);
        this.isRun = new AtomicBoolean(true);
        this.initStatus = Arrays.asList("101");
        this.updateStatus = Arrays.asList("201");
    }

    public static IcsInitQueueProducer getInstance() {
        return IcsInitQueueProducerHolder.INSTANCE;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.reLoop.set(false);
                    List initDocIds = IcsNaviStatusServiceHandler.getInstance().getDocIdsByStatus(this.initStatus);
                    List updateDocIds = IcsNaviStatusServiceHandler.getInstance().getDocIdsByStatus(this.updateStatus);
                    this.addToQueue(initDocIds, "102", false);
                    this.addToQueue(updateDocIds, "202", true);
                    if (this.reLoop.get()) continue;
                    this.taskAwait();
                }
            }
            catch (Exception e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "IcsInitQueueProducer Exception: ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void addToQueue(List<String> initDocIds, String status, boolean isUpdate) throws InterruptedException {
        if (CollectionUtils.isNotEmpty(initDocIds)) {
            for (String docId : initDocIds) {
                QueueConsumerDo queueDo = new QueueConsumerDo();
                queueDo.setDocId(docId);
                IcsTopicDo topic = IcsNaviTopicMetaServiceHandler.getInstance().getTopicByDocId(docId, null);
                queueDo.setUpdateDb(topic == null);
                if (this.isDoubleClickTask(docId)) {
                    queueDo.setFirstPriorityNum(0);
                } else {
                    queueDo.setFirstPriorityNum(this.taskPriorityNum++);
                }
                this.updateStatus(docId, status, isUpdate);
                IcsInitQueueConsumer.getInstance().queueAdd(queueDo);
            }
        }
    }

    private boolean isDoubleClickTask(String docId) {
        return IcsCommonServiceHandler.getInstance().getDoubleClickLibPathPool().containsValue(docId);
    }

    private void updateStatus(String docId, String status, boolean isUpdate) {
        List statusDos = IcsNaviStatusServiceHandler.getInstance().getDocStatusByDocId(docId);
        if (CollectionUtils.isEmpty((Collection)statusDos)) {
            return;
        }
        IcsNaviStatusDo statusDo = IcsNaviStatusServiceHandler.getInstance().getPidByDocId(docId, null);
        for (IcsNaviStatusDo statusDto : statusDos) {
            if (isUpdate && StringUtils.equals((CharSequence)statusDto.getStatus(), (CharSequence)"201")) {
                statusDo = statusDto;
                break;
            }
            if (isUpdate || !StringUtils.equals((CharSequence)statusDto.getStatus(), (CharSequence)"101")) continue;
            statusDo = statusDto;
            break;
        }
        if (statusDo == null) {
            return;
        }
        statusDo.setStatus(status);
        IcsNaviStatusServiceHandler.getInstance().updateStatus(statusDo);
    }

    public void taskStart() {
        this.icsInitLock.lock();
        try {
            this.isRun.set(true);
            this.icsInitCondition.signal();
        }
        finally {
            this.icsInitLock.unlock();
        }
    }

    private void taskAwait() {
        this.icsInitLock.lock();
        try {
            this.isRun.set(false);
            this.icsInitCondition.await();
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "hdx producer await: ", (Throwable)e);
        }
        finally {
            this.icsInitLock.unlock();
        }
    }

    public boolean isRun() {
        boolean rst;
        this.icsInitLock.lock();
        try {
            rst = this.isRun.get();
        }
        finally {
            this.icsInitLock.unlock();
        }
        return rst;
    }

    public void toReLoop() {
        this.reLoop.set(true);
    }

    private static class IcsInitQueueProducerHolder {
        private static final IcsInitQueueProducer INSTANCE = new IcsInitQueueProducer();

        private IcsInitQueueProducerHolder() {
        }
    }
}

